/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.action.DeleteDataFrameTransformAction;

public class RestDeleteDataFrameTransformAction
extends BaseRestHandler {
    public RestDeleteDataFrameTransformAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.DELETE, "/_data_frame/transforms/{id}/", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        if (restRequest.hasContent()) {
            throw new IllegalArgumentException("delete data frame transforms requests can not have a request body");
        }
        String id = restRequest.param(DataFrameField.ID.getPreferredName());
        boolean force = restRequest.paramAsBoolean(DataFrameField.FORCE.getPreferredName(), false);
        DeleteDataFrameTransformAction.Request request = new DeleteDataFrameTransformAction.Request(id, force);
        return channel -> client.execute((ActionType)DeleteDataFrameTransformAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    public String getName() {
        return "data_frame_delete_transform_action";
    }
}

