/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.checkpoint;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameIndexerPosition;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformCheckpointingInfo;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformProgress;
import org.elasticsearch.xpack.core.dataframe.transforms.TimeSyncConfig;
import org.elasticsearch.xpack.dataframe.checkpoint.CheckpointException;
import org.elasticsearch.xpack.dataframe.checkpoint.CheckpointProvider;
import org.elasticsearch.xpack.dataframe.checkpoint.DefaultCheckpointProvider;
import org.elasticsearch.xpack.dataframe.checkpoint.TimeBasedCheckpointProvider;
import org.elasticsearch.xpack.dataframe.notifications.DataFrameAuditor;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;

public class DataFrameTransformsCheckpointService {
    private static final Logger logger = LogManager.getLogger(DataFrameTransformsCheckpointService.class);
    private final Client client;
    private final DataFrameTransformsConfigManager dataFrameTransformsConfigManager;
    private final DataFrameAuditor dataFrameAuditor;

    public DataFrameTransformsCheckpointService(Client client, DataFrameTransformsConfigManager dataFrameTransformsConfigManager, DataFrameAuditor dataFrameAuditor) {
        this.client = client;
        this.dataFrameTransformsConfigManager = dataFrameTransformsConfigManager;
        this.dataFrameAuditor = dataFrameAuditor;
    }

    public CheckpointProvider getCheckpointProvider(DataFrameTransformConfig transformConfig) {
        if (transformConfig.getSyncConfig() instanceof TimeSyncConfig) {
            return new TimeBasedCheckpointProvider(this.client, this.dataFrameTransformsConfigManager, this.dataFrameAuditor, transformConfig);
        }
        return new DefaultCheckpointProvider(this.client, this.dataFrameTransformsConfigManager, this.dataFrameAuditor, transformConfig);
    }

    public void getCheckpointingInfo(String transformId, long lastCheckpointNumber, DataFrameIndexerPosition nextCheckpointPosition, DataFrameTransformProgress nextCheckpointProgress, ActionListener<DataFrameTransformCheckpointingInfo> listener) {
        this.dataFrameTransformsConfigManager.getTransformConfiguration(transformId, (ActionListener<DataFrameTransformConfig>)ActionListener.wrap(transformConfig -> this.getCheckpointProvider((DataFrameTransformConfig)transformConfig).getCheckpointingInfo(lastCheckpointNumber, nextCheckpointPosition, nextCheckpointProgress, listener), transformError -> {
            logger.warn("Failed to retrieve configuration for data frame [" + transformId + "]", (Throwable)transformError);
            listener.onFailure((Exception)((Object)new CheckpointException("Failed to retrieve configuration", (Throwable)transformError, new Object[0])));
        }));
    }
}

