/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.action;

import java.io.IOException;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.dataframe.action.UpdateDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfigUpdate;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.dataframe.action.TransportPutDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.notifications.DataFrameAuditor;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;
import org.elasticsearch.xpack.dataframe.persistence.DataframeIndex;
import org.elasticsearch.xpack.dataframe.transforms.SourceDestValidator;
import org.elasticsearch.xpack.dataframe.transforms.pivot.Pivot;

public class TransportUpdateDataFrameTransformAction
extends TransportMasterNodeAction<UpdateDataFrameTransformAction.Request, UpdateDataFrameTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateDataFrameTransformAction.class);
    private final XPackLicenseState licenseState;
    private final Client client;
    private final DataFrameTransformsConfigManager dataFrameTransformsConfigManager;
    private final SecurityContext securityContext;
    private final DataFrameAuditor auditor;

    @Inject
    public TransportUpdateDataFrameTransformAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, XPackLicenseState licenseState, DataFrameTransformsConfigManager dataFrameTransformsConfigManager, Client client, DataFrameAuditor auditor) {
        super("cluster:admin/data_frame/update", transportService, clusterService, threadPool, actionFilters, UpdateDataFrameTransformAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.client = client;
        this.dataFrameTransformsConfigManager = dataFrameTransformsConfigManager;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.auditor = auditor;
    }

    protected String executor() {
        return "same";
    }

    protected UpdateDataFrameTransformAction.Response read(StreamInput in) throws IOException {
        return new UpdateDataFrameTransformAction.Response(in);
    }

    protected void masterOperation(UpdateDataFrameTransformAction.Request request, ClusterState clusterState, ActionListener<UpdateDataFrameTransformAction.Response> listener) {
        if (!this.licenseState.isDataFrameAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"data_frame"));
            return;
        }
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
        Map<String, String> filteredHeaders = this.threadPool.getThreadContext().getHeaders().entrySet().stream().filter(e -> ClientHelper.SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        DataFrameTransformConfigUpdate update = request.getUpdate();
        update.setHeaders(filteredHeaders);
        this.dataFrameTransformsConfigManager.getTransformConfigurationForUpdate(request.getId(), (ActionListener<Tuple<DataFrameTransformConfig, DataFrameTransformsConfigManager.SeqNoPrimaryTermAndIndex>>)ActionListener.wrap(configAndVersion -> {
            DataFrameTransformConfig config = (DataFrameTransformConfig)configAndVersion.v1();
            if (update.isNoop(config)) {
                listener.onResponse((Object)new UpdateDataFrameTransformAction.Response(config));
                return;
            }
            DataFrameTransformConfig updatedConfig = update.apply(config);
            this.validateAndUpdateDataFrame(request, clusterState, updatedConfig, (DataFrameTransformsConfigManager.SeqNoPrimaryTermAndIndex)configAndVersion.v2(), listener);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(UpdateDataFrameTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void handlePrivsResponse(String username, UpdateDataFrameTransformAction.Request request, DataFrameTransformConfig config, DataFrameTransformsConfigManager.SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, ClusterState clusterState, HasPrivilegesResponse privilegesResponse, ActionListener<UpdateDataFrameTransformAction.Response> listener) {
        if (privilegesResponse.isCompleteMatch()) {
            this.updateDataFrame(request, config, seqNoPrimaryTermAndIndex, clusterState, listener);
        } else {
            List indices = privilegesResponse.getIndexPrivileges().stream().map(ResourcePrivileges::getResource).collect(Collectors.toList());
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot update data frame transform [{}] because user {} lacks all the required permissions for indices: {}", (Object[])new Object[]{request.getId(), username, indices}));
        }
    }

    private void validateAndUpdateDataFrame(UpdateDataFrameTransformAction.Request request, ClusterState clusterState, DataFrameTransformConfig config, DataFrameTransformsConfigManager.SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, ActionListener<UpdateDataFrameTransformAction.Response> listener) {
        try {
            SourceDestValidator.validate(config, clusterState, this.indexNameExpressionResolver, request.isDeferValidation());
        }
        catch (ElasticsearchStatusException ex) {
            listener.onFailure((Exception)((Object)ex));
            return;
        }
        if (this.licenseState.isAuthAllowed() && !request.isDeferValidation()) {
            String username = this.securityContext.getUser().principal();
            HasPrivilegesRequest privRequest = TransportPutDataFrameTransformAction.buildPrivilegeCheck(config, this.indexNameExpressionResolver, clusterState, username);
            ActionListener privResponseListener = ActionListener.wrap(r -> this.handlePrivsResponse(username, request, config, seqNoPrimaryTermAndIndex, clusterState, (HasPrivilegesResponse)r, listener), arg_0 -> listener.onFailure(arg_0));
            this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
        } else {
            this.updateDataFrame(request, config, seqNoPrimaryTermAndIndex, clusterState, listener);
        }
    }

    private void updateDataFrame(UpdateDataFrameTransformAction.Request request, DataFrameTransformConfig config, DataFrameTransformsConfigManager.SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, ClusterState clusterState, ActionListener<UpdateDataFrameTransformAction.Response> listener) {
        Pivot pivot = new Pivot(config.getPivotConfig());
        ActionListener putTransformConfigurationListener = ActionListener.wrap(putTransformConfigurationResult -> {
            this.auditor.info(config.getId(), "updated data frame transform.");
            this.dataFrameTransformsConfigManager.deleteOldTransformConfigurations(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                logger.trace("[{}] successfully deleted old transform configurations", (Object)request.getId());
                listener.onResponse((Object)new UpdateDataFrameTransformAction.Response(config));
            }, e -> {
                logger.warn(LoggerMessageFormat.format((String)"[{}] failed deleting old transform configurations.", (String)request.getId(), (Object[])new Object[0]), (Throwable)e);
                listener.onResponse((Object)new UpdateDataFrameTransformAction.Response(config));
            }));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener createDestinationListener = ActionListener.wrap(createDestResponse -> this.dataFrameTransformsConfigManager.updateTransformConfiguration(config, seqNoPrimaryTermAndIndex, (ActionListener<Boolean>)putTransformConfigurationListener), arg_0 -> listener.onFailure(arg_0));
        ActionListener pivotValidationListener = ActionListener.wrap(validationResult -> {
            String[] dest = this.indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{config.getDestination().getIndex()});
            String[] src = this.indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), config.getSource().getIndex());
            if (PersistentTasksCustomMetaData.getTaskWithId((ClusterState)clusterState, (String)request.getId()) != null && dest.length == 0 && src.length > 0) {
                this.createDestination(pivot, config, (ActionListener<Void>)createDestinationListener);
            } else {
                createDestinationListener.onResponse(null);
            }
        }, validationException -> {
            if (validationException instanceof ElasticsearchStatusException) {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate data frame configuration", ((ElasticsearchStatusException)((Object)((Object)validationException))).status(), (Throwable)validationException, new Object[0])));
            } else {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate data frame configuration", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)validationException, new Object[0])));
            }
        });
        try {
            pivot.validateConfig();
        }
        catch (ElasticsearchStatusException e) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate data frame configuration", e.status(), (Throwable)e, new Object[0])));
            return;
        }
        catch (Exception e) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate data frame configuration", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0])));
            return;
        }
        if (request.isDeferValidation()) {
            pivotValidationListener.onResponse((Object)true);
        } else {
            pivot.validateQuery(this.client, config.getSource(), (ActionListener<Boolean>)pivotValidationListener);
        }
    }

    private void createDestination(Pivot pivot, DataFrameTransformConfig config, ActionListener<Void> listener) {
        ActionListener deduceMappingsListener = ActionListener.wrap(mappings -> DataframeIndex.createDestinationIndex(this.client, Clock.systemUTC(), config, mappings, (ActionListener<Boolean>)ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), deduceTargetMappingsException -> listener.onFailure((Exception)new RuntimeException("Failed to deduce dest mappings", (Throwable)deduceTargetMappingsException)));
        pivot.deduceMappings(this.client, config.getSource(), (ActionListener<Map<String, String>>)deduceMappingsListener);
    }
}

