/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.dataframe.DataFrameMessages;
import org.elasticsearch.xpack.core.dataframe.action.StopDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformState;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformTaskState;
import org.elasticsearch.xpack.dataframe.action.DataFrameNodes;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;
import org.elasticsearch.xpack.dataframe.transforms.DataFrameTransformTask;

public class TransportStopDataFrameTransformAction
extends TransportTasksAction<DataFrameTransformTask, StopDataFrameTransformAction.Request, StopDataFrameTransformAction.Response, StopDataFrameTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportStopDataFrameTransformAction.class);
    private final ThreadPool threadPool;
    private final DataFrameTransformsConfigManager dataFrameTransformsConfigManager;
    private final PersistentTasksService persistentTasksService;
    private final Client client;

    @Inject
    public TransportStopDataFrameTransformAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, PersistentTasksService persistentTasksService, DataFrameTransformsConfigManager dataFrameTransformsConfigManager, Client client) {
        super("cluster:admin/data_frame/stop", clusterService, transportService, actionFilters, StopDataFrameTransformAction.Request::new, StopDataFrameTransformAction.Response::new, StopDataFrameTransformAction.Response::new, "same");
        this.threadPool = threadPool;
        this.dataFrameTransformsConfigManager = dataFrameTransformsConfigManager;
        this.persistentTasksService = persistentTasksService;
        this.client = client;
    }

    static void validateTaskState(ClusterState state, List<String> transformIds, boolean isForce) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.metaData().custom("persistent_tasks");
        if (!isForce && tasks != null) {
            ArrayList<String> failedTasks = new ArrayList<String>();
            ArrayList<String> failedReasons = new ArrayList<String>();
            for (String transformId : transformIds) {
                PersistentTasksCustomMetaData.PersistentTask dfTask = tasks.getTask(transformId);
                if (dfTask == null || !(dfTask.getState() instanceof DataFrameTransformState) || ((DataFrameTransformState)dfTask.getState()).getTaskState() != DataFrameTransformTaskState.FAILED) continue;
                failedTasks.add(transformId);
                failedReasons.add(((DataFrameTransformState)dfTask.getState()).getReason());
            }
            if (!failedTasks.isEmpty()) {
                String msg = failedTasks.size() == 1 ? DataFrameMessages.getMessage((String)"Unable to stop data frame transform [{0}] as it is in a failed state with reason [{1}]. Use force stop to stop the data frame transform.", (Object[])new Object[]{failedTasks.get(0), failedReasons.get(0)}) : "Unable to stop data frame transforms. The following transforms are in a failed state " + failedTasks + " with reasons " + failedReasons + ". Use force stop to stop the data frame transforms.";
                throw new ElasticsearchStatusException(msg, RestStatus.CONFLICT, new Object[0]);
            }
        }
    }

    protected void doExecute(Task task, StopDataFrameTransformAction.Request request, ActionListener<StopDataFrameTransformAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException("no known master node"));
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, StopDataFrameTransformAction.Response::new));
            }
        } else {
            ActionListener<StopDataFrameTransformAction.Response> finalListener = request.waitForCompletion() ? this.waitForStopListener(request, listener) : listener;
            this.dataFrameTransformsConfigManager.expandTransformIds(request.getId(), new PageParams(0, 10000), request.isAllowNoMatch(), (ActionListener<Tuple<Long, List<String>>>)ActionListener.wrap(hitsAndIds -> {
                TransportStopDataFrameTransformAction.validateTaskState(state, (List)hitsAndIds.v2(), request.isForce());
                request.setExpandedIds(new HashSet((Collection)hitsAndIds.v2()));
                request.setNodes(DataFrameNodes.dataFrameTaskNodes((List)hitsAndIds.v2(), state));
                super.doExecute(task, (BaseTasksRequest)request, finalListener);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    protected void taskOperation(StopDataFrameTransformAction.Request request, DataFrameTransformTask transformTask, ActionListener<StopDataFrameTransformAction.Response> listener) {
        Set ids = request.getExpandedIds();
        if (ids == null) {
            listener.onFailure((Exception)new IllegalStateException("Request does not have expandedIds set"));
            return;
        }
        if (ids.contains(transformTask.getTransformId())) {
            try {
                transformTask.stop(request.isForce());
            }
            catch (ElasticsearchException ex) {
                listener.onFailure((Exception)((Object)ex));
                return;
            }
            listener.onResponse((Object)new StopDataFrameTransformAction.Response(Boolean.TRUE.booleanValue()));
        } else {
            listener.onFailure((Exception)new RuntimeException("ID of data frame indexer task [" + transformTask.getTransformId() + "] does not match request's ID [" + request.getId() + "]"));
        }
    }

    protected StopDataFrameTransformAction.Response newResponse(StopDataFrameTransformAction.Request request, List<StopDataFrameTransformAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty() || !failedNodeExceptions.isEmpty()) {
            return new StopDataFrameTransformAction.Response(taskOperationFailures, failedNodeExceptions, false);
        }
        return new StopDataFrameTransformAction.Response(tasks.stream().allMatch(StopDataFrameTransformAction.Response::isAcknowledged));
    }

    private ActionListener<StopDataFrameTransformAction.Response> waitForStopListener(StopDataFrameTransformAction.Request request, ActionListener<StopDataFrameTransformAction.Response> listener) {
        ActionListener onStopListener = ActionListener.wrap(waitResponse -> this.client.admin().indices().prepareRefresh(new String[]{".data-frame-internal-2"}).execute(ActionListener.wrap(r -> listener.onResponse(waitResponse), e -> {
            logger.info("Failed to refresh internal index after delete", (Throwable)e);
            listener.onResponse(waitResponse);
        })), arg_0 -> listener.onFailure(arg_0));
        return ActionListener.wrap(response -> this.threadPool.generic().execute(() -> this.waitForDataFrameStopped(request.getExpandedIds(), request.getTimeout(), request.isForce(), (ActionListener<StopDataFrameTransformAction.Response>)onStopListener)), arg_0 -> listener.onFailure(arg_0));
    }

    private void waitForDataFrameStopped(Set<String> persistentTaskIds, TimeValue timeout, boolean force, ActionListener<StopDataFrameTransformAction.Response> listener) {
        ConcurrentHashMap exceptions = new ConcurrentHashMap();
        this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetaData -> {
            if (persistentTasksCustomMetaData == null) {
                return true;
            }
            for (String persistentTaskId : persistentTaskIds) {
                PersistentTasksCustomMetaData.PersistentTask transformsTask = persistentTasksCustomMetaData.getTask(persistentTaskId);
                if (transformsTask == null || exceptions.containsKey(persistentTaskId)) continue;
                DataFrameTransformState taskState = (DataFrameTransformState)transformsTask.getState();
                if (!force && taskState != null && taskState.getTaskState() == DataFrameTransformTaskState.FAILED) {
                    exceptions.put(persistentTaskId, new ElasticsearchStatusException(DataFrameMessages.getMessage((String)"Unable to stop data frame transform [{0}] as it is in a failed state with reason [{1}]. Use force stop to stop the data frame transform.", (Object[])new Object[]{persistentTaskId, taskState.getReason()}), RestStatus.CONFLICT, new Object[0]));
                    return persistentTasksCustomMetaData.tasks().stream().allMatch(p -> exceptions.containsKey(p.getId()));
                }
                return false;
            }
            return true;
        }, timeout, ActionListener.wrap(r -> {
            if (exceptions.isEmpty()) {
                listener.onResponse((Object)new StopDataFrameTransformAction.Response(Boolean.TRUE.booleanValue()));
                return;
            }
            if (persistentTaskIds.size() == 1) {
                listener.onFailure((Exception)exceptions.get(persistentTaskIds.iterator().next()));
                return;
            }
            HashSet stoppedTasks = new HashSet(persistentTaskIds);
            stoppedTasks.removeAll(exceptions.keySet());
            String message = stoppedTasks.isEmpty() ? "Could not stop any of the tasks as all were failed. Use force stop to stop the transforms." : LoggerMessageFormat.format((String)"Successfully stopped [{}] transforms. Could not stop the transforms {} as they were failed. Use force stop to stop the transforms.", (Object[])new Object[]{stoppedTasks.size(), exceptions.keySet()});
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException(message, RestStatus.CONFLICT, new Object[0])));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

