/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.action;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.dataframe.DataFrameMessages;
import org.elasticsearch.xpack.core.dataframe.action.PutDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.dataframe.notifications.DataFrameAuditor;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;
import org.elasticsearch.xpack.dataframe.transforms.SourceDestValidator;
import org.elasticsearch.xpack.dataframe.transforms.pivot.Pivot;

public class TransportPutDataFrameTransformAction
extends TransportMasterNodeAction<PutDataFrameTransformAction.Request, AcknowledgedResponse> {
    private final XPackLicenseState licenseState;
    private final Client client;
    private final DataFrameTransformsConfigManager dataFrameTransformsConfigManager;
    private final SecurityContext securityContext;
    private final DataFrameAuditor auditor;

    @Inject
    public TransportPutDataFrameTransformAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, XPackLicenseState licenseState, DataFrameTransformsConfigManager dataFrameTransformsConfigManager, Client client, DataFrameAuditor auditor) {
        super("cluster:admin/data_frame/put", transportService, clusterService, threadPool, actionFilters, PutDataFrameTransformAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.client = client;
        this.dataFrameTransformsConfigManager = dataFrameTransformsConfigManager;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.auditor = auditor;
    }

    static HasPrivilegesRequest buildPrivilegeCheck(DataFrameTransformConfig config, IndexNameExpressionResolver indexNameExpressionResolver, ClusterState clusterState, String username) {
        String destIndex = config.getDestination().getIndex();
        String[] concreteDest = indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{config.getDestination().getIndex()});
        ArrayList<String> srcPrivileges = new ArrayList<String>(2);
        srcPrivileges.add("read");
        ArrayList<String> destPrivileges = new ArrayList<String>(3);
        destPrivileges.add("read");
        destPrivileges.add("index");
        if (concreteDest.length == 0) {
            destPrivileges.add("create_index");
            srcPrivileges.add("view_index_metadata");
        }
        RoleDescriptor.IndicesPrivileges destIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{destIndex}).privileges(destPrivileges).build();
        RoleDescriptor.IndicesPrivileges sourceIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(config.getSource().getIndex()).privileges(srcPrivileges).build();
        HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
        privRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
        privRequest.username(username);
        privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
        privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{sourceIndexPrivileges, destIndexPrivileges});
        return privRequest;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(PutDataFrameTransformAction.Request request, ClusterState clusterState, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (!this.licenseState.isDataFrameAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"data_frame"));
            return;
        }
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
        Map<String, String> filteredHeaders = this.threadPool.getThreadContext().getHeaders().entrySet().stream().filter(e -> ClientHelper.SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        DataFrameTransformConfig config = request.getConfig().setHeaders(filteredHeaders).setCreateTime(Instant.now()).setVersion(Version.CURRENT);
        String transformId = config.getId();
        if (PersistentTasksCustomMetaData.getTaskWithId((ClusterState)clusterState, (String)transformId) != null) {
            listener.onFailure((Exception)new ResourceAlreadyExistsException(DataFrameMessages.getMessage((String)"Transform with id [{0}] already exists", (Object[])new Object[]{transformId}), new Object[0]));
            return;
        }
        try {
            SourceDestValidator.validate(config, clusterState, this.indexNameExpressionResolver, request.isDeferValidation());
        }
        catch (ElasticsearchStatusException ex) {
            listener.onFailure((Exception)((Object)ex));
            return;
        }
        if (this.licenseState.isAuthAllowed() && !request.isDeferValidation()) {
            String username = this.securityContext.getUser().principal();
            HasPrivilegesRequest privRequest = TransportPutDataFrameTransformAction.buildPrivilegeCheck(config, this.indexNameExpressionResolver, clusterState, username);
            ActionListener privResponseListener = ActionListener.wrap(r -> this.handlePrivsResponse(username, request, (HasPrivilegesResponse)r, listener), arg_0 -> listener.onFailure(arg_0));
            this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
        } else {
            this.putDataFrame(request, listener);
        }
    }

    protected ClusterBlockException checkBlock(PutDataFrameTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void handlePrivsResponse(String username, PutDataFrameTransformAction.Request request, HasPrivilegesResponse privilegesResponse, ActionListener<AcknowledgedResponse> listener) {
        if (privilegesResponse.isCompleteMatch()) {
            this.putDataFrame(request, listener);
        } else {
            List indices = privilegesResponse.getIndexPrivileges().stream().map(ResourcePrivileges::getResource).collect(Collectors.toList());
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot create data frame transform [{}] because user {} lacks all the required permissions for indices: {}", (Object[])new Object[]{request.getConfig().getId(), username, indices}));
        }
    }

    private void putDataFrame(PutDataFrameTransformAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        DataFrameTransformConfig config = request.getConfig();
        Pivot pivot = new Pivot(config.getPivotConfig());
        ActionListener putTransformConfigurationListener = ActionListener.wrap(putTransformConfigurationResult -> {
            this.auditor.info(config.getId(), "Created data frame transform.");
            listener.onResponse((Object)new AcknowledgedResponse(true));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener pivotValidationListener = ActionListener.wrap(validationResult -> this.dataFrameTransformsConfigManager.putTransformConfiguration(config, (ActionListener<Boolean>)putTransformConfigurationListener), validationException -> {
            if (validationException instanceof ElasticsearchStatusException) {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate data frame configuration", ((ElasticsearchStatusException)((Object)((Object)validationException))).status(), (Throwable)validationException, new Object[0])));
            } else {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate data frame configuration", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)validationException, new Object[0])));
            }
        });
        try {
            pivot.validateConfig();
        }
        catch (ElasticsearchStatusException e) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate data frame configuration", e.status(), (Throwable)e, new Object[0])));
            return;
        }
        catch (Exception e) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Failed to validate data frame configuration", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[0])));
            return;
        }
        if (request.isDeferValidation()) {
            pivotValidationListener.onResponse((Object)true);
        } else {
            pivot.validateQuery(this.client, config.getSource(), (ActionListener<Boolean>)pivotValidationListener);
        }
    }
}

