/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.action;

import java.io.IOException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.dataframe.action.DeleteDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.action.StopDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.notifications.DataFrameAuditor;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;

public class TransportDeleteDataFrameTransformAction
extends TransportMasterNodeAction<DeleteDataFrameTransformAction.Request, AcknowledgedResponse> {
    private final DataFrameTransformsConfigManager transformsConfigManager;
    private final DataFrameAuditor auditor;
    private final Client client;

    @Inject
    public TransportDeleteDataFrameTransformAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, DataFrameTransformsConfigManager transformsConfigManager, DataFrameAuditor auditor, Client client) {
        super("cluster:admin/data_frame/delete", transportService, clusterService, threadPool, actionFilters, DeleteDataFrameTransformAction.Request::new, indexNameExpressionResolver);
        this.transformsConfigManager = transformsConfigManager;
        this.auditor = auditor;
        this.client = client;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(DeleteDataFrameTransformAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        PersistentTasksCustomMetaData pTasksMeta = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        if (pTasksMeta != null && pTasksMeta.getTask(request.getId()) != null && !request.isForce()) {
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Cannot delete data frame [" + request.getId() + "] as the task is running. Stop the task first", RestStatus.CONFLICT, new Object[0])));
        } else {
            ActionListener stopTransformActionListener = ActionListener.wrap(stopResponse -> this.transformsConfigManager.deleteTransform(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
                this.auditor.info(request.getId(), "Deleted data frame transform.");
                listener.onResponse((Object)new AcknowledgedResponse(r.booleanValue()));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
            if (pTasksMeta != null && pTasksMeta.getTask(request.getId()) != null) {
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"data_frame", (ActionType)StopDataFrameTransformAction.INSTANCE, (ActionRequest)new StopDataFrameTransformAction.Request(request.getId(), true, true, null, true), (ActionListener)ActionListener.wrap(r -> stopTransformActionListener.onResponse(null), arg_0 -> ((ActionListener)stopTransformActionListener).onFailure(arg_0)));
            } else {
                stopTransformActionListener.onResponse(null);
            }
        }
    }

    protected ClusterBlockException checkBlock(DeleteDataFrameTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

