/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.action;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;

public final class DataFrameNodes {
    private DataFrameNodes() {
    }

    public static String[] dataFrameTaskNodes(List<String> dataFrameIds, ClusterState clusterState) {
        HashSet<String> executorNodes = new HashSet<String>();
        PersistentTasksCustomMetaData tasksMetaData = PersistentTasksCustomMetaData.getPersistentTasksCustomMetaData((ClusterState)clusterState);
        if (tasksMetaData != null) {
            HashSet<String> dataFrameIdsSet = new HashSet<String>(dataFrameIds);
            Collection tasks = tasksMetaData.findTasks("data_frame/transforms", t -> dataFrameIdsSet.contains(t.getId()));
            for (PersistentTasksCustomMetaData.PersistentTask task : tasks) {
                executorNodes.add(task.getExecutorNode());
            }
        }
        return executorNodes.toArray(new String[0]);
    }
}

