/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.dataframe.DataFrameNamedXContentProvider;
import org.elasticsearch.xpack.core.dataframe.action.DeleteDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.action.GetDataFrameTransformsAction;
import org.elasticsearch.xpack.core.dataframe.action.GetDataFrameTransformsStatsAction;
import org.elasticsearch.xpack.core.dataframe.action.PreviewDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.action.PutDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.action.StartDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.action.StartDataFrameTransformTaskAction;
import org.elasticsearch.xpack.core.dataframe.action.StopDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.action.UpdateDataFrameTransformAction;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.dataframe.DataFrameFeatureSet;
import org.elasticsearch.xpack.dataframe.action.TransportDeleteDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.action.TransportGetDataFrameTransformsAction;
import org.elasticsearch.xpack.dataframe.action.TransportGetDataFrameTransformsStatsAction;
import org.elasticsearch.xpack.dataframe.action.TransportPreviewDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.action.TransportPutDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.action.TransportStartDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.action.TransportStartDataFrameTransformTaskAction;
import org.elasticsearch.xpack.dataframe.action.TransportStopDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.action.TransportUpdateDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.checkpoint.DataFrameTransformsCheckpointService;
import org.elasticsearch.xpack.dataframe.notifications.DataFrameAuditor;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameInternalIndex;
import org.elasticsearch.xpack.dataframe.persistence.DataFrameTransformsConfigManager;
import org.elasticsearch.xpack.dataframe.rest.action.RestDeleteDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.rest.action.RestGetDataFrameTransformsAction;
import org.elasticsearch.xpack.dataframe.rest.action.RestGetDataFrameTransformsStatsAction;
import org.elasticsearch.xpack.dataframe.rest.action.RestPreviewDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.rest.action.RestPutDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.rest.action.RestStartDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.rest.action.RestStopDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.rest.action.RestUpdateDataFrameTransformAction;
import org.elasticsearch.xpack.dataframe.transforms.DataFrameTransformPersistentTasksExecutor;
import org.elasticsearch.xpack.dataframe.transforms.DataFrameTransformTask;

public class DataFrame
extends Plugin
implements ActionPlugin,
PersistentTaskPlugin {
    public static final String NAME = "data_frame";
    public static final String TASK_THREAD_POOL_NAME = "data_frame_indexing";
    private static final Logger logger = LogManager.getLogger(DataFrame.class);
    private final boolean enabled;
    private final Settings settings;
    private final boolean transportClientMode;
    private final SetOnce<DataFrameTransformsConfigManager> dataFrameTransformsConfigManager = new SetOnce();
    private final SetOnce<DataFrameAuditor> dataFrameAuditor = new SetOnce();
    private final SetOnce<DataFrameTransformsCheckpointService> dataFrameTransformsCheckpointService = new SetOnce();
    private final SetOnce<SchedulerEngine> schedulerEngine = new SetOnce();

    public DataFrame(Settings settings) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.DATA_FRAME_ENABLED.get(settings);
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, DataFrameFeatureSet.class));
        return modules;
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestPutDataFrameTransformAction(restController), new RestStartDataFrameTransformAction(restController), new RestStopDataFrameTransformAction(restController), new RestDeleteDataFrameTransformAction(restController), new RestGetDataFrameTransformsAction(restController), new RestGetDataFrameTransformsStatsAction(restController), new RestPreviewDataFrameTransformAction(restController), new RestUpdateDataFrameTransformAction(restController)});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)PutDataFrameTransformAction.INSTANCE, TransportPutDataFrameTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StartDataFrameTransformAction.INSTANCE, TransportStartDataFrameTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StartDataFrameTransformTaskAction.INSTANCE, TransportStartDataFrameTransformTaskAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopDataFrameTransformAction.INSTANCE, TransportStopDataFrameTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteDataFrameTransformAction.INSTANCE, TransportDeleteDataFrameTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDataFrameTransformsAction.INSTANCE, TransportGetDataFrameTransformsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDataFrameTransformsStatsAction.INSTANCE, TransportGetDataFrameTransformsStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PreviewDataFrameTransformAction.INSTANCE, TransportPreviewDataFrameTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateDataFrameTransformAction.INSTANCE, TransportUpdateDataFrameTransformAction.class, new Class[0]));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (!this.enabled || this.transportClientMode) {
            return Collections.emptyList();
        }
        FixedExecutorBuilder indexing = new FixedExecutorBuilder(settings, TASK_THREAD_POOL_NAME, 4, 4, "data_frame.task_thread_pool");
        return Collections.singletonList(indexing);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        if (!this.enabled || this.transportClientMode) {
            return Collections.emptyList();
        }
        this.dataFrameAuditor.set((Object)new DataFrameAuditor(client, clusterService.getNodeName()));
        this.dataFrameTransformsConfigManager.set((Object)new DataFrameTransformsConfigManager(client, xContentRegistry));
        this.dataFrameTransformsCheckpointService.set((Object)new DataFrameTransformsCheckpointService(client, (DataFrameTransformsConfigManager)this.dataFrameTransformsConfigManager.get(), (DataFrameAuditor)((Object)this.dataFrameAuditor.get())));
        return Arrays.asList(this.dataFrameTransformsConfigManager.get(), this.dataFrameAuditor.get(), this.dataFrameTransformsCheckpointService.get());
    }

    public UnaryOperator<Map<String, IndexTemplateMetaData>> getIndexTemplateMetaDataUpgrader() {
        return templates -> {
            try {
                templates.put(".data-frame-internal-2", DataFrameInternalIndex.getIndexTemplateMetaData());
            }
            catch (IOException e) {
                logger.error("Error creating data frame index template", (Throwable)e);
            }
            try {
                templates.put(".data-frame-notifications-1", DataFrameInternalIndex.getAuditIndexTemplateMetaData());
            }
            catch (IOException e) {
                logger.warn("Error creating data frame audit index", (Throwable)e);
            }
            return templates;
        };
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule) {
        if (!this.enabled || this.transportClientMode) {
            return Collections.emptyList();
        }
        this.schedulerEngine.set((Object)new SchedulerEngine(this.settings, Clock.systemUTC()));
        assert (this.dataFrameTransformsConfigManager.get() != null);
        assert (this.dataFrameAuditor.get() != null);
        assert (this.dataFrameTransformsCheckpointService.get() != null);
        return Collections.singletonList(new DataFrameTransformPersistentTasksExecutor(client, (DataFrameTransformsConfigManager)this.dataFrameTransformsConfigManager.get(), (DataFrameTransformsCheckpointService)this.dataFrameTransformsCheckpointService.get(), (SchedulerEngine)this.schedulerEngine.get(), (DataFrameAuditor)((Object)this.dataFrameAuditor.get()), threadPool, clusterService, settingsModule.getSettings()));
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(DataFrameTransformTask.NUM_FAILURE_RETRIES_SETTING);
    }

    public void close() {
        if (this.schedulerEngine.get() != null) {
            ((SchedulerEngine)this.schedulerEngine.get()).stop();
        }
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return new DataFrameNamedXContentProvider().getNamedXContentParsers();
    }
}

