/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.query;

import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeIndexer;

public class ShapeQueryProcessor
implements AbstractGeometryFieldMapper.QueryProcessor {
    public Query process(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        if (relation == ShapeRelation.CONTAINS) {
            throw new QueryShardException(context, ShapeRelation.CONTAINS + " query relation not supported for Field [" + fieldName + "]", new Object[0]);
        }
        if (shape == null) {
            return new MatchNoDocsQuery();
        }
        return new ConstantScoreQuery((Query)shape.visit((GeometryVisitor)new ShapeVisitor(context, fieldName, relation)));
    }

    private static float[] doubleArrayToFloatArray(double[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (float)array[i];
        }
        return result;
    }

    private class ShapeVisitor
    implements GeometryVisitor<Query, RuntimeException> {
        QueryShardContext context;
        MappedFieldType fieldType;
        String fieldName;
        ShapeRelation relation;

        ShapeVisitor(QueryShardContext context, String fieldName, ShapeRelation relation) {
            this.context = context;
            this.fieldType = context.fieldMapper(fieldName);
            this.fieldName = fieldName;
            this.relation = relation;
        }

        public Query visit(Circle circle) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] found and unknown shape Circle", new Object[0]);
        }

        public Query visit(GeometryCollection<?> collection) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            this.visit(bqb, collection);
            return bqb.build();
        }

        private void visit(BooleanQuery.Builder bqb, GeometryCollection<?> collection) {
            for (Geometry shape : collection) {
                if (shape instanceof MultiPoint) {
                    this.visit(bqb, (GeometryCollection)shape);
                    continue;
                }
                bqb.add((Query)shape.visit((GeometryVisitor)this), BooleanClause.Occur.SHOULD);
            }
        }

        public Query visit(Line line) {
            return XYShape.newLineQuery((String)this.fieldName, (ShapeField.QueryRelation)this.relation.getLuceneRelation(), (XYLine[])new XYLine[]{new XYLine(ShapeQueryProcessor.doubleArrayToFloatArray(line.getX()), ShapeQueryProcessor.doubleArrayToFloatArray(line.getY()))});
        }

        public Query visit(LinearRing ring) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] found and unsupported shape LinearRing", new Object[0]);
        }

        public Query visit(MultiLine multiLine) {
            XYLine[] lines = new XYLine[multiLine.size()];
            for (int i = 0; i < multiLine.size(); ++i) {
                lines[i] = new XYLine(ShapeQueryProcessor.doubleArrayToFloatArray(((Line)multiLine.get(i)).getX()), ShapeQueryProcessor.doubleArrayToFloatArray(((Line)multiLine.get(i)).getY()));
            }
            return XYShape.newLineQuery((String)this.fieldName, (ShapeField.QueryRelation)this.relation.getLuceneRelation(), (XYLine[])lines);
        }

        public Query visit(MultiPoint multiPoint) {
            throw new QueryShardException(this.context, "Field [" + this.fieldName + "] does not support " + GeoShapeType.MULTIPOINT + " queries", new Object[0]);
        }

        public Query visit(MultiPolygon multiPolygon) {
            XYPolygon[] polygons = new XYPolygon[multiPolygon.size()];
            for (int i = 0; i < multiPolygon.size(); ++i) {
                polygons[i] = ShapeIndexer.toLucenePolygon((Polygon)multiPolygon.get(i));
            }
            return this.visitMultiPolygon(polygons);
        }

        private Query visitMultiPolygon(XYPolygon ... polygons) {
            return XYShape.newPolygonQuery((String)this.fieldName, (ShapeField.QueryRelation)this.relation.getLuceneRelation(), (XYPolygon[])polygons);
        }

        public Query visit(Point point) {
            return XYShape.newBoxQuery((String)this.fieldName, (ShapeField.QueryRelation)this.relation.getLuceneRelation(), (float)((float)point.getX()), (float)((float)point.getX()), (float)((float)point.getY()), (float)((float)point.getY()));
        }

        public Query visit(Polygon polygon) {
            return XYShape.newPolygonQuery((String)this.fieldName, (ShapeField.QueryRelation)this.relation.getLuceneRelation(), (XYPolygon[])new XYPolygon[]{ShapeIndexer.toLucenePolygon(polygon)});
        }

        public Query visit(Rectangle r) {
            return XYShape.newBoxQuery((String)this.fieldName, (ShapeField.QueryRelation)this.relation.getLuceneRelation(), (float)((float)r.getMinX()), (float)((float)r.getMaxX()), (float)((float)r.getMinY()), (float)((float)r.getMaxY()));
        }
    }
}

