/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.rollup.action.GetRollupJobsAction;
import org.elasticsearch.xpack.core.rollup.job.RollupJobStatus;
import org.elasticsearch.xpack.rollup.job.RollupJobTask;

public class TransportGetRollupJobAction
extends TransportTasksAction<RollupJobTask, GetRollupJobsAction.Request, GetRollupJobsAction.Response, GetRollupJobsAction.Response> {
    @Inject
    public TransportGetRollupJobAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService) {
        super("cluster:monitor/xpack/rollup/get", clusterService, transportService, actionFilters, GetRollupJobsAction.Request::new, GetRollupJobsAction.Response::new, GetRollupJobsAction.Response::new, "same");
    }

    protected void doExecute(Task task, GetRollupJobsAction.Request request, ActionListener<GetRollupJobsAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (nodes.isLocalNodeElectedMaster()) {
            if (TransportGetRollupJobAction.stateHasRollupJobs(request, state)) {
                super.doExecute(task, (BaseTasksRequest)request, listener);
            } else {
                listener.onResponse((Object)new GetRollupJobsAction.Response(Collections.emptyList()));
            }
        } else if (nodes.getMasterNode() == null) {
            listener.onFailure((Exception)new MasterNotDiscoveredException("no known master nodes"));
        } else {
            this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, GetRollupJobsAction.Response::new));
        }
    }

    static boolean stateHasRollupJobs(GetRollupJobsAction.Request request, ClusterState state) {
        boolean hasRollupJobs = false;
        PersistentTasksCustomMetaData pTasksMeta = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        if (pTasksMeta != null) {
            if (request.getId().equals("_all")) {
                hasRollupJobs = pTasksMeta.tasks().stream().anyMatch(persistentTask -> persistentTask.getTaskName().equals("xpack/rollup/job"));
            } else if (pTasksMeta.getTask(request.getId()) != null) {
                hasRollupJobs = true;
            }
        }
        return hasRollupJobs;
    }

    protected void taskOperation(GetRollupJobsAction.Request request, RollupJobTask jobTask, ActionListener<GetRollupJobsAction.Response> listener) {
        List<Object> jobs = Collections.emptyList();
        assert (jobTask.getConfig().getId().equals(request.getId()) || request.getId().equals("_all"));
        if (!jobTask.isCancelled()) {
            GetRollupJobsAction.JobWrapper wrapper = new GetRollupJobsAction.JobWrapper(jobTask.getConfig(), jobTask.getStats(), (RollupJobStatus)jobTask.getStatus());
            jobs = Collections.singletonList(wrapper);
        }
        listener.onResponse((Object)new GetRollupJobsAction.Response(jobs));
    }

    protected GetRollupJobsAction.Response newResponse(GetRollupJobsAction.Request request, List<GetRollupJobsAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        List jobs = tasks.stream().map(GetRollupJobsAction.Response::getJobs).flatMap(Collection::stream).collect(Collectors.toList());
        return new GetRollupJobsAction.Response(jobs, taskOperationFailures, failedNodeExceptions);
    }
}

