/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.elasticsearch.xpack.core.rollup.action.RollupJobCaps;
import org.elasticsearch.xpack.core.rollup.job.DateHistogramGroupConfig;

public class RollupJobIdentifierUtils {
    static final Comparator<RollupJobCaps> COMPARATOR = RollupJobIdentifierUtils.getComparator();

    public static Set<RollupJobCaps> findBestJobs(AggregationBuilder source, Set<RollupJobCaps> jobCaps) {
        HashSet<RollupJobCaps> bestCaps = new HashSet<RollupJobCaps>();
        RollupJobIdentifierUtils.doFindBestJobs(source, new ArrayList<RollupJobCaps>(jobCaps), bestCaps);
        return bestCaps;
    }

    private static void doFindBestJobs(AggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        if (source.getWriteableName().equals("date_histogram")) {
            RollupJobIdentifierUtils.checkDateHisto((DateHistogramAggregationBuilder)source, jobCaps, bestCaps);
        } else if (source.getWriteableName().equals("histogram")) {
            RollupJobIdentifierUtils.checkHisto((HistogramAggregationBuilder)source, jobCaps, bestCaps);
        } else if (RollupField.SUPPORTED_METRICS.contains(source.getWriteableName())) {
            RollupJobIdentifierUtils.checkVSLeaf((ValuesSourceAggregationBuilder.LeafOnly)source, jobCaps, bestCaps);
        } else if (source.getWriteableName().equals("terms")) {
            RollupJobIdentifierUtils.checkTerms((TermsAggregationBuilder)source, jobCaps, bestCaps);
        } else {
            throw new IllegalArgumentException("Unable to translate aggregation tree into Rollup.  Aggregation [" + source.getName() + "] is of type [" + source.getClass().getSimpleName() + "] which is currently unsupported.");
        }
    }

    private static void checkDateHisto(DateHistogramAggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                DateHistogramInterval requestInterval;
                DateHistogramInterval configLegacyInterval;
                ZoneId sourceTimeZone;
                if (!agg.get("agg").equals("date_histogram")) continue;
                DateHistogramInterval interval = new DateHistogramInterval((String)agg.get("interval"));
                ZoneId thisTimezone = ZoneId.of((String)agg.get("time_zone"), ZoneId.SHORT_IDS);
                ZoneId zoneId = sourceTimeZone = source.timeZone() == null ? DateHistogramGroupConfig.DEFAULT_ZONEID_TIMEZONE : ZoneId.of(source.timeZone().toString(), ZoneId.SHORT_IDS);
                if (!thisTimezone.getRules().equals(sourceTimeZone.getRules())) continue;
                DateHistogramInterval configCalendarInterval = agg.get("calendar_interval") != null ? new DateHistogramInterval((String)agg.get("calendar_interval")) : null;
                DateHistogramInterval configFixedInterval = agg.get("fixed_interval") != null ? new DateHistogramInterval((String)agg.get("fixed_interval")) : null;
                DateHistogramInterval dateHistogramInterval = configLegacyInterval = agg.get("interval") != null ? new DateHistogramInterval((String)agg.get("interval")) : null;
                if (source.getCalendarInterval() != null) {
                    requestInterval = source.getCalendarInterval();
                    if (RollupJobIdentifierUtils.validateCalendarInterval(requestInterval, configCalendarInterval)) {
                        localCaps.add(cap);
                        continue block0;
                    }
                    if (!RollupJobIdentifierUtils.validateCalendarInterval(requestInterval, configLegacyInterval)) continue block0;
                    localCaps.add(cap);
                    continue block0;
                }
                if (source.getFixedInterval() != null) {
                    requestInterval = source.getFixedInterval();
                    if (RollupJobIdentifierUtils.validateFixedInterval(requestInterval, configFixedInterval)) {
                        localCaps.add(cap);
                        continue block0;
                    }
                    if (!RollupJobIdentifierUtils.validateFixedInterval(requestInterval, configLegacyInterval)) continue block0;
                    localCaps.add(cap);
                    continue block0;
                }
                if (source.dateHistogramInterval() != null) {
                    requestInterval = source.dateHistogramInterval();
                    if (RollupJobIdentifierUtils.validateCalendarInterval(requestInterval, configCalendarInterval)) {
                        localCaps.add(cap);
                        continue block0;
                    }
                    if (RollupJobIdentifierUtils.isCalendarInterval(configLegacyInterval) && RollupJobIdentifierUtils.validateCalendarInterval(requestInterval, configLegacyInterval)) {
                        localCaps.add(cap);
                        continue block0;
                    }
                    if (!RollupJobIdentifierUtils.validateFixedInterval(requestInterval, configFixedInterval)) continue block0;
                    localCaps.add(cap);
                    continue block0;
                }
                if (source.interval() != 0L) {
                    if (RollupJobIdentifierUtils.isCalendarInterval(configLegacyInterval) || !RollupJobIdentifierUtils.validateFixedInterval(new DateHistogramInterval(source.interval() + "ms"), configLegacyInterval)) continue block0;
                    localCaps.add(cap);
                    continue block0;
                }
                throw new IllegalArgumentException("An interval of some variety must be configured on the date_histogram aggregation.");
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg on field [" + source.field() + "] which also satisfies all requirements of query.");
        }
        if (source.getSubAggregations().size() == 0) {
            bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
        } else {
            source.getSubAggregations().forEach(sub -> RollupJobIdentifierUtils.doFindBestJobs(sub, localCaps, bestCaps));
        }
    }

    static String retrieveInterval(Map<String, Object> agg) {
        String interval = (String)agg.get("interval");
        if (interval == null) {
            interval = (String)agg.get("calendar_interval");
        }
        if (interval == null) {
            interval = (String)agg.get("fixed_interval");
        }
        if (interval == null) {
            throw new IllegalStateException("Could not find interval in agg cap: " + agg.toString());
        }
        return interval;
    }

    private static boolean isCalendarInterval(DateHistogramInterval interval) {
        return interval != null && DateHistogramAggregationBuilder.DATE_FIELD_UNITS.containsKey(interval.toString());
    }

    static boolean validateCalendarInterval(DateHistogramInterval requestInterval, DateHistogramInterval configInterval) {
        long configOrder;
        if (requestInterval == null || configInterval == null) {
            return false;
        }
        Rounding.DateTimeUnit requestUnit = (Rounding.DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(requestInterval.toString());
        if (requestUnit == null) {
            return false;
        }
        Rounding.DateTimeUnit configUnit = (Rounding.DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(configInterval.toString());
        if (configUnit == null) {
            return false;
        }
        long requestOrder = requestUnit.getField().getBaseUnit().getDuration().toMillis();
        return requestOrder >= (configOrder = configUnit.getField().getBaseUnit().getDuration().toMillis());
    }

    static boolean validateFixedInterval(DateHistogramInterval requestInterval, DateHistogramInterval configInterval) {
        if (requestInterval == null || configInterval == null) {
            return false;
        }
        long configIntervalMillis = TimeValue.parseTimeValue((String)configInterval.toString(), (String)"date_histo.config.interval").getMillis();
        long requestIntervalMillis = TimeValue.parseTimeValue((String)requestInterval.toString(), (String)"date_histo.request.interval").getMillis();
        return requestIntervalMillis >= configIntervalMillis && requestIntervalMillis % configIntervalMillis == 0L;
    }

    private static void checkHisto(HistogramAggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                if (!agg.get("agg").equals("histogram")) continue;
                long interval = (Long)agg.get("interval");
                if (!((double)interval <= source.interval()) || source.interval() % (double)interval != 0.0) continue block0;
                localCaps.add(cap);
                continue block0;
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg on field [" + source.field() + "] which also satisfies all requirements of query.");
        }
        if (source.getSubAggregations().size() == 0) {
            bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
        } else {
            source.getSubAggregations().forEach(sub -> RollupJobIdentifierUtils.doFindBestJobs(sub, localCaps, bestCaps));
        }
    }

    private static void checkTerms(TermsAggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                if (!agg.get("agg").equals("terms")) continue;
                localCaps.add(cap);
                continue block0;
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg on field [" + source.field() + "] which also satisfies all requirements of query.");
        }
        if (source.getSubAggregations().size() == 0) {
            bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
        } else {
            source.getSubAggregations().forEach(sub -> RollupJobIdentifierUtils.doFindBestJobs(sub, localCaps, bestCaps));
        }
    }

    private static void checkVSLeaf(ValuesSourceAggregationBuilder.LeafOnly source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                if (!agg.get("agg").equals(source.getWriteableName())) continue;
                localCaps.add(cap);
                continue block0;
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg with name [" + source.getName() + "] which also satisfies all requirements of query.");
        }
        bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
    }

    private static RollupJobCaps getTopEqualCaps(List<RollupJobCaps> caps) {
        assert (!caps.isEmpty());
        caps.sort(COMPARATOR);
        return caps.get(0);
    }

    private static Comparator<RollupJobCaps> getComparator() {
        return (o1, o2) -> {
            if (o1 == null) {
                throw new NullPointerException("RollupJobCap [o1] cannot be null");
            }
            if (o2 == null) {
                throw new NullPointerException("RollupJobCap [o2] cannot be null");
            }
            if (o1.equals(o2)) {
                return 0;
            }
            long thisTime = Long.MAX_VALUE;
            long thatTime = Long.MAX_VALUE;
            float thisHistoWeights = 0.0f;
            float thatHistoWeights = 0.0f;
            long counter = 0L;
            long thisTermsWeights = 0L;
            long thatTermsWeights = 0L;
            for (RollupJobCaps.RollupFieldCaps fieldCaps : o1.getFieldCaps().values()) {
                for (Map agg : fieldCaps.getAggs()) {
                    if (agg.get("agg").equals("date_histogram")) {
                        thisTime = new DateHistogramInterval(RollupJobIdentifierUtils.retrieveInterval(agg)).estimateMillis();
                        continue;
                    }
                    if (agg.get("agg").equals("histogram")) {
                        thisHistoWeights += (float)((Long)agg.get("interval")).longValue();
                        ++counter;
                        continue;
                    }
                    if (!agg.get("agg").equals("terms")) continue;
                    ++thisTermsWeights;
                }
            }
            thisHistoWeights = counter == 0L ? 0.0f : thisHistoWeights / (float)counter;
            counter = 0L;
            for (RollupJobCaps.RollupFieldCaps fieldCaps : o2.getFieldCaps().values()) {
                for (Map agg : fieldCaps.getAggs()) {
                    if (agg.get("agg").equals("date_histogram")) {
                        thatTime = new DateHistogramInterval(RollupJobIdentifierUtils.retrieveInterval(agg)).estimateMillis();
                        continue;
                    }
                    if (agg.get("agg").equals("histogram")) {
                        thatHistoWeights += (float)((Long)agg.get("interval")).longValue();
                        ++counter;
                        continue;
                    }
                    if (!agg.get("agg").equals("terms")) continue;
                    ++thatTermsWeights;
                }
            }
            thatHistoWeights = counter == 0L ? 0.0f : thatHistoWeights / (float)counter;
            int timeCompare = Long.compare(thisTime, thatTime);
            if (timeCompare != 0) {
                return -timeCompare;
            }
            int histoCompare = Float.compare(thisHistoWeights, thatHistoWeights);
            if (histoCompare != 0) {
                if (thisHistoWeights == 0.0f) {
                    return -1;
                }
                if (thatHistoWeights == 0.0f) {
                    return 1;
                }
                return -histoCompare;
            }
            return Long.compare(thisTermsWeights, thatTermsWeights);
        };
    }
}

