/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyItem;
import org.elasticsearch.xpack.core.slm.action.GetSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.action.TransportPutSnapshotLifecycleAction;

public class TransportGetSnapshotLifecycleAction
extends TransportMasterNodeAction<GetSnapshotLifecycleAction.Request, GetSnapshotLifecycleAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportPutSnapshotLifecycleAction.class);

    @Inject
    public TransportGetSnapshotLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/slm/get", transportService, clusterService, threadPool, actionFilters, GetSnapshotLifecycleAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected GetSnapshotLifecycleAction.Response read(StreamInput in) throws IOException {
        return new GetSnapshotLifecycleAction.Response(in);
    }

    protected void masterOperation(GetSnapshotLifecycleAction.Request request, ClusterState state, ActionListener<GetSnapshotLifecycleAction.Response> listener) {
        SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)state.metaData().custom("snapshot_lifecycle");
        if (snapMeta == null) {
            listener.onResponse((Object)new GetSnapshotLifecycleAction.Response(Collections.emptyList()));
        } else {
            Map<String, SnapshotLifecyclePolicyItem.SnapshotInProgress> inProgress;
            SnapshotsInProgress sip = (SnapshotsInProgress)state.custom("snapshots");
            if (sip == null) {
                inProgress = Collections.emptyMap();
            } else {
                inProgress = new HashMap();
                for (SnapshotsInProgress.Entry entry : sip.entries()) {
                    Map meta2 = entry.userMetadata();
                    if (meta2 == null || meta2.get("policy") == null || !(meta2.get("policy") instanceof String)) continue;
                    String policyId = (String)meta2.get("policy");
                    inProgress.put(policyId, SnapshotLifecyclePolicyItem.SnapshotInProgress.fromEntry((SnapshotsInProgress.Entry)entry));
                }
            }
            HashSet<String> ids = new HashSet<String>(Arrays.asList(request.getLifecycleIds()));
            List lifecycles = snapMeta.getSnapshotConfigurations().values().stream().filter(meta -> {
                if (ids.isEmpty()) {
                    return true;
                }
                return ids.contains(meta.getPolicy().getId());
            }).map(policyMeta -> new SnapshotLifecyclePolicyItem(policyMeta, (SnapshotLifecyclePolicyItem.SnapshotInProgress)inProgress.get(policyMeta.getPolicy().getId()))).collect(Collectors.toList());
            listener.onResponse((Object)new GetSnapshotLifecycleAction.Response(lifecycles));
        }
    }

    protected ClusterBlockException checkBlock(GetSnapshotLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

