/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.core.slm.SnapshotInvocationRecord;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.history.SnapshotHistoryItem;
import org.elasticsearch.xpack.core.slm.history.SnapshotHistoryStore;
import org.elasticsearch.xpack.ilm.LifecyclePolicySecurityClient;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;

public class SnapshotLifecycleTask
implements SchedulerEngine.Listener {
    private static Logger logger = LogManager.getLogger(SnapshotLifecycleTask.class);
    private final Client client;
    private final ClusterService clusterService;
    private final SnapshotHistoryStore historyStore;

    public SnapshotLifecycleTask(Client client, ClusterService clusterService, SnapshotHistoryStore historyStore) {
        this.client = client;
        this.clusterService = clusterService;
        this.historyStore = historyStore;
    }

    public void triggered(SchedulerEngine.Event event) {
        logger.debug("snapshot lifecycle policy task triggered from job [{}]", (Object)event.getJobName());
        Optional<String> snapshotName = SnapshotLifecycleTask.maybeTakeSnapshot(event.getJobName(), this.client, this.clusterService, this.historyStore);
        snapshotName.ifPresent(name -> logger.info("snapshot lifecycle policy job [{}] issued new snapshot creation for [{}] successfully", (Object)event.getJobName(), name));
        if (!snapshotName.isPresent()) {
            logger.warn("snapshot lifecycle policy for job [{}] no longer exists, snapshot not created", (Object)event.getJobName());
        }
    }

    public static Optional<String> maybeTakeSnapshot(String jobId, Client client, final ClusterService clusterService, final SnapshotHistoryStore historyStore) {
        Optional<SnapshotLifecyclePolicyMetadata> maybeMetadata = SnapshotLifecycleTask.getSnapPolicyMetadata(jobId, clusterService.state());
        String snapshotName = maybeMetadata.map(policyMetadata -> {
            final CreateSnapshotRequest request = policyMetadata.getPolicy().toRequest();
            LifecyclePolicySecurityClient clientWithHeaders = new LifecyclePolicySecurityClient(client, "index_lifecycle", policyMetadata.getHeaders());
            logger.info("snapshot lifecycle policy [{}] issuing create snapshot [{}]", (Object)policyMetadata.getPolicy().getId(), (Object)request.snapshot());
            clientWithHeaders.admin().cluster().createSnapshot(request, (ActionListener)new ActionListener<CreateSnapshotResponse>(){

                public void onResponse(CreateSnapshotResponse createSnapshotResponse) {
                    logger.debug("snapshot response for [{}]: {}", (Object)policyMetadata.getPolicy().getId(), (Object)Strings.toString((ToXContent)createSnapshotResponse));
                    long timestamp = Instant.now().toEpochMilli();
                    clusterService.submitStateUpdateTask("slm-record-success-" + policyMetadata.getPolicy().getId(), (ClusterStateTaskConfig)WriteJobStatus.success(policyMetadata.getPolicy().getId(), request.snapshot(), timestamp));
                    historyStore.putAsync(SnapshotHistoryItem.successRecord((long)timestamp, (SnapshotLifecyclePolicy)policyMetadata.getPolicy(), (String)request.snapshot()));
                }

                public void onFailure(Exception e) {
                    logger.error("failed to issue create snapshot request for snapshot lifecycle policy [{}]: {}", (Object)policyMetadata.getPolicy().getId(), (Object)e);
                    long timestamp = Instant.now().toEpochMilli();
                    clusterService.submitStateUpdateTask("slm-record-failure-" + policyMetadata.getPolicy().getId(), (ClusterStateTaskConfig)WriteJobStatus.failure(policyMetadata.getPolicy().getId(), request.snapshot(), timestamp, e));
                    try {
                        SnapshotHistoryItem failureRecord = SnapshotHistoryItem.failureRecord((long)timestamp, (SnapshotLifecyclePolicy)policyMetadata.getPolicy(), (String)request.snapshot(), (Exception)e);
                        historyStore.putAsync(failureRecord);
                    }
                    catch (IOException ex) {
                        logger.error((Message)new ParameterizedMessage("failed to record snapshot creation failure for snapshot lifecycle policy [{}]", (Object)policyMetadata.getPolicy().getId()), (Throwable)e);
                    }
                }
            });
            return request.snapshot();
        }).orElse(null);
        return Optional.ofNullable(snapshotName);
    }

    static Optional<SnapshotLifecyclePolicyMetadata> getSnapPolicyMetadata(String jobId, ClusterState state) {
        return Optional.ofNullable((SnapshotLifecycleMetadata)state.metaData().custom("snapshot_lifecycle")).map(SnapshotLifecycleMetadata::getSnapshotConfigurations).flatMap(configMap -> configMap.values().stream().filter(policyMeta -> jobId.equals(SnapshotLifecycleService.getJobId(policyMeta))).findFirst());
    }

    private static class WriteJobStatus
    extends ClusterStateUpdateTask {
        private static final ToXContent.Params STACKTRACE_PARAMS = new ToXContent.MapParams(Collections.singletonMap("rest.exception.stacktrace.skip", "false"));
        private final String policyName;
        private final String snapshotName;
        private final long timestamp;
        private final Optional<Exception> exception;

        private WriteJobStatus(String policyName, String snapshotName, long timestamp, Optional<Exception> exception) {
            this.policyName = policyName;
            this.snapshotName = snapshotName;
            this.exception = exception;
            this.timestamp = timestamp;
        }

        static WriteJobStatus success(String policyId, String snapshotName, long timestamp) {
            return new WriteJobStatus(policyId, snapshotName, timestamp, Optional.empty());
        }

        static WriteJobStatus failure(String policyId, String snapshotName, long timestamp, Exception exception) {
            return new WriteJobStatus(policyId, snapshotName, timestamp, Optional.of(exception));
        }

        private String exceptionToString() throws IOException {
            if (this.exception.isPresent()) {
                try (XContentBuilder causeXContentBuilder = JsonXContent.contentBuilder();){
                    causeXContentBuilder.startObject();
                    ElasticsearchException.generateThrowableXContent((XContentBuilder)causeXContentBuilder, (ToXContent.Params)STACKTRACE_PARAMS, (Throwable)this.exception.get());
                    causeXContentBuilder.endObject();
                    String string = BytesReference.bytes((XContentBuilder)causeXContentBuilder).utf8ToString();
                    return string;
                }
            }
            return null;
        }

        public ClusterState execute(ClusterState currentState) throws Exception {
            SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)currentState.metaData().custom("snapshot_lifecycle");
            assert (snapMeta != null) : "this should never be called while the snapshot lifecycle cluster metadata is null";
            if (snapMeta == null) {
                logger.error("failed to record snapshot [{}] for snapshot [{}] in policy [{}]: snapshot lifecycle metadata is null", (Object)(this.exception.isPresent() ? "failure" : "success"), (Object)this.snapshotName, (Object)this.policyName);
                return currentState;
            }
            HashMap<String, SnapshotLifecyclePolicyMetadata> snapLifecycles = new HashMap<String, SnapshotLifecyclePolicyMetadata>(snapMeta.getSnapshotConfigurations());
            SnapshotLifecyclePolicyMetadata policyMetadata = (SnapshotLifecyclePolicyMetadata)snapLifecycles.get(this.policyName);
            if (policyMetadata == null) {
                logger.warn("failed to record snapshot [{}] for snapshot [{}] in policy [{}]: policy not found", (Object)(this.exception.isPresent() ? "failure" : "success"), (Object)this.snapshotName, (Object)this.policyName);
                return currentState;
            }
            SnapshotLifecyclePolicyMetadata.Builder newPolicyMetadata = SnapshotLifecyclePolicyMetadata.builder((SnapshotLifecyclePolicyMetadata)policyMetadata);
            if (this.exception.isPresent()) {
                newPolicyMetadata.setLastFailure(new SnapshotInvocationRecord(this.snapshotName, this.timestamp, this.exceptionToString()));
            } else {
                newPolicyMetadata.setLastSuccess(new SnapshotInvocationRecord(this.snapshotName, this.timestamp, null));
            }
            snapLifecycles.put(this.policyName, newPolicyMetadata.build());
            SnapshotLifecycleMetadata lifecycleMetadata = new SnapshotLifecycleMetadata(snapLifecycles, snapMeta.getOperationMode());
            MetaData currentMeta = currentState.metaData();
            return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentMeta).putCustom("snapshot_lifecycle", (MetaData.Custom)lifecycleMetadata)).build();
        }

        public void onFailure(String source, Exception e) {
            logger.error("failed to record snapshot policy execution status for snapshot [{}] in policy [{}], (source: [{}]): {}", (Object)this.snapshotName, (Object)this.policyName, (Object)source, (Object)e);
        }
    }
}

