/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.util.List;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.action.DeleteLifecycleAction;

public class TransportDeleteLifecycleAction
extends TransportMasterNodeAction<DeleteLifecycleAction.Request, DeleteLifecycleAction.Response> {
    @Inject
    public TransportDeleteLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/ilm/delete", transportService, clusterService, threadPool, actionFilters, DeleteLifecycleAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected DeleteLifecycleAction.Response read(StreamInput in) throws IOException {
        return new DeleteLifecycleAction.Response(in);
    }

    protected void masterOperation(final DeleteLifecycleAction.Request request, ClusterState state, ActionListener<DeleteLifecycleAction.Response> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("delete-lifecycle-" + request.getPolicyName(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<DeleteLifecycleAction.Response>((AckedRequest)request, listener){

            protected DeleteLifecycleAction.Response newResponse(boolean acknowledged) {
                return new DeleteLifecycleAction.Response(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) {
                Spliterator indicesIt = currentState.metaData().indices().values().spliterator();
                String policyToDelete = request.getPolicyName();
                List indicesUsingPolicy = StreamSupport.stream(indicesIt, false).map(idxMeta -> (IndexMetaData)idxMeta.value).filter(idxMeta -> ((String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(idxMeta.getSettings())).equals(policyToDelete)).map(idxMeta -> idxMeta.getIndex().getName()).collect(Collectors.toList());
                if (!indicesUsingPolicy.isEmpty()) {
                    throw new IllegalArgumentException("Cannot delete policy [" + request.getPolicyName() + "]. It is in use by one or more indices: " + indicesUsingPolicy);
                }
                ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
                IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)currentState.metaData().custom("index_lifecycle");
                if (currentMetadata == null || !currentMetadata.getPolicyMetadatas().containsKey(request.getPolicyName())) {
                    throw new ResourceNotFoundException("Lifecycle policy not found: {}", new Object[]{request.getPolicyName()});
                }
                TreeMap newPolicies = new TreeMap(currentMetadata.getPolicyMetadatas());
                newPolicies.remove(request.getPolicyName());
                IndexLifecycleMetadata newMetadata = new IndexLifecycleMetadata(newPolicies, currentMetadata.getOperationMode());
                newState.metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("index_lifecycle", (MetaData.Custom)newMetadata).build());
                return newState.build();
            }
        });
    }

    protected ClusterBlockException checkBlock(DeleteLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

