/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;

public class OperationModeUpdateTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(OperationModeUpdateTask.class);
    private final OperationMode mode;

    public OperationModeUpdateTask(OperationMode mode) {
        this.mode = mode;
    }

    OperationMode getOperationMode() {
        return this.mode;
    }

    public ClusterState execute(ClusterState currentState) {
        ClusterState newState = currentState;
        newState = this.updateILMState(newState);
        newState = this.updateSLMState(newState);
        return newState;
    }

    private ClusterState updateILMState(ClusterState currentState) {
        IndexLifecycleMetadata currentMetadata = (IndexLifecycleMetadata)currentState.metaData().custom("index_lifecycle");
        if (currentMetadata != null && !currentMetadata.getOperationMode().isValidChange(this.mode)) {
            return currentState;
        }
        if (currentMetadata == null) {
            currentMetadata = IndexLifecycleMetadata.EMPTY;
        }
        OperationMode newMode = currentMetadata.getOperationMode().isValidChange(this.mode) ? this.mode : currentMetadata.getOperationMode();
        return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.metaData()).putCustom("index_lifecycle", (MetaData.Custom)new IndexLifecycleMetadata(currentMetadata.getPolicyMetadatas(), newMode))).build();
    }

    private ClusterState updateSLMState(ClusterState currentState) {
        SnapshotLifecycleMetadata currentMetadata = (SnapshotLifecycleMetadata)currentState.metaData().custom("snapshot_lifecycle");
        if (currentMetadata != null && !currentMetadata.getOperationMode().isValidChange(this.mode)) {
            return currentState;
        }
        if (currentMetadata == null) {
            currentMetadata = SnapshotLifecycleMetadata.EMPTY;
        }
        OperationMode newMode = currentMetadata.getOperationMode().isValidChange(this.mode) ? this.mode : currentMetadata.getOperationMode();
        return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.metaData()).putCustom("snapshot_lifecycle", (MetaData.Custom)new SnapshotLifecycleMetadata(currentMetadata.getSnapshotConfigurations(), newMode))).build();
    }

    public void onFailure(String source, Exception e) {
        logger.error("unable to update lifecycle metadata with new mode [" + this.mode + "]", (Throwable)e);
    }
}

