/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.mapper;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.InPlaceMergeSorter;

public final class VectorEncoderDecoder {
    static final byte INT_BYTES = 4;
    static final byte SHORT_BYTES = 2;

    private VectorEncoderDecoder() {
    }

    public static BytesRef encodeSparseVector(int[] dims, float[] values, int dimCount) {
        int dim;
        VectorEncoderDecoder.sortSparseDimsValues(dims, values, dimCount);
        byte[] buf = new byte[dimCount * 6];
        int offset = 0;
        for (dim = 0; dim < dimCount; ++dim) {
            buf[offset] = (byte)(dims[dim] >> 8);
            buf[offset + 1] = (byte)dims[dim];
            offset += 2;
        }
        for (dim = 0; dim < dimCount; ++dim) {
            int intValue = Float.floatToIntBits(values[dim]);
            buf[offset] = (byte)(intValue >> 24);
            buf[offset + 1] = (byte)(intValue >> 16);
            buf[offset + 2] = (byte)(intValue >> 8);
            buf[offset + 3] = (byte)intValue;
            offset += 4;
        }
        return new BytesRef(buf);
    }

    public static int[] decodeSparseVectorDims(BytesRef vectorBR) {
        if (vectorBR == null) {
            throw new IllegalArgumentException("A document doesn't have a value for a vector field!");
        }
        int dimCount = vectorBR.length / 6;
        int[] dims = new int[dimCount];
        int offset = vectorBR.offset;
        for (int dim = 0; dim < dimCount; ++dim) {
            dims[dim] = (vectorBR.bytes[offset] & 0xFF) << 8 | vectorBR.bytes[offset + 1] & 0xFF;
            offset += 2;
        }
        return dims;
    }

    public static float[] decodeSparseVector(BytesRef vectorBR) {
        if (vectorBR == null) {
            throw new IllegalArgumentException("A document doesn't have a value for a vector field!");
        }
        int dimCount = vectorBR.length / 6;
        int offset = vectorBR.offset + 2 * dimCount;
        float[] vector = new float[dimCount];
        for (int dim = 0; dim < dimCount; ++dim) {
            int intValue = (vectorBR.bytes[offset] & 0xFF) << 24 | (vectorBR.bytes[offset + 1] & 0xFF) << 16 | (vectorBR.bytes[offset + 2] & 0xFF) << 8 | vectorBR.bytes[offset + 3] & 0xFF;
            vector[dim] = Float.intBitsToFloat(intValue);
            offset += 4;
        }
        return vector;
    }

    public static void sortSparseDimsValues(final int[] dims, final float[] values, int n) {
        new InPlaceMergeSorter(){

            public int compare(int i, int j) {
                return Integer.compare(dims[i], dims[j]);
            }

            public void swap(int i, int j) {
                int tempDim = dims[i];
                dims[i] = dims[j];
                dims[j] = tempDim;
                float tempValue = values[j];
                values[j] = values[i];
                values[i] = tempValue;
            }
        }.sort(0, n);
    }

    public static void sortSparseDimsFloatValues(final int[] dims, final float[] values, int n) {
        new InPlaceMergeSorter(){

            public int compare(int i, int j) {
                return Integer.compare(dims[i], dims[j]);
            }

            public void swap(int i, int j) {
                int tempDim = dims[i];
                dims[i] = dims[j];
                dims[j] = tempDim;
                float tempValue = values[j];
                values[j] = values[i];
                values[i] = tempValue;
            }
        }.sort(0, n);
    }

    public static float[] decodeDenseVector(BytesRef vectorBR) {
        if (vectorBR == null) {
            throw new IllegalArgumentException("A document doesn't have a value for a vector field!");
        }
        int dimCount = vectorBR.length / 4;
        float[] vector = new float[dimCount];
        int offset = vectorBR.offset;
        for (int dim = 0; dim < dimCount; ++dim) {
            int intValue = (vectorBR.bytes[offset++] & 0xFF) << 24 | (vectorBR.bytes[offset++] & 0xFF) << 16 | (vectorBR.bytes[offset++] & 0xFF) << 8 | vectorBR.bytes[offset++] & 0xFF;
            vector[dim] = Float.intBitsToFloat(intValue);
        }
        return vector;
    }
}

