/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.persistent.CompletionPersistentTaskAction;
import org.elasticsearch.persistent.PersistentTaskResponse;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ccr.action.ShardFollowTask;

public class ShardFollowTaskCleaner
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(ShardFollowTaskCleaner.class);
    private final ThreadPool threadPool;
    private final Client client;

    public ShardFollowTaskCleaner(ClusterService clusterService, ThreadPool threadPool, Client client) {
        this.threadPool = threadPool;
        this.client = client;
        clusterService.addListener((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (!event.localNodeMaster()) {
            return;
        }
        MetaData metaData = event.state().metaData();
        PersistentTasksCustomMetaData persistentTasksMetaData = (PersistentTasksCustomMetaData)metaData.custom("persistent_tasks");
        if (persistentTasksMetaData == null) {
            return;
        }
        for (final PersistentTasksCustomMetaData.PersistentTask persistentTask : persistentTasksMetaData.tasks()) {
            ShardFollowTask shardFollowTask;
            Index followerIndex;
            if (!"xpack/ccr/shard_follow_task".equals(persistentTask.getTaskName()) || metaData.index(followerIndex = (shardFollowTask = (ShardFollowTask)persistentTask.getParams()).getFollowShardId().getIndex()) != null) continue;
            IndexNotFoundException e = new IndexNotFoundException(followerIndex);
            CompletionPersistentTaskAction.Request request = new CompletionPersistentTaskAction.Request(persistentTask.getId(), persistentTask.getAllocationId(), (Exception)e);
            this.threadPool.generic().submit(() -> this.client.execute((ActionType)CompletionPersistentTaskAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<PersistentTaskResponse>(){

                public void onResponse(PersistentTaskResponse persistentTaskResponse) {
                    logger.debug("task [{}] cleaned up", (Object)persistentTask.getId());
                }

                public void onFailure(Exception e) {
                    logger.warn("failed to clean up task [{}]", (Object)persistentTask.getId());
                }
            }));
        }
    }
}

