/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RequestValidators;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrRepositoryManager;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.AutoFollowCoordinator;
import org.elasticsearch.xpack.ccr.action.CcrRequests;
import org.elasticsearch.xpack.ccr.action.ShardChangesAction;
import org.elasticsearch.xpack.ccr.action.ShardFollowTask;
import org.elasticsearch.xpack.ccr.action.ShardFollowTaskCleaner;
import org.elasticsearch.xpack.ccr.action.ShardFollowTasksExecutor;
import org.elasticsearch.xpack.ccr.action.TransportCcrStatsAction;
import org.elasticsearch.xpack.ccr.action.TransportDeleteAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.action.TransportFollowInfoAction;
import org.elasticsearch.xpack.ccr.action.TransportFollowStatsAction;
import org.elasticsearch.xpack.ccr.action.TransportForgetFollowerAction;
import org.elasticsearch.xpack.ccr.action.TransportGetAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.action.TransportPauseFollowAction;
import org.elasticsearch.xpack.ccr.action.TransportPutAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.action.TransportPutFollowAction;
import org.elasticsearch.xpack.ccr.action.TransportResumeFollowAction;
import org.elasticsearch.xpack.ccr.action.TransportUnfollowAction;
import org.elasticsearch.xpack.ccr.action.bulk.BulkShardOperationsAction;
import org.elasticsearch.xpack.ccr.action.bulk.TransportBulkShardOperationsAction;
import org.elasticsearch.xpack.ccr.action.repositories.ClearCcrRestoreSessionAction;
import org.elasticsearch.xpack.ccr.action.repositories.DeleteInternalCcrRepositoryAction;
import org.elasticsearch.xpack.ccr.action.repositories.GetCcrRestoreFileChunkAction;
import org.elasticsearch.xpack.ccr.action.repositories.PutCcrRestoreSessionAction;
import org.elasticsearch.xpack.ccr.action.repositories.PutInternalCcrRepositoryAction;
import org.elasticsearch.xpack.ccr.index.engine.FollowingEngineFactory;
import org.elasticsearch.xpack.ccr.repository.CcrRepository;
import org.elasticsearch.xpack.ccr.repository.CcrRestoreSourceService;
import org.elasticsearch.xpack.ccr.rest.RestCcrStatsAction;
import org.elasticsearch.xpack.ccr.rest.RestDeleteAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.rest.RestFollowInfoAction;
import org.elasticsearch.xpack.ccr.rest.RestFollowStatsAction;
import org.elasticsearch.xpack.ccr.rest.RestForgetFollowerAction;
import org.elasticsearch.xpack.ccr.rest.RestGetAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.rest.RestPauseFollowAction;
import org.elasticsearch.xpack.ccr.rest.RestPutAutoFollowPatternAction;
import org.elasticsearch.xpack.ccr.rest.RestPutFollowAction;
import org.elasticsearch.xpack.ccr.rest.RestResumeFollowAction;
import org.elasticsearch.xpack.ccr.rest.RestUnfollowAction;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.CCRFeatureSet;
import org.elasticsearch.xpack.core.ccr.ShardFollowNodeTaskStatus;
import org.elasticsearch.xpack.core.ccr.action.CcrStatsAction;
import org.elasticsearch.xpack.core.ccr.action.DeleteAutoFollowPatternAction;
import org.elasticsearch.xpack.core.ccr.action.FollowInfoAction;
import org.elasticsearch.xpack.core.ccr.action.FollowStatsAction;
import org.elasticsearch.xpack.core.ccr.action.ForgetFollowerAction;
import org.elasticsearch.xpack.core.ccr.action.GetAutoFollowPatternAction;
import org.elasticsearch.xpack.core.ccr.action.PauseFollowAction;
import org.elasticsearch.xpack.core.ccr.action.PutAutoFollowPatternAction;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;
import org.elasticsearch.xpack.core.ccr.action.UnfollowAction;

public class Ccr
extends Plugin
implements ActionPlugin,
PersistentTaskPlugin,
EnginePlugin,
RepositoryPlugin {
    public static final String CCR_THREAD_POOL_NAME = "ccr";
    public static final String CCR_CUSTOM_METADATA_KEY = "ccr";
    public static final String CCR_CUSTOM_METADATA_LEADER_INDEX_SHARD_HISTORY_UUIDS = "leader_index_shard_history_uuids";
    public static final String CCR_CUSTOM_METADATA_LEADER_INDEX_UUID_KEY = "leader_index_uuid";
    public static final String CCR_CUSTOM_METADATA_LEADER_INDEX_NAME_KEY = "leader_index_name";
    public static final String CCR_CUSTOM_METADATA_REMOTE_CLUSTER_NAME_KEY = "remote_cluster_name";
    public static final String REQUESTED_OPS_MISSING_METADATA_KEY = "es.requested_operations_missing";
    private final boolean enabled;
    private final Settings settings;
    private final CcrLicenseChecker ccrLicenseChecker;
    private final SetOnce<CcrRestoreSourceService> restoreSourceService = new SetOnce();
    private final SetOnce<CcrSettings> ccrSettings = new SetOnce();
    private Client client;
    private final boolean transportClientMode;

    public Ccr(Settings settings) {
        this(settings, new CcrLicenseChecker());
    }

    Ccr(Settings settings, CcrLicenseChecker ccrLicenseChecker) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.CCR_ENABLED_SETTING.get(settings);
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker);
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        this.client = client;
        if (!this.enabled) {
            return Collections.emptyList();
        }
        CcrSettings ccrSettings = new CcrSettings(this.settings, clusterService.getClusterSettings());
        this.ccrSettings.set((Object)ccrSettings);
        CcrRestoreSourceService restoreSourceService = new CcrRestoreSourceService(threadPool, ccrSettings);
        this.restoreSourceService.set((Object)restoreSourceService);
        Object[] objectArray = new Object[5];
        objectArray[0] = this.ccrLicenseChecker;
        objectArray[1] = restoreSourceService;
        objectArray[2] = new CcrRepositoryManager(this.settings, clusterService, client);
        objectArray[3] = new ShardFollowTaskCleaner(clusterService, threadPool, client);
        objectArray[4] = new AutoFollowCoordinator(this.settings, client, clusterService, this.ccrLicenseChecker, () -> ((ThreadPool)threadPool).relativeTimeInMillis(), () -> ((ThreadPool)threadPool).absoluteTimeInMillis(), threadPool.executor("ccr"));
        return Arrays.asList(objectArray);
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule) {
        return Collections.singletonList(new ShardFollowTasksExecutor(client, threadPool, clusterService, settingsModule));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)BulkShardOperationsAction.INSTANCE, TransportBulkShardOperationsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ShardChangesAction.INSTANCE, ShardChangesAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutInternalCcrRepositoryAction.INSTANCE, PutInternalCcrRepositoryAction.TransportPutInternalRepositoryAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteInternalCcrRepositoryAction.INSTANCE, DeleteInternalCcrRepositoryAction.TransportDeleteInternalRepositoryAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutCcrRestoreSessionAction.INSTANCE, PutCcrRestoreSessionAction.TransportPutCcrRestoreSessionAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ClearCcrRestoreSessionAction.INSTANCE, ClearCcrRestoreSessionAction.TransportDeleteCcrRestoreSessionAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetCcrRestoreFileChunkAction.INSTANCE, GetCcrRestoreFileChunkAction.TransportGetCcrRestoreFileChunkAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)FollowStatsAction.INSTANCE, TransportFollowStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CcrStatsAction.INSTANCE, TransportCcrStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)FollowInfoAction.INSTANCE, TransportFollowInfoAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutFollowAction.INSTANCE, TransportPutFollowAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ResumeFollowAction.INSTANCE, TransportResumeFollowAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PauseFollowAction.INSTANCE, TransportPauseFollowAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UnfollowAction.INSTANCE, TransportUnfollowAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteAutoFollowPatternAction.INSTANCE, TransportDeleteAutoFollowPatternAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutAutoFollowPatternAction.INSTANCE, TransportPutAutoFollowPatternAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetAutoFollowPatternAction.INSTANCE, TransportGetAutoFollowPatternAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForgetFollowerAction.INSTANCE, TransportForgetFollowerAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestFollowStatsAction(restController), new RestCcrStatsAction(restController), new RestFollowInfoAction(restController), new RestPutFollowAction(restController), new RestResumeFollowAction(restController), new RestPauseFollowAction(restController), new RestUnfollowAction(restController), new RestDeleteAutoFollowPatternAction(restController), new RestPutAutoFollowPatternAction(restController), new RestGetAutoFollowPatternAction(restController), new RestForgetFollowerAction(restController)});
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ccr/shard_follow_task", ShardFollowTask::readFrom), new NamedWriteableRegistry.Entry(Task.Status.class, "shard-follow-node-task-status", ShardFollowNodeTaskStatus::new));
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Arrays.asList(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("ccr_auto_follow", new String[0]), AutoFollowMetadata::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ccr/shard_follow_task", new String[0]), ShardFollowTask::fromXContent), new NamedXContentRegistry.Entry(ShardFollowNodeTaskStatus.class, new ParseField("shard-follow-node-task-status", new String[0]), ShardFollowNodeTaskStatus::fromXContent));
    }

    public List<Setting<?>> getSettings() {
        return CcrSettings.getSettings();
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        if (((Boolean)CcrSettings.CCR_FOLLOWING_INDEX_SETTING.get(indexSettings.getSettings())).booleanValue()) {
            return Optional.of(new FollowingEngineFactory());
        }
        return Optional.empty();
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new FixedExecutorBuilder(settings, "ccr", 32, 100, "xpack.ccr.ccr_thread_pool"));
    }

    public Map<String, Repository.Factory> getInternalRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ThreadPool threadPool) {
        Repository.Factory repositoryFactory = metadata -> new CcrRepository(metadata, this.client, this.ccrLicenseChecker, this.settings, (CcrSettings)this.ccrSettings.get(), threadPool);
        return Collections.singletonMap("_ccr_", repositoryFactory);
    }

    public void onIndexModule(IndexModule indexModule) {
        if (this.enabled) {
            indexModule.addIndexEventListener((IndexEventListener)this.restoreSourceService.get());
        }
    }

    public Collection<Module> createGuiceModules() {
        if (this.transportClientMode) {
            return Collections.emptyList();
        }
        return Collections.singleton(b -> XPackPlugin.bindFeatureSet((Binder)b, CCRFeatureSet.class));
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public Collection<RequestValidators.RequestValidator<PutMappingRequest>> mappingRequestValidators() {
        return Collections.singletonList(CcrRequests.CCR_PUT_MAPPING_REQUEST_VALIDATOR);
    }

    public Collection<RequestValidators.RequestValidator<IndicesAliasesRequest>> indicesAliasesRequestValidators() {
        return Collections.singletonList(CcrRequests.CCR_INDICES_ALIASES_REQUEST_VALIDATOR);
    }
}

