/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.capabilities.Unresolvable;
import org.elasticsearch.xpack.ql.capabilities.UnresolvedException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.FunctionResolutionStrategy;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.util.StringUtils;

public class UnresolvedFunction
extends Function
implements Unresolvable {
    private final String name;
    private final String unresolvedMsg;
    private final FunctionResolutionStrategy resolution;
    private final boolean analyzed;

    public UnresolvedFunction(Source source, String name, FunctionResolutionStrategy resolutionStrategy, List<Expression> children) {
        this(source, name, resolutionStrategy, children, false, null);
    }

    UnresolvedFunction(Source source, String name, FunctionResolutionStrategy resolutionStrategy, List<Expression> children, boolean analyzed, String unresolvedMessage) {
        super(source, children);
        this.name = name;
        this.resolution = resolutionStrategy;
        this.analyzed = analyzed;
        this.unresolvedMsg = unresolvedMessage == null ? "Unknown " + resolutionStrategy.kind() + " [" + name + "]" : unresolvedMessage;
    }

    @Override
    protected NodeInfo<UnresolvedFunction> info() {
        return NodeInfo.create(this, UnresolvedFunction::new, this.name, this.resolution, this.children(), this.analyzed, this.unresolvedMsg);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new UnresolvedFunction(this.source(), this.name, this.resolution, newChildren, this.analyzed, this.unresolvedMsg);
    }

    public UnresolvedFunction withMessage(String message) {
        return new UnresolvedFunction(this.source(), this.name(), this.resolution, this.children(), true, message);
    }

    public Function buildResolved(Configuration configuration, FunctionDefinition def) {
        return this.resolution.buildResolved(this, configuration, def);
    }

    public UnresolvedFunction missing(String normalizedName, Iterable<FunctionDefinition> alternatives) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (FunctionDefinition def : alternatives) {
            if (!this.resolution.isValidAlternative(def)) continue;
            names.add(def.name());
            names.addAll(def.aliases());
        }
        List<String> matches = StringUtils.findSimilar(normalizedName, names);
        if (matches.isEmpty()) {
            return this;
        }
        String matchesMessage = matches.size() == 1 ? "[" + matches.get(0) + "]" : "any of " + matches;
        return this.withMessage("Unknown " + this.resolution.kind() + " [" + this.name + "], did you mean " + matchesMessage + "?");
    }

    @Override
    public boolean resolved() {
        return false;
    }

    public String name() {
        return this.name;
    }

    public FunctionResolutionStrategy resolutionStrategy() {
        return this.resolution;
    }

    public boolean analyzed() {
        return this.analyzed;
    }

    @Override
    public DataType dataType() {
        throw new UnresolvedException("dataType", (Object)this);
    }

    @Override
    public Nullability nullable() {
        throw new UnresolvedException("nullable", (Object)this);
    }

    @Override
    public ScriptTemplate asScript() {
        throw new UnresolvedException("script", (Object)this);
    }

    @Override
    public String unresolvedMessage() {
        return this.unresolvedMsg;
    }

    @Override
    public String toString() {
        return "?" + this.name + this.children();
    }

    @Override
    public String nodeString() {
        return this.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UnresolvedFunction other = (UnresolvedFunction)obj;
        return this.name.equals(other.name) && this.resolution.equals(other.resolution) && this.children().equals(other.children()) && this.analyzed == other.analyzed && Objects.equals(this.unresolvedMsg, other.unresolvedMsg);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.resolution, this.children(), this.analyzed, this.unresolvedMsg);
    }
}

