/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.action.BasicFormatter;
import org.elasticsearch.xpack.sql.action.SqlQueryResponse;
import org.elasticsearch.xpack.sql.plugin.TextFormatterCursor;
import org.elasticsearch.xpack.sql.proto.ColumnInfo;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Cursors;
import org.elasticsearch.xpack.sql.util.DateUtils;

enum TextFormat {
    PLAIN_TEXT{

        @Override
        String format(RestRequest request, SqlQueryResponse response) {
            BasicFormatter formatter = null;
            Cursor cursor = null;
            ZoneId zoneId = null;
            if (response.hasCursor()) {
                Tuple<Cursor, ZoneId> tuple = Cursors.decodeFromStringWithZone(response.cursor());
                cursor = (Cursor)tuple.v1();
                zoneId = (ZoneId)tuple.v2();
                if (cursor instanceof TextFormatterCursor) {
                    formatter = ((TextFormatterCursor)cursor).getFormatter();
                }
            }
            if (response.columns() != null) {
                formatter = new BasicFormatter(response.columns(), response.rows(), BasicFormatter.FormatOption.TEXT);
                if (cursor != null) {
                    response.cursor(Cursors.encodeToString(new TextFormatterCursor(cursor, formatter), zoneId));
                }
                return formatter.formatWithHeader(response.columns(), response.rows());
            }
            if (formatter != null) {
                return formatter.formatWithoutHeader(response.rows());
            }
            if (response.hasId()) {
                return "";
            }
            throw new SqlIllegalArgumentException("Cannot find text formatter - this is likely a bug");
        }

        @Override
        String shortName() {
            return TextFormat.FORMAT_TEXT;
        }

        @Override
        String contentType() {
            return TextFormat.CONTENT_TYPE_TXT;
        }

        @Override
        protected Character delimiter() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String eol() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    CSV{

        @Override
        protected Character delimiter() {
            return Character.valueOf(',');
        }

        @Override
        protected String eol() {
            return "\r\n";
        }

        @Override
        String shortName() {
            return TextFormat.FORMAT_CSV;
        }

        @Override
        String contentType() {
            return TextFormat.CONTENT_TYPE_CSV;
        }

        @Override
        String contentType(RestRequest request) {
            return this.contentType() + "; charset=utf-8; " + TextFormat.URL_PARAM_HEADER + "=" + (this.hasHeader(request) ? TextFormat.PARAM_HEADER_PRESENT : TextFormat.PARAM_HEADER_ABSENT);
        }

        @Override
        protected Character delimiter(RestRequest request) {
            String delimiterParam = request.param("delimiter");
            if (delimiterParam == null) {
                return this.delimiter();
            }
            try {
                delimiterParam = URLDecoder.decode(delimiterParam, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalArgumentException("delimiter [" + delimiterParam + "] cannot be decoded: " + uee.getMessage(), uee);
            }
            if (delimiterParam.length() != 1) {
                throw new IllegalArgumentException("invalid " + (delimiterParam.length() > 0 ? "multi-character" : "empty") + " delimiter [" + delimiterParam + "]");
            }
            Character delimiter = Character.valueOf(delimiterParam.charAt(0));
            switch (delimiter.charValue()) {
                case '\n': 
                case '\r': 
                case '\"': {
                    throw new IllegalArgumentException("illegal reserved character specified as delimiter [" + delimiter + "]");
                }
                case '\t': {
                    throw new IllegalArgumentException("illegal delimiter [TAB] specified as delimiter for the [csv] format; choose the [tsv] format instead");
                }
            }
            return delimiter;
        }

        @Override
        String maybeEscape(String value, Character delimiter) {
            boolean needsEscaping = false;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c != '\"' && c != '\n' && c != '\r' && c != delimiter.charValue()) continue;
                needsEscaping = true;
                break;
            }
            if (needsEscaping) {
                StringBuilder sb = new StringBuilder();
                sb.append('\"');
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (value.charAt(i) == '\"') {
                        sb.append('\"');
                    }
                    sb.append(c);
                }
                sb.append('\"');
                value = sb.toString();
            }
            return value;
        }

        @Override
        boolean hasHeader(RestRequest request) {
            String header = request.param(TextFormat.URL_PARAM_HEADER);
            if (header == null) {
                List values = request.getAllHeaderValues("Accept");
                if (values != null) {
                    for (String value : values) {
                        String[] params;
                        for (String param : params = Strings.tokenizeToStringArray((String)value, (String)";")) {
                            if (!param.toLowerCase(Locale.ROOT).equals("header=absent")) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
            return !header.toLowerCase(Locale.ROOT).equals(TextFormat.PARAM_HEADER_ABSENT);
        }
    }
    ,
    TSV{

        @Override
        protected Character delimiter() {
            return Character.valueOf('\t');
        }

        @Override
        protected String eol() {
            return "\n";
        }

        @Override
        String shortName() {
            return TextFormat.FORMAT_TSV;
        }

        @Override
        String contentType() {
            return TextFormat.CONTENT_TYPE_TSV;
        }

        @Override
        String contentType(RestRequest request) {
            return this.contentType() + "; charset=utf-8";
        }

        @Override
        String maybeEscape(String value, Character __) {
            StringBuilder sb = new StringBuilder();
            block4: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\n': {
                        sb.append("\\n");
                        continue block4;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block4;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
    };

    private static final String FORMAT_TEXT = "txt";
    private static final String FORMAT_CSV = "csv";
    private static final String FORMAT_TSV = "tsv";
    private static final String CONTENT_TYPE_TXT = "text/plain";
    private static final String CONTENT_TYPE_CSV = "text/csv";
    private static final String CONTENT_TYPE_TSV = "text/tab-separated-values";
    private static final String URL_PARAM_HEADER = "header";
    private static final String PARAM_HEADER_ABSENT = "absent";
    private static final String PARAM_HEADER_PRESENT = "present";

    String format(RestRequest request, SqlQueryResponse response) {
        StringBuilder sb = new StringBuilder();
        if (this.hasHeader(request) && response.columns() != null) {
            this.row(sb, response.columns(), ColumnInfo::name, this.delimiter(request));
        }
        for (List row : response.rows()) {
            this.row(sb, row, f -> f instanceof ZonedDateTime ? DateUtils.toString((ZonedDateTime)f) : Objects.toString(f, ""), this.delimiter(request));
        }
        return sb.toString();
    }

    boolean hasHeader(RestRequest request) {
        return true;
    }

    static TextFormat fromMediaTypeOrFormat(String accept) {
        for (TextFormat text : TextFormat.values()) {
            String contentType = text.contentType();
            if (!contentType.equalsIgnoreCase(accept) && !accept.toLowerCase(Locale.ROOT).startsWith(contentType + ";") && !text.shortName().equalsIgnoreCase(accept)) continue;
            return text;
        }
        throw new IllegalArgumentException("invalid format [" + accept + "]");
    }

    abstract String shortName();

    abstract String contentType();

    String contentType(RestRequest request) {
        return this.contentType();
    }

    <F> void row(StringBuilder sb, List<F> row, Function<F, String> toString, Character delimiter) {
        for (int i = 0; i < row.size(); ++i) {
            sb.append(this.maybeEscape(toString.apply(row.get(i)), delimiter));
            if (i >= row.size() - 1) continue;
            sb.append(delimiter);
        }
        sb.append(this.eol());
    }

    protected abstract Character delimiter();

    protected Character delimiter(RestRequest request) {
        return this.delimiter();
    }

    protected abstract String eol();

    String maybeEscape(String value, Character delimiter) {
        return value;
    }
}

