/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DiagnosticErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.parser.CaseChangingCharStream;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.parser.AbstractBuilder;
import org.elasticsearch.xpack.sql.parser.AstBuilder;
import org.elasticsearch.xpack.sql.parser.ExpressionBuilder;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.parser.SqlBaseBaseListener;
import org.elasticsearch.xpack.sql.parser.SqlBaseLexer;
import org.elasticsearch.xpack.sql.parser.SqlBaseParser;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class SqlParser {
    private static final Logger log = LogManager.getLogger();
    private final boolean DEBUG = false;
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, (Exception)((Object)e), line, charPositionInLine);
        }
    };

    public LogicalPlan createStatement(String sql) {
        return this.createStatement(sql, Collections.emptyList(), DateUtils.UTC);
    }

    public LogicalPlan createStatement(String sql, ZoneId zoneId) {
        return this.createStatement(sql, Collections.emptyList(), zoneId);
    }

    public LogicalPlan createStatement(String sql, List<SqlTypedParamValue> params, ZoneId zoneId) {
        if (log.isDebugEnabled()) {
            log.debug("Parsing as statement: {}", (Object)sql);
        }
        return this.invokeParser(sql, params, zoneId, SqlBaseParser::singleStatement, AbstractBuilder::plan);
    }

    public Expression createExpression(String expression) {
        return this.createExpression(expression, Collections.emptyList());
    }

    public Expression createExpression(String expression, List<SqlTypedParamValue> params) {
        if (log.isDebugEnabled()) {
            log.debug("Parsing as expression: {}", (Object)expression);
        }
        return this.invokeParser(expression, params, DateUtils.UTC, SqlBaseParser::singleExpression, ExpressionBuilder::expression);
    }

    private <T> T invokeParser(String sql, List<SqlTypedParamValue> params, ZoneId zoneId, Function<SqlBaseParser, ParserRuleContext> parseFunction, BiFunction<AstBuilder, ParserRuleContext, T> visitor) {
        try {
            SqlBaseLexer lexer = new SqlBaseLexer((CharStream)new CaseChangingCharStream((CharStream)CharStreams.fromString((String)sql), true));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            HashMap<Token, SqlTypedParamValue> paramTokens = new HashMap<Token, SqlTypedParamValue>();
            ParametrizedTokenSource tokenSource = new ParametrizedTokenSource((TokenSource)lexer, paramTokens, params);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)tokenSource);
            SqlBaseParser parser = new SqlBaseParser((TokenStream)tokenStream);
            parser.addParseListener(new PostProcessor(Arrays.asList(parser.getRuleNames())));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            ParserRuleContext tree = parseFunction.apply(parser);
            return visitor.apply(new AstBuilder(paramTokens, zoneId), tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException("SQL statement is too large, causing stack overflow when generating the parsing tree: [{}]", sql);
        }
    }

    private static void debug(SqlBaseParser parser) {
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
        parser.addParseListener((ParseTreeListener)new Parser.TraceListener((Parser)parser));
        parser.addErrorListener((ANTLRErrorListener)new DiagnosticErrorListener(false){

            public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
            }

            public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
            }
        });
    }

    private static class ParametrizedTokenSource
    implements TokenSource {
        private TokenSource delegate;
        private Map<Token, SqlTypedParamValue> paramTokens;
        private int param;
        private List<SqlTypedParamValue> params;

        ParametrizedTokenSource(TokenSource delegate, Map<Token, SqlTypedParamValue> paramTokens, List<SqlTypedParamValue> params) {
            this.delegate = delegate;
            this.paramTokens = paramTokens;
            this.params = params;
            this.param = 0;
        }

        public Token nextToken() {
            Token token = this.delegate.nextToken();
            if (token.getType() == 126) {
                if (this.param >= this.params.size()) {
                    throw new ParsingException("Not enough actual parameters {} ", this.params.size());
                }
                this.paramTokens.put(token, this.params.get(this.param));
                ++this.param;
            }
            return token;
        }

        public int getLine() {
            return this.delegate.getLine();
        }

        public int getCharPositionInLine() {
            return this.delegate.getCharPositionInLine();
        }

        public CharStream getInputStream() {
            return this.delegate.getInputStream();
        }

        public String getSourceName() {
            return this.delegate.getSourceName();
        }

        public void setTokenFactory(TokenFactory<?> factory) {
            this.delegate.setTokenFactory(factory);
        }

        public TokenFactory<?> getTokenFactory() {
            return this.delegate.getTokenFactory();
        }
    }

    private class PostProcessor
    extends SqlBaseBaseListener {
        private final List<String> ruleNames;

        PostProcessor(List<String> ruleNames) {
            this.ruleNames = ruleNames;
        }

        @Override
        public void exitBackQuotedIdentifier(SqlBaseParser.BackQuotedIdentifierContext context) {
            Token token = context.BACKQUOTED_IDENTIFIER().getSymbol();
            throw new ParsingException("backquoted identifiers not supported; please use double quotes instead", null, token.getLine(), token.getCharPositionInLine());
        }

        @Override
        public void exitDigitIdentifier(SqlBaseParser.DigitIdentifierContext context) {
            Token token = context.DIGIT_IDENTIFIER().getSymbol();
            throw new ParsingException("identifiers must not start with a digit; please use double quotes", null, token.getLine(), token.getCharPositionInLine());
        }

        @Override
        public void exitQuotedIdentifier(SqlBaseParser.QuotedIdentifierContext context) {
            context.getParent().removeLastChild();
            Token token = (Token)context.getChild(0).getPayload();
            context.getParent().addChild((Token)new CommonToken(new Pair((Object)token.getTokenSource(), (Object)token.getInputStream()), 130, token.getChannel(), token.getStartIndex() + 1, token.getStopIndex() - 1));
        }

        @Override
        public void exitNonReserved(SqlBaseParser.NonReservedContext context) {
            if (!(context.getChild(0) instanceof TerminalNode)) {
                int rule = ((ParserRuleContext)context.getChild(0)).getRuleIndex();
                throw new ParsingException("nonReserved can only contain tokens. Found nested rule: " + this.ruleNames.get(rule), new Object[0]);
            }
            context.getParent().removeLastChild();
            Token token = (Token)context.getChild(0).getPayload();
            context.getParent().addChild((Token)new CommonToken(new Pair((Object)token.getTokenSource(), (Object)token.getInputStream()), 130, token.getChannel(), token.getStartIndex(), token.getStopIndex()));
        }
    }
}

