/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plan.physical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.eql.execution.assembler.ExecutionManager;
import org.elasticsearch.xpack.eql.execution.search.Limit;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.eql.session.EqlSession;
import org.elasticsearch.xpack.eql.session.Payload;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class SequenceExec
extends PhysicalPlan {
    private final List<List<Attribute>> keys;
    private final Attribute timestamp;
    private final Attribute tiebreaker;
    private final Limit limit;
    private final Order.OrderDirection direction;
    private final TimeValue maxSpan;

    public SequenceExec(Source source, List<List<Attribute>> keys, List<PhysicalPlan> matches, List<Attribute> untilKeys, PhysicalPlan until, Attribute timestamp, Attribute tiebreaker, Order.OrderDirection direction, TimeValue maxSpan) {
        this(source, CollectionUtils.combine(matches, (Object[])new PhysicalPlan[]{until}), CollectionUtils.combine(keys, Collections.singletonList(untilKeys)), timestamp, tiebreaker, null, direction, maxSpan);
    }

    private SequenceExec(Source source, List<PhysicalPlan> children, List<List<Attribute>> keys, Attribute ts, Attribute tb, Limit limit, Order.OrderDirection direction, TimeValue maxSpan) {
        super(source, children);
        this.keys = keys;
        this.timestamp = ts;
        this.tiebreaker = tb;
        this.limit = limit;
        this.direction = direction;
        this.maxSpan = maxSpan;
    }

    protected NodeInfo<SequenceExec> info() {
        return NodeInfo.create((Node)this, SequenceExec::new, (Object)this.children(), this.keys, (Object)this.timestamp, (Object)this.tiebreaker, (Object)this.limit, (Object)this.direction, (Object)this.maxSpan);
    }

    public PhysicalPlan replaceChildren(List<PhysicalPlan> newChildren) {
        return new SequenceExec(this.source(), newChildren, this.keys, this.timestamp, this.tiebreaker, this.limit, this.direction, this.maxSpan);
    }

    @Override
    public List<Attribute> output() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(this.timestamp);
        if (Expressions.isPresent((NamedExpression)this.tiebreaker)) {
            attrs.add(this.tiebreaker);
        }
        for (List<Attribute> ne : this.keys) {
            attrs.addAll(Expressions.asAttributes(ne));
        }
        return attrs;
    }

    public List<List<Attribute>> keys() {
        return this.keys;
    }

    public Attribute timestamp() {
        return this.timestamp;
    }

    public Attribute tiebreaker() {
        return this.tiebreaker;
    }

    public Limit limit() {
        return this.limit;
    }

    public Order.OrderDirection direction() {
        return this.direction;
    }

    public SequenceExec with(Limit limitValue) {
        return new SequenceExec(this.source(), this.children(), this.keys(), this.timestamp(), this.tiebreaker(), limitValue, this.direction, this.maxSpan);
    }

    @Override
    public void execute(EqlSession session, ActionListener<Payload> listener) {
        new ExecutionManager(session).assemble(this.keys(), this.children(), this.timestamp(), this.tiebreaker(), this.direction, this.maxSpan, this.limit()).execute(listener);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.timestamp, this.tiebreaker, this.keys, this.limit, this.direction, this.children());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceExec other = (SequenceExec)obj;
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.tiebreaker, other.tiebreaker) && Objects.equals(this.limit, other.limit) && Objects.equals(this.direction, other.direction) && Objects.equals(this.children(), other.children()) && Objects.equals(this.keys, other.keys);
    }
}

