/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plan.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.plan.logical.KeyedFilter;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.Check;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class Join
extends LogicalPlan {
    private final List<KeyedFilter> queries;
    private final KeyedFilter until;
    private final Attribute timestamp;
    private final Attribute tiebreaker;
    private final Order.OrderDirection direction;

    public Join(Source source, List<KeyedFilter> queries, KeyedFilter until, Attribute timestamp, Attribute tiebreaker, Order.OrderDirection direction) {
        super(source, CollectionUtils.combine(queries, (Object[])new LogicalPlan[]{until}));
        this.queries = queries;
        this.until = until;
        this.timestamp = timestamp;
        this.tiebreaker = tiebreaker;
        this.direction = direction;
    }

    private Join(Source source, List<LogicalPlan> queries, LogicalPlan until, Attribute timestamp, Attribute tiebreaker, Order.OrderDirection direction) {
        this(source, Join.asKeyed(queries), Join.asKeyed(until), timestamp, tiebreaker, direction);
    }

    static List<KeyedFilter> asKeyed(List<LogicalPlan> list) {
        ArrayList<KeyedFilter> keyed = new ArrayList<KeyedFilter>(list.size());
        for (LogicalPlan logicalPlan : list) {
            Check.isTrue((boolean)KeyedFilter.class.isInstance(logicalPlan), (String)"Expected a KeyedFilter but received [{}]", (Object[])new Object[]{logicalPlan});
            keyed.add((KeyedFilter)logicalPlan);
        }
        return keyed;
    }

    static KeyedFilter asKeyed(LogicalPlan plan) {
        Check.isTrue((boolean)KeyedFilter.class.isInstance(plan), (String)"Expected a KeyedFilter but received [{}]", (Object[])new Object[]{plan});
        return (KeyedFilter)plan;
    }

    protected NodeInfo<? extends Join> info() {
        return NodeInfo.create((Node)this, Join::new, this.queries, (Object)((Object)this.until), (Object)this.timestamp, (Object)this.tiebreaker, (Object)this.direction);
    }

    public Join replaceChildren(List<LogicalPlan> newChildren) {
        int lastIndex = newChildren.size() - 1;
        return new Join(this.source(), newChildren.subList(0, lastIndex), newChildren.get(lastIndex), this.timestamp, this.tiebreaker, this.direction);
    }

    public List<Attribute> output() {
        ArrayList<Attribute> out = new ArrayList<Attribute>();
        out.add(this.timestamp);
        if (Expressions.isPresent((NamedExpression)this.tiebreaker)) {
            out.add(this.tiebreaker);
        }
        for (KeyedFilter query : this.queries) {
            out.addAll(query.output());
        }
        return out;
    }

    public boolean expressionsResolved() {
        return this.timestamp.resolved() && this.tiebreaker.resolved() && this.until.resolved() && Resolvables.resolved(this.queries);
    }

    public List<KeyedFilter> queries() {
        return this.queries;
    }

    public KeyedFilter until() {
        return this.until;
    }

    public Attribute timestamp() {
        return this.timestamp;
    }

    public Attribute tiebreaker() {
        return this.tiebreaker;
    }

    public Order.OrderDirection direction() {
        return this.direction;
    }

    public Join with(List<KeyedFilter> keyedFilterQueries, KeyedFilter untilFilter, Order.OrderDirection orderDirection) {
        return new Join(this.source(), keyedFilterQueries, untilFilter, this.timestamp, this.tiebreaker, orderDirection);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.direction, this.timestamp, this.tiebreaker, this.queries, this.until});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Join other = (Join)((Object)obj);
        return Objects.equals(this.direction, other.direction) && Objects.equals(this.queries, other.queries) && Objects.equals((Object)this.until, (Object)other.until) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.tiebreaker, other.tiebreaker);
    }

    public List<Object> nodeProperties() {
        return Collections.singletonList(this.direction);
    }
}

