/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.StringContainsFunctionProcessor;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class StringContainsFunctionPipe
extends Pipe {
    private final Pipe string;
    private final Pipe substring;
    private final boolean caseInsensitive;

    public StringContainsFunctionPipe(Source source, Expression expression, Pipe string, Pipe substring, boolean caseInsensitive) {
        super(source, expression, Arrays.asList(string, substring));
        this.string = string;
        this.substring = substring;
        this.caseInsensitive = caseInsensitive;
    }

    public final Pipe replaceChildren(List<Pipe> newChildren) {
        return this.replaceChildren(newChildren.get(0), newChildren.get(1));
    }

    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newString = this.string.resolveAttributes(resolver);
        Pipe newSubstring = this.substring.resolveAttributes(resolver);
        if (newString == this.string && newSubstring == this.substring) {
            return this;
        }
        return this.replaceChildren(newString, newSubstring);
    }

    public boolean supportedByAggsOnlyQuery() {
        return this.string.supportedByAggsOnlyQuery() && this.substring.supportedByAggsOnlyQuery();
    }

    public boolean resolved() {
        return this.string.resolved() && this.substring.resolved();
    }

    protected StringContainsFunctionPipe replaceChildren(Pipe pipeString, Pipe pipeSubstring) {
        return new StringContainsFunctionPipe(this.source(), this.expression(), pipeString, pipeSubstring, this.caseInsensitive);
    }

    public final void collectFields(QlSourceBuilder sourceBuilder) {
        this.string.collectFields(sourceBuilder);
        this.substring.collectFields(sourceBuilder);
    }

    protected NodeInfo<StringContainsFunctionPipe> info() {
        return NodeInfo.create((Node)this, StringContainsFunctionPipe::new, (Object)this.expression(), (Object)this.string, (Object)this.substring, (Object)this.caseInsensitive);
    }

    public StringContainsFunctionProcessor asProcessor() {
        return new StringContainsFunctionProcessor(this.string.asProcessor(), this.substring.asProcessor(), this.caseInsensitive);
    }

    public Pipe string() {
        return this.string;
    }

    public Pipe substring() {
        return this.substring;
    }

    protected boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public int hashCode() {
        return Objects.hash(this.string(), this.substring());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        StringContainsFunctionPipe other = (StringContainsFunctionPipe)((Object)obj);
        return Objects.equals(this.string(), other.string()) && Objects.equals(this.substring(), other.substring());
    }
}

