/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.querydsl.container;

import org.elasticsearch.search.aggregations.bucket.composite.MissingOrder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.ql.expression.Order;

public abstract class Sort {
    private final Direction direction;
    private final Missing missing;

    protected Sort(Direction direction, Missing nulls) {
        this.direction = direction;
        this.missing = nulls;
    }

    public Direction direction() {
        return this.direction;
    }

    public Missing missing() {
        return this.missing;
    }

    public static enum Direction {
        ASC,
        DESC;


        public static Direction from(Order.OrderDirection dir) {
            return dir == null || dir == Order.OrderDirection.ASC ? ASC : DESC;
        }

        public SortOrder asOrder() {
            return this == ASC ? SortOrder.ASC : SortOrder.DESC;
        }
    }

    public static enum Missing {
        FIRST("_first", MissingOrder.FIRST),
        LAST("_last", MissingOrder.LAST),
        ANY(null, null);

        private final String searchOrder;
        private final MissingOrder aggregationOrder;

        private Missing(String searchOrder, MissingOrder aggregationOrder) {
            this.searchOrder = searchOrder;
            this.aggregationOrder = aggregationOrder;
        }

        public static Missing from(Order.NullsPosition pos) {
            switch (pos) {
                case FIRST: {
                    return FIRST;
                }
                case LAST: {
                    return LAST;
                }
            }
            return ANY;
        }

        public String searchOrder() {
            return this.searchOrder(null);
        }

        public String searchOrder(Direction direction) {
            if (this.searchOrder != null) {
                return this.searchOrder;
            }
            switch (direction) {
                case ASC: {
                    return Missing.LAST.searchOrder;
                }
                case DESC: {
                    return Missing.FIRST.searchOrder;
                }
            }
            throw new IllegalArgumentException("Unknown direction [" + (Object)((Object)direction) + "]");
        }

        public MissingOrder aggregationOrder() {
            return this.aggregationOrder;
        }
    }
}

