/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.execute;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.watcher.support.xcontent.XContentSource;

public class ExecuteWatchResponse
extends ActionResponse
implements ToXContentObject {
    public static final ParseField ID_FIELD = new ParseField("_id", new String[0]);
    public static final ParseField WATCH_FIELD = new ParseField("watch_record", new String[0]);
    private String recordId;
    private XContentSource recordSource;
    private static final ConstructingObjectParser<ExecuteWatchResponse, Void> PARSER = new ConstructingObjectParser("x_pack_execute_watch_response", false, fields -> new ExecuteWatchResponse((String)fields[0], (BytesReference)fields[1], XContentType.JSON));

    public ExecuteWatchResponse(StreamInput in) throws IOException {
        super(in);
        this.recordId = in.readString();
        this.recordSource = XContentSource.readFrom(in);
    }

    public ExecuteWatchResponse(String recordId, BytesReference recordSource, XContentType contentType) {
        this.recordId = recordId;
        this.recordSource = new XContentSource(recordSource, contentType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteWatchResponse that = (ExecuteWatchResponse)o;
        return Objects.equals(this.recordId, that.recordId) && Objects.equals(this.recordSource, that.recordSource);
    }

    public int hashCode() {
        return Objects.hash(this.recordId, this.recordSource);
    }

    public String toString() {
        return this.recordId + ":" + this.recordSource;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public XContentSource getRecordSource() {
        return this.recordSource;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.recordId);
        XContentSource.writeTo(this.recordSource, out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("_id", this.recordId);
        builder.field("watch_record");
        this.recordSource.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static ExecuteWatchResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    private static BytesReference readBytesReference(XContentParser parser) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.copyCurrentStructure(parser);
            BytesReference bytesReference = BytesReference.bytes(builder);
            return bytesReference;
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ExecuteWatchResponse.readBytesReference(p), WATCH_FIELD);
    }
}

