/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.DestConfig;
import org.elasticsearch.xpack.core.transform.transforms.RetentionPolicyConfig;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.SyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.latest.LatestConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.PivotConfig;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class TransformConfig
extends AbstractDiffable<TransformConfig>
implements Writeable,
ToXContentObject {
    public static final Version CONFIG_VERSION_LAST_CHANGED = Version.V_7_15_0;
    public static final String NAME = "data_frame_transform_config";
    public static final ParseField HEADERS = new ParseField("headers", new String[0]);
    private static final Version FIELD_CAPS_RUNTIME_MAPPINGS_INTRODUCED_VERSION = Version.V_7_12_0;
    private static final ConstructingObjectParser<TransformConfig, String> STRICT_PARSER = TransformConfig.createParser(false);
    private static final ConstructingObjectParser<TransformConfig, String> LENIENT_PARSER = TransformConfig.createParser(true);
    static final int MAX_DESCRIPTION_LENGTH = 1000;
    private final String id;
    private final SourceConfig source;
    private final DestConfig dest;
    private final TimeValue frequency;
    private final SyncConfig syncConfig;
    private final SettingsConfig settings;
    private final Map<String, Object> metadata;
    private final RetentionPolicyConfig retentionPolicyConfig;
    private final String description;
    private Map<String, String> headers;
    private Version transformVersion;
    private Instant createTime;
    private final PivotConfig pivotConfig;
    private final LatestConfig latestConfig;

    private static void validateStrictParsingParams(Object arg, String parameterName) {
        if (arg != null) {
            throw new IllegalArgumentException("Found [" + parameterName + "], not allowed for strict parsing");
        }
    }

    private static ConstructingObjectParser<TransformConfig, String> createParser(boolean lenient) {
        ConstructingObjectParser<TransformConfig, String> parser = new ConstructingObjectParser<TransformConfig, String>(NAME, lenient, (args, optionalId) -> {
            String id = (String)args[0];
            if (id == null) {
                id = optionalId;
            } else if (optionalId != null && !id.equals(optionalId)) {
                throw new IllegalArgumentException(TransformMessages.getMessage("Inconsistent id; ''{0}'' specified in the body differs from ''{1}'' specified as a URL argument", id, optionalId));
            }
            SourceConfig source = (SourceConfig)args[1];
            DestConfig dest = (DestConfig)args[2];
            TimeValue frequency = args[3] == null ? null : TimeValue.parseTimeValue((String)args[3], TransformField.FREQUENCY.getPreferredName());
            SyncConfig syncConfig = (SyncConfig)args[4];
            if (!lenient) {
                TransformConfig.validateStrictParsingParams(args[6], HEADERS.getPreferredName());
                TransformConfig.validateStrictParsingParams(args[13], TransformField.CREATE_TIME.getPreferredName());
                TransformConfig.validateStrictParsingParams(args[14], TransformField.VERSION.getPreferredName());
                if (args[7] == null == (args[8] == null)) {
                    throw new IllegalArgumentException("Transform configuration must specify exactly 1 function");
                }
            }
            Map headers = (Map)args[6];
            PivotConfig pivotConfig = (PivotConfig)args[7];
            LatestConfig latestConfig = (LatestConfig)args[8];
            String description = (String)args[9];
            SettingsConfig settings = (SettingsConfig)args[10];
            Map metadata = (Map)args[11];
            RetentionPolicyConfig retentionPolicyConfig = (RetentionPolicyConfig)args[12];
            Instant createTime = (Instant)args[13];
            String version = (String)args[14];
            return new TransformConfig(id, source, dest, frequency, syncConfig, headers, pivotConfig, latestConfig, description, settings, metadata, retentionPolicyConfig, createTime, version);
        });
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.ID);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> SourceConfig.fromXContent(p, lenient), TransformField.SOURCE);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DestConfig.fromXContent(p, lenient), TransformField.DESTINATION);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.FREQUENCY);
        parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> p.namedObject(SyncConfig.class, n, c), TransformField.SYNC);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.INDEX_DOC_TYPE);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapStrings(), HEADERS);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PivotConfig.fromXContent(p, lenient), Function.PIVOT.getParseField());
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> LatestConfig.fromXContent(p, lenient), Function.LATEST.getParseField());
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.DESCRIPTION);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SettingsConfig.fromXContent(p, lenient), TransformField.SETTINGS);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), TransformField.METADATA);
        parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> p.namedObject(RetentionPolicyConfig.class, n, c), TransformField.RETENTION_POLICY);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, TransformField.CREATE_TIME.getPreferredName()), TransformField.CREATE_TIME, ObjectParser.ValueType.VALUE);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.VERSION);
        return parser;
    }

    public static String documentId(String transformId) {
        return "data_frame_transform_config-" + transformId;
    }

    public TransformConfig(String id, SourceConfig source, DestConfig dest, TimeValue frequency, SyncConfig syncConfig, Map<String, String> headers, PivotConfig pivotConfig, LatestConfig latestConfig, String description, SettingsConfig settings, Map<String, Object> metadata, RetentionPolicyConfig retentionPolicyConfig, Instant createTime, String version) {
        this.id = ExceptionsHelper.requireNonNull(id, TransformField.ID.getPreferredName());
        this.source = ExceptionsHelper.requireNonNull(source, TransformField.SOURCE.getPreferredName());
        this.dest = ExceptionsHelper.requireNonNull(dest, TransformField.DESTINATION.getPreferredName());
        this.frequency = frequency;
        this.syncConfig = syncConfig;
        this.setHeaders(headers == null ? Collections.emptyMap() : headers);
        this.pivotConfig = pivotConfig;
        this.latestConfig = latestConfig;
        this.description = description;
        this.settings = settings == null ? new SettingsConfig() : settings;
        this.metadata = metadata;
        this.retentionPolicyConfig = retentionPolicyConfig;
        if (this.description != null && this.description.length() > 1000) {
            throw new IllegalArgumentException("[description] must be less than 1000 characters in length.");
        }
        this.createTime = createTime == null ? null : Instant.ofEpochMilli(createTime.toEpochMilli());
        this.transformVersion = version == null ? null : Version.fromString(version);
    }

    public TransformConfig(StreamInput in) throws IOException {
        this.id = in.readString();
        this.source = new SourceConfig(in);
        this.dest = new DestConfig(in);
        this.frequency = in.getVersion().onOrAfter(Version.V_7_3_0) ? in.readOptionalTimeValue() : null;
        this.setHeaders(in.readMap(StreamInput::readString, StreamInput::readString));
        this.pivotConfig = in.readOptionalWriteable(PivotConfig::new);
        this.latestConfig = in.getVersion().onOrAfter(Version.V_7_11_0) ? in.readOptionalWriteable(LatestConfig::new) : null;
        this.description = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
            this.syncConfig = in.readOptionalNamedWriteable(SyncConfig.class);
            this.createTime = in.readOptionalInstant();
            this.transformVersion = in.readBoolean() ? Version.readVersion(in) : null;
        } else {
            this.syncConfig = null;
            this.createTime = null;
            this.transformVersion = null;
        }
        this.settings = in.getVersion().onOrAfter(Version.V_7_8_0) ? new SettingsConfig(in) : new SettingsConfig();
        this.metadata = in.getVersion().onOrAfter(Version.V_7_16_0) ? in.readMap() : null;
        this.retentionPolicyConfig = in.getVersion().onOrAfter(Version.V_7_12_0) ? in.readOptionalNamedWriteable(RetentionPolicyConfig.class) : null;
    }

    public String getId() {
        return this.id;
    }

    public SourceConfig getSource() {
        return this.source;
    }

    public DestConfig getDestination() {
        return this.dest;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public SyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public TransformConfig setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Version getVersion() {
        return this.transformVersion;
    }

    public TransformConfig setVersion(Version version) {
        this.transformVersion = version;
        return this;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public TransformConfig setCreateTime(Instant createTime) {
        ExceptionsHelper.requireNonNull(createTime, TransformField.CREATE_TIME.getPreferredName());
        this.createTime = Instant.ofEpochMilli(createTime.toEpochMilli());
        return this;
    }

    public PivotConfig getPivotConfig() {
        return this.pivotConfig;
    }

    public LatestConfig getLatestConfig() {
        return this.latestConfig;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public SettingsConfig getSettings() {
        return this.settings;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Nullable
    public RetentionPolicyConfig getRetentionPolicyConfig() {
        return this.retentionPolicyConfig;
    }

    public List<SourceDestValidator.SourceDestValidation> getAdditionalSourceDestValidations() {
        if (!(this.source.getRuntimeMappings() == null || this.source.getRuntimeMappings().isEmpty())) {
            SourceDestValidator.RemoteClusterMinimumVersionValidation validation = new SourceDestValidator.RemoteClusterMinimumVersionValidation(FIELD_CAPS_RUNTIME_MAPPINGS_INTRODUCED_VERSION, "source.runtime_mappings field was set");
            return Collections.singletonList(validation);
        }
        return Collections.emptyList();
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        validationException = this.source.validate(validationException);
        validationException = this.dest.validate(validationException);
        validationException = this.settings.validate(validationException);
        if (this.pivotConfig != null) {
            validationException = this.pivotConfig.validate(validationException);
        }
        if (this.latestConfig != null) {
            validationException = this.latestConfig.validate(validationException);
        }
        if (this.retentionPolicyConfig != null) {
            validationException = this.retentionPolicyConfig.validate(validationException);
        }
        return validationException;
    }

    public List<DeprecationIssue> checkForDeprecations(NamedXContentRegistry namedXContentRegistry) {
        ArrayList<DeprecationIssue> deprecations = new ArrayList<DeprecationIssue>();
        if (this.getVersion() == null || this.getVersion().before(Version.V_7_5_0)) {
            deprecations.add(new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Transform [" + this.id + "] uses an obsolete configuration format", "https://ela.st/es-7-upgrade-transforms", "Use [_update] or [_upgrade] to update the configuration of [" + this.id + "].", false, null));
        }
        this.source.checkForDeprecations(this.getId(), namedXContentRegistry, deprecations::add);
        this.dest.checkForDeprecations(this.getId(), namedXContentRegistry, deprecations::add);
        this.settings.checkForDeprecations(this.getId(), namedXContentRegistry, deprecations::add);
        if (this.pivotConfig != null) {
            this.pivotConfig.checkForDeprecations(this.getId(), namedXContentRegistry, deprecations::add);
        }
        if (this.latestConfig != null) {
            this.latestConfig.checkForDeprecations(this.getId(), namedXContentRegistry, deprecations::add);
        }
        if (this.retentionPolicyConfig != null) {
            this.retentionPolicyConfig.checkForDeprecations(this.getId(), namedXContentRegistry, deprecations::add);
        }
        return deprecations;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        this.source.writeTo(out);
        this.dest.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalTimeValue(this.frequency);
        }
        out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        out.writeOptionalWriteable(this.pivotConfig);
        if (out.getVersion().onOrAfter(Version.V_7_11_0)) {
            out.writeOptionalWriteable(this.latestConfig);
        }
        out.writeOptionalString(this.description);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalNamedWriteable(this.syncConfig);
            out.writeOptionalInstant(this.createTime);
            if (this.transformVersion != null) {
                out.writeBoolean(true);
                Version.writeVersion(this.transformVersion, out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            this.settings.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_7_16_0)) {
            out.writeMap(this.metadata);
        }
        if (out.getVersion().onOrAfter(Version.V_7_12_0)) {
            out.writeOptionalNamedWriteable(this.retentionPolicyConfig);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean excludeGenerated = params.paramAsBoolean("exclude_generated", false);
        boolean forInternalStorage = params.paramAsBoolean("for_internal_storage", false);
        assert (!(forInternalStorage && excludeGenerated)) : "unsupported behavior, exclude_generated is true and for_internal_storage is true";
        builder.startObject();
        builder.field(TransformField.ID.getPreferredName(), this.id);
        if (!excludeGenerated) {
            if (!this.headers.isEmpty() && forInternalStorage) {
                builder.field(HEADERS.getPreferredName(), this.headers);
            }
            if (this.transformVersion != null) {
                builder.field(TransformField.VERSION.getPreferredName(), this.transformVersion);
            }
            if (this.createTime != null) {
                builder.timeField(TransformField.CREATE_TIME.getPreferredName(), TransformField.CREATE_TIME.getPreferredName() + "_string", this.createTime.toEpochMilli());
            }
            if (forInternalStorage) {
                builder.field(TransformField.INDEX_DOC_TYPE.getPreferredName(), NAME);
            }
        }
        builder.field(TransformField.SOURCE.getPreferredName(), this.source, params);
        builder.field(TransformField.DESTINATION.getPreferredName(), this.dest);
        if (this.frequency != null) {
            builder.field(TransformField.FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        if (this.syncConfig != null) {
            builder.startObject(TransformField.SYNC.getPreferredName());
            builder.field(this.syncConfig.getWriteableName(), this.syncConfig);
            builder.endObject();
        }
        if (this.pivotConfig != null) {
            builder.field(Function.PIVOT.getParseField().getPreferredName(), this.pivotConfig);
        }
        if (this.latestConfig != null) {
            builder.field(Function.LATEST.getParseField().getPreferredName(), this.latestConfig);
        }
        if (this.description != null) {
            builder.field(TransformField.DESCRIPTION.getPreferredName(), this.description);
        }
        builder.field(TransformField.SETTINGS.getPreferredName(), this.settings);
        if (this.metadata != null) {
            builder.field(TransformField.METADATA.getPreferredName(), this.metadata);
        }
        if (this.retentionPolicyConfig != null) {
            builder.startObject(TransformField.RETENTION_POLICY.getPreferredName());
            builder.field(this.retentionPolicyConfig.getWriteableName(), this.retentionPolicyConfig);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformConfig that = (TransformConfig)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.syncConfig, that.syncConfig) && Objects.equals(this.headers, that.headers) && Objects.equals(this.pivotConfig, that.pivotConfig) && Objects.equals(this.latestConfig, that.latestConfig) && Objects.equals(this.description, that.description) && Objects.equals(this.settings, that.settings) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.retentionPolicyConfig, that.retentionPolicyConfig) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.transformVersion, that.transformVersion);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.dest, this.frequency, this.syncConfig, this.headers, this.pivotConfig, this.latestConfig, this.description, this.settings, this.metadata, this.retentionPolicyConfig, this.createTime, this.transformVersion);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static TransformConfig fromXContent(XContentParser parser, @Nullable String optionalTransformId, boolean lenient) {
        return lenient ? LENIENT_PARSER.apply(parser, optionalTransformId) : STRICT_PARSER.apply(parser, optionalTransformId);
    }

    public static TransformConfig rewriteForUpdate(TransformConfig transformConfig) {
        if (transformConfig.getVersion() != null && transformConfig.getVersion().onOrAfter(CONFIG_VERSION_LAST_CHANGED) && (transformConfig.getPivotConfig() == null || transformConfig.getPivotConfig().getMaxPageSearchSize() == null)) {
            return transformConfig;
        }
        Builder builder = new Builder(transformConfig);
        return TransformConfig.applyRewriteForUpdate(builder);
    }

    private static TransformConfig applyRewriteForUpdate(Builder builder) {
        if (builder.getPivotConfig() != null && builder.getPivotConfig().getMaxPageSearchSize() != null) {
            Integer maxPageSearchSizeDeprecated = builder.getPivotConfig().getMaxPageSearchSize();
            Integer maxPageSearchSize = builder.getSettings().getMaxPageSearchSize() != null ? builder.getSettings().getMaxPageSearchSize() : maxPageSearchSizeDeprecated;
            builder.setPivotConfig(new PivotConfig(builder.getPivotConfig().getGroupConfig(), builder.getPivotConfig().getAggregationConfig(), null));
            builder.setSettings(new SettingsConfig(maxPageSearchSize, builder.getSettings().getDocsPerSecond(), builder.getSettings().getDatesAsEpochMillis(), builder.getSettings().getAlignCheckpoints()));
        }
        if (builder.getVersion() != null && builder.getVersion().before(Version.V_7_11_0)) {
            builder.setSettings(new SettingsConfig(builder.getSettings().getMaxPageSearchSize(), builder.getSettings().getDocsPerSecond(), true, builder.getSettings().getAlignCheckpoints()));
        }
        if (builder.getVersion() != null && builder.getVersion().before(CONFIG_VERSION_LAST_CHANGED)) {
            builder.setSettings(new SettingsConfig(builder.getSettings().getMaxPageSearchSize(), builder.getSettings().getDocsPerSecond(), builder.getSettings().getDatesAsEpochMillis(), false));
        }
        return builder.setVersion(Version.CURRENT).build();
    }

    public static enum Function {
        PIVOT,
        LATEST;

        private final ParseField parseField = new ParseField(this.name().toLowerCase(Locale.ROOT), new String[0]);

        public ParseField getParseField() {
            return this.parseField;
        }
    }

    public static class Builder {
        private String id;
        private SourceConfig source;
        private DestConfig dest;
        private TimeValue frequency;
        private SyncConfig syncConfig;
        private String description;
        private Map<String, String> headers;
        private Version transformVersion;
        private Instant createTime;
        private PivotConfig pivotConfig;
        private LatestConfig latestConfig;
        private SettingsConfig settings;
        private Map<String, Object> metadata;
        private RetentionPolicyConfig retentionPolicyConfig;

        public Builder() {
        }

        public Builder(TransformConfig config) {
            this.id = config.id;
            this.source = config.source;
            this.dest = config.dest;
            this.frequency = config.frequency;
            this.syncConfig = config.syncConfig;
            this.description = config.description;
            this.transformVersion = config.transformVersion;
            this.createTime = config.createTime;
            this.pivotConfig = config.pivotConfig;
            this.latestConfig = config.latestConfig;
            this.settings = config.settings;
            this.metadata = config.metadata;
            this.retentionPolicyConfig = config.retentionPolicyConfig;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        String getId() {
            return this.id;
        }

        public Builder setSource(SourceConfig source) {
            this.source = source;
            return this;
        }

        SourceConfig getSource() {
            return this.source;
        }

        public Builder setDest(DestConfig dest) {
            this.dest = dest;
            return this;
        }

        DestConfig getDest() {
            return this.dest;
        }

        public Builder setFrequency(TimeValue frequency) {
            this.frequency = frequency;
            return this;
        }

        TimeValue getFrequency() {
            return this.frequency;
        }

        public Builder setSyncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        SyncConfig getSyncConfig() {
            return this.syncConfig;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        String getDescription() {
            return this.description;
        }

        public Builder setSettings(SettingsConfig settings) {
            this.settings = settings;
            return this;
        }

        SettingsConfig getSettings() {
            return this.settings;
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Builder setPivotConfig(PivotConfig pivotConfig) {
            this.pivotConfig = pivotConfig;
            return this;
        }

        PivotConfig getPivotConfig() {
            return this.pivotConfig;
        }

        public Builder setLatestConfig(LatestConfig latestConfig) {
            this.latestConfig = latestConfig;
            return this;
        }

        public LatestConfig getLatestConfig() {
            return this.latestConfig;
        }

        Builder setVersion(Version version) {
            this.transformVersion = version;
            return this;
        }

        Version getVersion() {
            return this.transformVersion;
        }

        public Builder setRetentionPolicyConfig(RetentionPolicyConfig retentionPolicyConfig) {
            this.retentionPolicyConfig = retentionPolicyConfig;
            return this;
        }

        public TransformConfig build() {
            return new TransformConfig(this.id, this.source, this.dest, this.frequency, this.syncConfig, this.headers, this.pivotConfig, this.latestConfig, this.description, this.settings, this.metadata, this.retentionPolicyConfig, this.createTime, this.transformVersion == null ? null : this.transformVersion.toString());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Builder that = (Builder)other;
            return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.syncConfig, that.syncConfig) && Objects.equals(this.headers, that.headers) && Objects.equals(this.pivotConfig, that.pivotConfig) && Objects.equals(this.latestConfig, that.latestConfig) && Objects.equals(this.description, that.description) && Objects.equals(this.settings, that.settings) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.retentionPolicyConfig, that.retentionPolicyConfig) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.transformVersion, that.transformVersion);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.source, this.dest, this.frequency, this.syncConfig, this.headers, this.pivotConfig, this.latestConfig, this.description, this.settings, this.metadata, this.retentionPolicyConfig, this.createTime, this.transformVersion);
        }
    }
}

