/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionModel;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionParser;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;

public final class ExceptExpression
implements RoleMapperExpression {
    public static final String NAME = "except";
    private final RoleMapperExpression expression;

    ExceptExpression(RoleMapperExpression expression) {
        assert (expression != null);
        this.expression = expression;
    }

    public ExceptExpression(StreamInput in) throws IOException {
        this(ExpressionParser.readExpression(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        ExpressionParser.writeExpression(this.expression, out);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean match(ExpressionModel model) {
        return !this.expression.match(model);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptExpression that = (ExceptExpression)o;
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    RoleMapperExpression getInnerExpression() {
        return this.expression;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ExpressionParser.Fields.EXCEPT.getPreferredName());
        this.expression.toXContent(builder, params);
        return builder.endObject();
    }
}

