/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.PoolingSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.SearchGroupsResolverSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.UserAttributeGroupsResolverSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.core.security.authc.ldap.support.SessionFactorySettings;

public final class LdapUserSearchSessionFactorySettings {
    public static final Setting.AffixSetting<String> SEARCH_ATTRIBUTE = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("ldap"), "user_search.attribute", key -> new Setting((String)key, DEFAULT_USERNAME_ATTRIBUTE, Function.identity(), Setting.Property.NodeScope, Setting.Property.DeprecatedWarning), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> SEARCH_BASE_DN = RealmSettings.simpleString("ldap", "user_search.base_dn", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> SEARCH_FILTER = RealmSettings.simpleString("ldap", "user_search.filter", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<LdapSearchScope> SEARCH_SCOPE = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("ldap"), "user_search.scope", key -> new Setting<LdapSearchScope>((String)key, (String)null, s -> LdapSearchScope.resolve(s, LdapSearchScope.SUB_TREE), Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> POOL_ENABLED = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("ldap"), "user_search.pool.enabled", key -> Setting.boolSetting(key, true, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    private static final String DEFAULT_USERNAME_ATTRIBUTE = "uid";

    private LdapUserSearchSessionFactorySettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(SessionFactorySettings.getSettings("ldap"));
        settings.addAll(PoolingSessionFactorySettings.getSettings("ldap"));
        settings.add(SEARCH_BASE_DN);
        settings.add(SEARCH_SCOPE);
        settings.add(SEARCH_ATTRIBUTE);
        settings.add(POOL_ENABLED);
        settings.add(SEARCH_FILTER);
        settings.addAll(SearchGroupsResolverSettings.getSettings("ldap"));
        settings.addAll(UserAttributeGroupsResolverSettings.getSettings());
        return settings;
    }
}

