/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;

public class GetServiceAccountRequest
extends ActionRequest {
    @Nullable
    private final String namespace;
    @Nullable
    private final String serviceName;

    public GetServiceAccountRequest(@Nullable String namespace, @Nullable String serviceName) {
        this.namespace = namespace;
        this.serviceName = serviceName;
    }

    public GetServiceAccountRequest(StreamInput in) throws IOException {
        super(in);
        this.namespace = in.readOptionalString();
        this.serviceName = in.readOptionalString();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetServiceAccountRequest that = (GetServiceAccountRequest)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.serviceName, that.serviceName);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.serviceName);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.namespace);
        out.writeOptionalString(this.serviceName);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }
}

