/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class MonitoringFeatureSetUsage
extends XPackFeatureSet.Usage {
    @Nullable
    private Boolean collectionEnabled;
    @Nullable
    private Map<String, Object> exporters;

    public MonitoringFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.exporters = in.readMap();
        if (in.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.collectionEnabled = in.readOptionalBoolean();
        }
    }

    public MonitoringFeatureSetUsage(boolean collectionEnabled, Map<String, Object> exporters) {
        super("monitoring", true, true);
        this.exporters = exporters;
        this.collectionEnabled = collectionEnabled;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_7_0_0;
    }

    public Map<String, Object> getExporters() {
        return this.exporters == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.exporters);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.exporters);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeOptionalBoolean(this.collectionEnabled);
        }
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (this.collectionEnabled != null) {
            builder.field("collection_enabled", this.collectionEnabled);
        }
        if (this.exporters != null) {
            builder.field("enabled_exporters", this.exporters);
        }
    }
}

