/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.Blocked;
import org.elasticsearch.xpack.core.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.core.ml.job.config.PerPartitionCategorizationConfig;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class JobUpdate
implements Writeable,
ToXContentObject {
    public static final ParseField DETECTORS = new ParseField("detectors", new String[0]);
    public static final ParseField CLEAR_JOB_FINISH_TIME = new ParseField("clear_job_finish_time", new String[0]);
    static final ConstructingObjectParser<Builder, Void> INTERNAL_PARSER = new ConstructingObjectParser("job_update", args -> new Builder((String)args[0]));
    public static final ConstructingObjectParser<Builder, Void> EXTERNAL_PARSER = new ConstructingObjectParser("job_update", args -> new Builder((String)args[0]));
    private final String jobId;
    private final List<String> groups;
    private final String description;
    private final List<DetectorUpdate> detectorUpdates;
    private final ModelPlotConfig modelPlotConfig;
    private final AnalysisLimits analysisLimits;
    private final Long renormalizationWindowDays;
    private final TimeValue backgroundPersistInterval;
    private final Long modelSnapshotRetentionDays;
    private final Long dailyModelSnapshotRetentionAfterDays;
    private final Long resultsRetentionDays;
    private final List<String> categorizationFilters;
    private final PerPartitionCategorizationConfig perPartitionCategorizationConfig;
    private final Map<String, Object> customSettings;
    private final String modelSnapshotId;
    private final Version modelSnapshotMinVersion;
    private final Version jobVersion;
    private final Boolean clearJobFinishTime;
    private final Boolean allowLazyOpen;
    private final Blocked blocked;
    private final TimeValue modelPruneWindow;

    private JobUpdate(String jobId, @Nullable List<String> groups, @Nullable String description, @Nullable List<DetectorUpdate> detectorUpdates, @Nullable ModelPlotConfig modelPlotConfig, @Nullable AnalysisLimits analysisLimits, @Nullable TimeValue backgroundPersistInterval, @Nullable Long renormalizationWindowDays, @Nullable Long resultsRetentionDays, @Nullable Long modelSnapshotRetentionDays, @Nullable Long dailyModelSnapshotRetentionAfterDays, @Nullable List<String> categorizationFilters, @Nullable PerPartitionCategorizationConfig perPartitionCategorizationConfig, @Nullable Map<String, Object> customSettings, @Nullable String modelSnapshotId, @Nullable Version modelSnapshotMinVersion, @Nullable Version jobVersion, @Nullable Boolean clearJobFinishTime, @Nullable Boolean allowLazyOpen, @Nullable Blocked blocked, @Nullable TimeValue modelPruneWindow) {
        this.jobId = jobId;
        this.groups = groups;
        this.description = description;
        this.detectorUpdates = detectorUpdates;
        this.modelPlotConfig = modelPlotConfig;
        this.analysisLimits = analysisLimits;
        this.renormalizationWindowDays = renormalizationWindowDays;
        this.backgroundPersistInterval = backgroundPersistInterval;
        this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
        this.dailyModelSnapshotRetentionAfterDays = dailyModelSnapshotRetentionAfterDays;
        this.resultsRetentionDays = resultsRetentionDays;
        this.categorizationFilters = categorizationFilters;
        this.perPartitionCategorizationConfig = perPartitionCategorizationConfig;
        this.customSettings = customSettings;
        this.modelSnapshotId = modelSnapshotId;
        this.modelSnapshotMinVersion = modelSnapshotMinVersion;
        this.jobVersion = jobVersion;
        this.clearJobFinishTime = clearJobFinishTime;
        this.allowLazyOpen = allowLazyOpen;
        this.blocked = blocked;
        this.modelPruneWindow = modelPruneWindow;
    }

    public JobUpdate(StreamInput in) throws IOException {
        String[] groupsArray;
        this.jobId = in.readString();
        this.groups = in.getVersion().onOrAfter(Version.V_6_1_0) ? ((groupsArray = in.readOptionalStringArray()) == null ? null : Arrays.asList(groupsArray)) : null;
        this.description = in.readOptionalString();
        this.detectorUpdates = in.readBoolean() ? in.readList(DetectorUpdate::new) : null;
        this.modelPlotConfig = in.readOptionalWriteable(ModelPlotConfig::new);
        this.analysisLimits = in.readOptionalWriteable(AnalysisLimits::new);
        this.renormalizationWindowDays = in.readOptionalLong();
        this.backgroundPersistInterval = in.readOptionalTimeValue();
        this.modelSnapshotRetentionDays = in.readOptionalLong();
        this.dailyModelSnapshotRetentionAfterDays = in.getVersion().onOrAfter(Version.V_7_8_0) ? in.readOptionalLong() : null;
        this.resultsRetentionDays = in.readOptionalLong();
        this.categorizationFilters = in.readBoolean() ? in.readStringList() : null;
        this.perPartitionCategorizationConfig = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readOptionalWriteable(PerPartitionCategorizationConfig::new) : null;
        this.customSettings = in.readMap();
        this.modelSnapshotId = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_6_1_0) && in.getVersion().before(Version.V_7_0_0)) {
            in.readOptionalLong();
        }
        this.jobVersion = in.getVersion().onOrAfter(Version.V_6_3_0) && in.readBoolean() ? Version.readVersion(in) : null;
        this.clearJobFinishTime = in.getVersion().onOrAfter(Version.V_6_6_0) ? in.readOptionalBoolean() : null;
        this.modelSnapshotMinVersion = in.getVersion().onOrAfter(Version.V_7_0_0) && in.readBoolean() ? Version.readVersion(in) : null;
        this.allowLazyOpen = in.getVersion().onOrAfter(Version.V_7_5_0) ? in.readOptionalBoolean() : null;
        this.blocked = in.getVersion().onOrAfter(Version.V_7_14_0) ? in.readOptionalWriteable(Blocked::new) : null;
        this.modelPruneWindow = in.getVersion().onOrAfter(Version.V_7_15_0) ? in.readOptionalTimeValue() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        String[] groupsArray = this.groups == null ? null : this.groups.toArray(new String[0]);
        out.writeOptionalStringArray(groupsArray);
        out.writeOptionalString(this.description);
        out.writeBoolean(this.detectorUpdates != null);
        if (this.detectorUpdates != null) {
            out.writeList(this.detectorUpdates);
        }
        out.writeOptionalWriteable(this.modelPlotConfig);
        out.writeOptionalWriteable(this.analysisLimits);
        out.writeOptionalLong(this.renormalizationWindowDays);
        out.writeOptionalTimeValue(this.backgroundPersistInterval);
        out.writeOptionalLong(this.modelSnapshotRetentionDays);
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeOptionalLong(this.dailyModelSnapshotRetentionAfterDays);
        }
        out.writeOptionalLong(this.resultsRetentionDays);
        out.writeBoolean(this.categorizationFilters != null);
        if (this.categorizationFilters != null) {
            out.writeStringCollection(this.categorizationFilters);
        }
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeOptionalWriteable(this.perPartitionCategorizationConfig);
        }
        out.writeMap(this.customSettings);
        out.writeOptionalString(this.modelSnapshotId);
        if (out.getVersion().onOrAfter(Version.V_6_1_0) && out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalLong(null);
        }
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            if (this.jobVersion != null) {
                out.writeBoolean(true);
                Version.writeVersion(this.jobVersion, out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeOptionalBoolean(this.clearJobFinishTime);
        }
        if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
            if (this.modelSnapshotMinVersion != null) {
                out.writeBoolean(true);
                Version.writeVersion(this.modelSnapshotMinVersion, out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_7_5_0)) {
            out.writeOptionalBoolean(this.allowLazyOpen);
        }
        if (out.getVersion().onOrAfter(Version.V_7_14_0)) {
            out.writeOptionalWriteable(this.blocked);
        }
        if (out.getVersion().onOrAfter(Version.V_7_15_0)) {
            out.writeOptionalTimeValue(this.modelPruneWindow);
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getDescription() {
        return this.description;
    }

    public List<DetectorUpdate> getDetectorUpdates() {
        return this.detectorUpdates;
    }

    public ModelPlotConfig getModelPlotConfig() {
        return this.modelPlotConfig;
    }

    public AnalysisLimits getAnalysisLimits() {
        return this.analysisLimits;
    }

    public Long getRenormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    public TimeValue getBackgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    public Long getModelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    public Long getDailyModelSnapshotRetentionAfterDays() {
        return this.dailyModelSnapshotRetentionAfterDays;
    }

    public Long getResultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    public List<String> getCategorizationFilters() {
        return this.categorizationFilters;
    }

    public PerPartitionCategorizationConfig getPerPartitionCategorizationConfig() {
        return this.perPartitionCategorizationConfig;
    }

    public Map<String, Object> getCustomSettings() {
        return this.customSettings;
    }

    public String getModelSnapshotId() {
        return this.modelSnapshotId;
    }

    public Version getModelSnapshotMinVersion() {
        return this.modelSnapshotMinVersion;
    }

    public Version getJobVersion() {
        return this.jobVersion;
    }

    public Boolean getClearJobFinishTime() {
        return this.clearJobFinishTime;
    }

    public Boolean getAllowLazyOpen() {
        return this.allowLazyOpen;
    }

    public boolean isAutodetectProcessUpdate() {
        return this.modelPlotConfig != null || this.perPartitionCategorizationConfig != null || this.detectorUpdates != null || this.groups != null;
    }

    public Blocked getBlocked() {
        return this.blocked;
    }

    public TimeValue getModelPruneWindow() {
        return this.modelPruneWindow;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.groups != null) {
            builder.field(Job.GROUPS.getPreferredName(), this.groups);
        }
        if (this.description != null) {
            builder.field(Job.DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.detectorUpdates != null) {
            builder.field(DETECTORS.getPreferredName(), this.detectorUpdates);
        }
        if (this.modelPlotConfig != null) {
            builder.field(Job.MODEL_PLOT_CONFIG.getPreferredName(), this.modelPlotConfig);
        }
        if (this.analysisLimits != null) {
            builder.field(Job.ANALYSIS_LIMITS.getPreferredName(), this.analysisLimits);
        }
        if (this.renormalizationWindowDays != null) {
            builder.field(Job.RENORMALIZATION_WINDOW_DAYS.getPreferredName(), this.renormalizationWindowDays);
        }
        if (this.backgroundPersistInterval != null) {
            builder.field(Job.BACKGROUND_PERSIST_INTERVAL.getPreferredName(), this.backgroundPersistInterval);
        }
        if (this.modelSnapshotRetentionDays != null) {
            builder.field(Job.MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), this.modelSnapshotRetentionDays);
        }
        if (this.dailyModelSnapshotRetentionAfterDays != null) {
            builder.field(Job.DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS.getPreferredName(), this.dailyModelSnapshotRetentionAfterDays);
        }
        if (this.resultsRetentionDays != null) {
            builder.field(Job.RESULTS_RETENTION_DAYS.getPreferredName(), this.resultsRetentionDays);
        }
        if (this.categorizationFilters != null) {
            builder.field(AnalysisConfig.CATEGORIZATION_FILTERS.getPreferredName(), this.categorizationFilters);
        }
        if (this.perPartitionCategorizationConfig != null) {
            builder.field(AnalysisConfig.PER_PARTITION_CATEGORIZATION.getPreferredName(), this.perPartitionCategorizationConfig);
        }
        if (this.customSettings != null) {
            builder.field(Job.CUSTOM_SETTINGS.getPreferredName(), this.customSettings);
        }
        if (this.modelSnapshotId != null) {
            builder.field(Job.MODEL_SNAPSHOT_ID.getPreferredName(), this.modelSnapshotId);
        }
        if (this.modelSnapshotMinVersion != null) {
            builder.field(Job.MODEL_SNAPSHOT_MIN_VERSION.getPreferredName(), this.modelSnapshotMinVersion);
        }
        if (this.jobVersion != null) {
            builder.field(Job.JOB_VERSION.getPreferredName(), this.jobVersion);
        }
        if (this.clearJobFinishTime != null) {
            builder.field(CLEAR_JOB_FINISH_TIME.getPreferredName(), this.clearJobFinishTime);
        }
        if (this.allowLazyOpen != null) {
            builder.field(Job.ALLOW_LAZY_OPEN.getPreferredName(), this.allowLazyOpen);
        }
        if (this.blocked != null) {
            builder.field(Job.BLOCKED.getPreferredName(), this.blocked);
        }
        if (this.modelPruneWindow != null) {
            builder.field(AnalysisConfig.MODEL_PRUNE_WINDOW.getPreferredName(), this.modelPruneWindow);
        }
        builder.endObject();
        return builder;
    }

    public Set<String> getUpdateFields() {
        TreeSet<String> updateFields = new TreeSet<String>();
        if (this.groups != null) {
            updateFields.add(Job.GROUPS.getPreferredName());
        }
        if (this.description != null) {
            updateFields.add(Job.DESCRIPTION.getPreferredName());
        }
        if (this.detectorUpdates != null) {
            updateFields.add(DETECTORS.getPreferredName());
        }
        if (this.modelPlotConfig != null) {
            updateFields.add(Job.MODEL_PLOT_CONFIG.getPreferredName());
        }
        if (this.analysisLimits != null) {
            updateFields.add(Job.ANALYSIS_LIMITS.getPreferredName());
        }
        if (this.renormalizationWindowDays != null) {
            updateFields.add(Job.RENORMALIZATION_WINDOW_DAYS.getPreferredName());
        }
        if (this.backgroundPersistInterval != null) {
            updateFields.add(Job.BACKGROUND_PERSIST_INTERVAL.getPreferredName());
        }
        if (this.modelSnapshotRetentionDays != null) {
            updateFields.add(Job.MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName());
        }
        if (this.dailyModelSnapshotRetentionAfterDays != null) {
            updateFields.add(Job.DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS.getPreferredName());
        }
        if (this.resultsRetentionDays != null) {
            updateFields.add(Job.RESULTS_RETENTION_DAYS.getPreferredName());
        }
        if (this.categorizationFilters != null) {
            updateFields.add(AnalysisConfig.CATEGORIZATION_FILTERS.getPreferredName());
        }
        if (this.perPartitionCategorizationConfig != null) {
            updateFields.add(AnalysisConfig.PER_PARTITION_CATEGORIZATION.getPreferredName());
        }
        if (this.customSettings != null) {
            updateFields.add(Job.CUSTOM_SETTINGS.getPreferredName());
        }
        if (this.modelSnapshotId != null) {
            updateFields.add(Job.MODEL_SNAPSHOT_ID.getPreferredName());
        }
        if (this.modelSnapshotMinVersion != null) {
            updateFields.add(Job.MODEL_SNAPSHOT_MIN_VERSION.getPreferredName());
        }
        if (this.jobVersion != null) {
            updateFields.add(Job.JOB_VERSION.getPreferredName());
        }
        if (this.allowLazyOpen != null) {
            updateFields.add(Job.ALLOW_LAZY_OPEN.getPreferredName());
        }
        if (this.modelPruneWindow != null) {
            updateFields.add(AnalysisConfig.MODEL_PRUNE_WINDOW.getPreferredName());
        }
        return updateFields;
    }

    public Job mergeWithJob(Job source, ByteSizeValue maxModelMemoryLimit) {
        Job.Builder builder = new Job.Builder(source);
        AnalysisConfig currentAnalysisConfig = source.getAnalysisConfig();
        AnalysisConfig.Builder newAnalysisConfig = new AnalysisConfig.Builder(currentAnalysisConfig);
        if (this.groups != null) {
            builder.setGroups(this.groups);
        }
        if (this.description != null) {
            builder.setDescription(this.description);
        }
        if (this.detectorUpdates != null && !this.detectorUpdates.isEmpty()) {
            int numDetectors = currentAnalysisConfig.getDetectors().size();
            for (DetectorUpdate dd : this.detectorUpdates) {
                if (dd.getDetectorIndex() >= numDetectors) {
                    throw ExceptionsHelper.badRequestException("Supplied detector_index [{}] is >= the number of detectors [{}]", dd.getDetectorIndex(), numDetectors);
                }
                Detector.Builder detectorBuilder = new Detector.Builder(currentAnalysisConfig.getDetectors().get(dd.getDetectorIndex()));
                if (dd.getDescription() != null) {
                    detectorBuilder.setDetectorDescription(dd.getDescription());
                }
                if (dd.getRules() != null) {
                    detectorBuilder.setRules(dd.getRules());
                }
                newAnalysisConfig.setDetector(dd.getDetectorIndex(), detectorBuilder.build());
            }
        }
        if (this.modelPlotConfig != null) {
            builder.setModelPlotConfig(this.modelPlotConfig);
        }
        if (this.analysisLimits != null) {
            AnalysisLimits validatedLimits = AnalysisLimits.validateAndSetDefaults(this.analysisLimits, maxModelMemoryLimit, 1024L);
            builder.setAnalysisLimits(validatedLimits);
        }
        if (this.renormalizationWindowDays != null) {
            builder.setRenormalizationWindowDays(this.renormalizationWindowDays);
        }
        if (this.backgroundPersistInterval != null) {
            builder.setBackgroundPersistInterval(this.backgroundPersistInterval);
        }
        if (this.modelSnapshotRetentionDays != null) {
            builder.setModelSnapshotRetentionDays(this.modelSnapshotRetentionDays);
        }
        if (this.dailyModelSnapshotRetentionAfterDays != null) {
            builder.setDailyModelSnapshotRetentionAfterDays(this.dailyModelSnapshotRetentionAfterDays);
        }
        if (this.resultsRetentionDays != null) {
            builder.setResultsRetentionDays(this.resultsRetentionDays);
        }
        if (this.categorizationFilters != null) {
            newAnalysisConfig.setCategorizationFilters(this.categorizationFilters);
        }
        if (this.perPartitionCategorizationConfig != null) {
            if (this.perPartitionCategorizationConfig.isEnabled() != currentAnalysisConfig.getPerPartitionCategorizationConfig().isEnabled()) {
                throw ExceptionsHelper.badRequestException("analysis_config.per_partition_categorization.enabled cannot be updated", new Object[0]);
            }
            newAnalysisConfig.setPerPartitionCategorizationConfig(this.perPartitionCategorizationConfig);
        }
        if (this.customSettings != null) {
            builder.setCustomSettings(this.customSettings);
        }
        if (this.modelSnapshotId != null) {
            builder.setModelSnapshotId(ModelSnapshot.isTheEmptySnapshot(this.modelSnapshotId) ? null : this.modelSnapshotId);
        }
        if (this.modelSnapshotMinVersion != null) {
            builder.setModelSnapshotMinVersion(this.modelSnapshotMinVersion);
        }
        if (this.jobVersion != null) {
            builder.setJobVersion(this.jobVersion);
        }
        if (this.clearJobFinishTime != null && this.clearJobFinishTime.booleanValue()) {
            builder.setFinishedTime(null);
        }
        if (this.allowLazyOpen != null) {
            builder.setAllowLazyOpen(this.allowLazyOpen);
        }
        if (this.blocked != null) {
            builder.setBlocked(this.blocked);
        }
        if (this.modelPruneWindow != null) {
            newAnalysisConfig.setModelPruneWindow(this.modelPruneWindow);
        }
        builder.setAnalysisConfig(newAnalysisConfig);
        return builder.build();
    }

    boolean isNoop(Job job) {
        return !(this.groups != null && !Objects.equals(this.groups, job.getGroups()) || this.description != null && !Objects.equals(this.description, job.getDescription()) || this.modelPlotConfig != null && !Objects.equals(this.modelPlotConfig, job.getModelPlotConfig()) || this.analysisLimits != null && !Objects.equals(this.analysisLimits, job.getAnalysisLimits()) || this.updatesDetectors(job) || this.renormalizationWindowDays != null && !Objects.equals(this.renormalizationWindowDays, job.getRenormalizationWindowDays()) || this.backgroundPersistInterval != null && !Objects.equals(this.backgroundPersistInterval, job.getBackgroundPersistInterval()) || this.modelSnapshotRetentionDays != null && !Objects.equals(this.modelSnapshotRetentionDays, job.getModelSnapshotRetentionDays()) || this.dailyModelSnapshotRetentionAfterDays != null && !Objects.equals(this.dailyModelSnapshotRetentionAfterDays, job.getDailyModelSnapshotRetentionAfterDays()) || this.resultsRetentionDays != null && !Objects.equals(this.resultsRetentionDays, job.getResultsRetentionDays()) || this.categorizationFilters != null && !Objects.equals(this.categorizationFilters, job.getAnalysisConfig().getCategorizationFilters()) || this.perPartitionCategorizationConfig != null && !Objects.equals(this.perPartitionCategorizationConfig, job.getAnalysisConfig().getPerPartitionCategorizationConfig()) || this.customSettings != null && !Objects.equals(this.customSettings, job.getCustomSettings()) || this.modelSnapshotId != null && !Objects.equals(this.modelSnapshotId, job.getModelSnapshotId()) || this.modelSnapshotMinVersion != null && !Objects.equals(this.modelSnapshotMinVersion, job.getModelSnapshotMinVersion()) || this.jobVersion != null && !Objects.equals(this.jobVersion, job.getJobVersion()) || this.clearJobFinishTime != null && this.clearJobFinishTime != false && job.getFinishedTime() != null || this.allowLazyOpen != null && !Objects.equals(this.allowLazyOpen, job.allowLazyOpen()) || this.blocked != null && !Objects.equals(this.blocked, job.getBlocked()) || this.modelPruneWindow != null && !Objects.equals(this.modelPruneWindow, job.getAnalysisConfig().getModelPruneWindow()));
    }

    boolean updatesDetectors(Job job) {
        AnalysisConfig analysisConfig = job.getAnalysisConfig();
        if (this.detectorUpdates == null) {
            return false;
        }
        for (DetectorUpdate detectorUpdate : this.detectorUpdates) {
            if (detectorUpdate.description == null && detectorUpdate.rules == null) continue;
            Detector detector = analysisConfig.getDetectors().get(detectorUpdate.detectorIndex);
            if (Objects.equals(detectorUpdate.description, detector.getDetectorDescription()) && Objects.equals(detectorUpdate.rules, detector.getRules())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JobUpdate)) {
            return false;
        }
        JobUpdate that = (JobUpdate)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.groups, that.groups) && Objects.equals(this.description, that.description) && Objects.equals(this.detectorUpdates, that.detectorUpdates) && Objects.equals(this.modelPlotConfig, that.modelPlotConfig) && Objects.equals(this.analysisLimits, that.analysisLimits) && Objects.equals(this.renormalizationWindowDays, that.renormalizationWindowDays) && Objects.equals(this.backgroundPersistInterval, that.backgroundPersistInterval) && Objects.equals(this.modelSnapshotRetentionDays, that.modelSnapshotRetentionDays) && Objects.equals(this.dailyModelSnapshotRetentionAfterDays, that.dailyModelSnapshotRetentionAfterDays) && Objects.equals(this.resultsRetentionDays, that.resultsRetentionDays) && Objects.equals(this.categorizationFilters, that.categorizationFilters) && Objects.equals(this.perPartitionCategorizationConfig, that.perPartitionCategorizationConfig) && Objects.equals(this.customSettings, that.customSettings) && Objects.equals(this.modelSnapshotId, that.modelSnapshotId) && Objects.equals(this.modelSnapshotMinVersion, that.modelSnapshotMinVersion) && Objects.equals(this.jobVersion, that.jobVersion) && Objects.equals(this.clearJobFinishTime, that.clearJobFinishTime) && Objects.equals(this.allowLazyOpen, that.allowLazyOpen) && Objects.equals(this.blocked, that.blocked) && Objects.equals(this.modelPruneWindow, that.modelPruneWindow);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.groups, this.description, this.detectorUpdates, this.modelPlotConfig, this.analysisLimits, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.dailyModelSnapshotRetentionAfterDays, this.resultsRetentionDays, this.categorizationFilters, this.perPartitionCategorizationConfig, this.customSettings, this.modelSnapshotId, this.modelSnapshotMinVersion, this.jobVersion, this.clearJobFinishTime, this.allowLazyOpen, this.blocked, this.modelPruneWindow);
    }

    static {
        for (ConstructingObjectParser parser : Arrays.asList(INTERNAL_PARSER, EXTERNAL_PARSER)) {
            parser.declareString(ConstructingObjectParser.optionalConstructorArg(), Job.ID);
            parser.declareStringArray(Builder::setGroups, Job.GROUPS);
            parser.declareStringOrNull(Builder::setDescription, Job.DESCRIPTION);
            parser.declareObjectArray(Builder::setDetectorUpdates, DetectorUpdate.PARSER, DETECTORS);
            parser.declareObject(Builder::setModelPlotConfig, ModelPlotConfig.STRICT_PARSER, Job.MODEL_PLOT_CONFIG);
            parser.declareObject(Builder::setAnalysisLimits, AnalysisLimits.STRICT_PARSER, Job.ANALYSIS_LIMITS);
            parser.declareString((builder, val) -> builder.setBackgroundPersistInterval(TimeValue.parseTimeValue(val, Job.BACKGROUND_PERSIST_INTERVAL.getPreferredName())), Job.BACKGROUND_PERSIST_INTERVAL);
            parser.declareLong(Builder::setRenormalizationWindowDays, Job.RENORMALIZATION_WINDOW_DAYS);
            parser.declareLong(Builder::setResultsRetentionDays, Job.RESULTS_RETENTION_DAYS);
            parser.declareLong(Builder::setModelSnapshotRetentionDays, Job.MODEL_SNAPSHOT_RETENTION_DAYS);
            parser.declareLong(Builder::setDailyModelSnapshotRetentionAfterDays, Job.DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS);
            parser.declareStringArray(Builder::setCategorizationFilters, AnalysisConfig.CATEGORIZATION_FILTERS);
            parser.declareObject(Builder::setPerPartitionCategorizationConfig, PerPartitionCategorizationConfig.STRICT_PARSER, AnalysisConfig.PER_PARTITION_CATEGORIZATION);
            parser.declareField(Builder::setCustomSettings, (p, c) -> p.map(), Job.CUSTOM_SETTINGS, ObjectParser.ValueType.OBJECT);
            parser.declareBoolean(Builder::setAllowLazyOpen, Job.ALLOW_LAZY_OPEN);
            parser.declareString((builder, val) -> builder.setModelPruneWindow(TimeValue.parseTimeValue(val, AnalysisConfig.MODEL_PRUNE_WINDOW.getPreferredName())), AnalysisConfig.MODEL_PRUNE_WINDOW);
        }
        INTERNAL_PARSER.declareString(Builder::setModelSnapshotId, Job.MODEL_SNAPSHOT_ID);
        INTERNAL_PARSER.declareString(Builder::setModelSnapshotMinVersion, Job.MODEL_SNAPSHOT_MIN_VERSION);
        INTERNAL_PARSER.declareString(Builder::setJobVersion, Job.JOB_VERSION);
        INTERNAL_PARSER.declareBoolean(Builder::setClearFinishTime, CLEAR_JOB_FINISH_TIME);
        INTERNAL_PARSER.declareObject(Builder::setBlocked, Blocked.STRICT_PARSER, Job.BLOCKED);
    }

    public static class DetectorUpdate
    implements Writeable,
    ToXContentObject {
        public static final ConstructingObjectParser<DetectorUpdate, Void> PARSER = new ConstructingObjectParser("detector_update", a -> new DetectorUpdate((Integer)a[0], (String)a[1], (List)a[2]));
        private final int detectorIndex;
        private final String description;
        private final List<DetectionRule> rules;

        public DetectorUpdate(int detectorIndex, String description, List<DetectionRule> rules) {
            this.detectorIndex = detectorIndex;
            this.description = description;
            this.rules = rules;
        }

        public DetectorUpdate(StreamInput in) throws IOException {
            this.detectorIndex = in.readInt();
            this.description = in.readOptionalString();
            this.rules = in.readBoolean() ? in.readList(DetectionRule::new) : null;
        }

        public int getDetectorIndex() {
            return this.detectorIndex;
        }

        public String getDescription() {
            return this.description;
        }

        public List<DetectionRule> getRules() {
            return this.rules;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.detectorIndex);
            out.writeOptionalString(this.description);
            out.writeBoolean(this.rules != null);
            if (this.rules != null) {
                out.writeList(this.rules);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Detector.DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
            if (this.description != null) {
                builder.field(Job.DESCRIPTION.getPreferredName(), this.description);
            }
            if (this.rules != null) {
                builder.field(Detector.CUSTOM_RULES_FIELD.getPreferredName(), this.rules);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.detectorIndex, this.description, this.rules);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DetectorUpdate)) {
                return false;
            }
            DetectorUpdate that = (DetectorUpdate)other;
            return this.detectorIndex == that.detectorIndex && Objects.equals(this.description, that.description) && Objects.equals(this.rules, that.rules);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), Detector.DETECTOR_INDEX);
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), Job.DESCRIPTION);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (parser, parseFieldMatcher) -> DetectionRule.STRICT_PARSER.apply(parser, (Void)parseFieldMatcher).build(), Detector.CUSTOM_RULES_FIELD);
        }
    }

    public static class Builder {
        private String jobId;
        private List<String> groups;
        private String description;
        private List<DetectorUpdate> detectorUpdates;
        private ModelPlotConfig modelPlotConfig;
        private AnalysisLimits analysisLimits;
        private Long renormalizationWindowDays;
        private TimeValue backgroundPersistInterval;
        private Long modelSnapshotRetentionDays;
        private Long dailyModelSnapshotRetentionAfterDays;
        private Long resultsRetentionDays;
        private List<String> categorizationFilters;
        private PerPartitionCategorizationConfig perPartitionCategorizationConfig;
        private Map<String, Object> customSettings;
        private String modelSnapshotId;
        private Version modelSnapshotMinVersion;
        private Version jobVersion;
        private Boolean clearJobFinishTime;
        private Boolean allowLazyOpen;
        private Blocked blocked;
        private TimeValue modelPruneWindow;

        public Builder(String jobId) {
            this.jobId = jobId;
        }

        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setGroups(List<String> groups) {
            this.groups = groups;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDetectorUpdates(List<DetectorUpdate> detectorUpdates) {
            this.detectorUpdates = detectorUpdates;
            return this;
        }

        public Builder setModelPlotConfig(ModelPlotConfig modelPlotConfig) {
            this.modelPlotConfig = modelPlotConfig;
            return this;
        }

        public Builder setAnalysisLimits(AnalysisLimits analysisLimits) {
            this.analysisLimits = analysisLimits;
            return this;
        }

        public Builder setRenormalizationWindowDays(Long renormalizationWindowDays) {
            this.renormalizationWindowDays = renormalizationWindowDays;
            return this;
        }

        public Builder setBackgroundPersistInterval(TimeValue backgroundPersistInterval) {
            this.backgroundPersistInterval = backgroundPersistInterval;
            return this;
        }

        public Builder setModelSnapshotRetentionDays(Long modelSnapshotRetentionDays) {
            this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
            return this;
        }

        public Builder setDailyModelSnapshotRetentionAfterDays(Long dailyModelSnapshotRetentionAfterDays) {
            this.dailyModelSnapshotRetentionAfterDays = dailyModelSnapshotRetentionAfterDays;
            return this;
        }

        public Builder setResultsRetentionDays(Long resultsRetentionDays) {
            this.resultsRetentionDays = resultsRetentionDays;
            return this;
        }

        public Builder setCategorizationFilters(List<String> categorizationFilters) {
            this.categorizationFilters = categorizationFilters;
            return this;
        }

        public Builder setPerPartitionCategorizationConfig(PerPartitionCategorizationConfig perPartitionCategorizationConfig) {
            this.perPartitionCategorizationConfig = perPartitionCategorizationConfig;
            return this;
        }

        public Builder setCustomSettings(Map<String, Object> customSettings) {
            this.customSettings = customSettings;
            return this;
        }

        public Builder setModelSnapshotId(String modelSnapshotId) {
            this.modelSnapshotId = modelSnapshotId;
            return this;
        }

        public Builder setModelSnapshotMinVersion(Version modelSnapshotMinVersion) {
            this.modelSnapshotMinVersion = modelSnapshotMinVersion;
            return this;
        }

        public Builder setModelSnapshotMinVersion(String modelSnapshotMinVersion) {
            this.modelSnapshotMinVersion = Version.fromString(modelSnapshotMinVersion);
            return this;
        }

        public Builder setJobVersion(Version version) {
            this.jobVersion = version;
            return this;
        }

        public Builder setJobVersion(String version) {
            this.jobVersion = Version.fromString(version);
            return this;
        }

        public Builder setAllowLazyOpen(boolean allowLazyOpen) {
            this.allowLazyOpen = allowLazyOpen;
            return this;
        }

        public Builder setClearFinishTime(boolean clearFinishTime) {
            this.clearJobFinishTime = clearFinishTime;
            return this;
        }

        public Builder setBlocked(Blocked blocked) {
            this.blocked = blocked;
            return this;
        }

        public Builder setModelPruneWindow(TimeValue modelPruneWindow) {
            this.modelPruneWindow = modelPruneWindow;
            return this;
        }

        public JobUpdate build() {
            return new JobUpdate(this.jobId, this.groups, this.description, this.detectorUpdates, this.modelPlotConfig, this.analysisLimits, this.backgroundPersistInterval, this.renormalizationWindowDays, this.resultsRetentionDays, this.modelSnapshotRetentionDays, this.dailyModelSnapshotRetentionAfterDays, this.categorizationFilters, this.perPartitionCategorizationConfig, this.customSettings, this.modelSnapshotId, this.modelSnapshotMinVersion, this.jobVersion, this.clearJobFinishTime, this.allowLazyOpen, this.blocked, this.modelPruneWindow);
        }
    }
}

