/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed.extractor;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public final class ExtractorUtils {
    private static final String EPOCH_MILLIS = "epoch_millis";

    private ExtractorUtils() {
    }

    public static QueryBuilder wrapInTimeRangeQuery(QueryBuilder userQuery, String timeField, long start, long end) {
        RangeQueryBuilder timeQuery = new RangeQueryBuilder(timeField).gte(start).lt(end).format(EPOCH_MILLIS);
        return new BoolQueryBuilder().filter(userQuery).filter(timeQuery);
    }

    public static long getHistogramIntervalMillis(AggregatorFactories.Builder aggFactory) {
        AggregationBuilder histogram = ExtractorUtils.getHistogramAggregation(aggFactory.getAggregatorFactories());
        return ExtractorUtils.getHistogramIntervalMillis(histogram);
    }

    public static AggregationBuilder getHistogramAggregation(Collection<AggregationBuilder> aggregations) {
        if (aggregations.isEmpty()) {
            throw ExceptionsHelper.badRequestException(Messages.getMessage("A date_histogram (or histogram) aggregation is required"), new Object[0]);
        }
        if (aggregations.size() != 1) {
            throw ExceptionsHelper.badRequestException("The date_histogram (or histogram) aggregation cannot have sibling aggregations", new Object[0]);
        }
        AggregationBuilder agg = aggregations.iterator().next();
        if (ExtractorUtils.isHistogram(agg)) {
            return agg;
        }
        return ExtractorUtils.getHistogramAggregation(agg.getSubAggregations());
    }

    public static boolean isHistogram(AggregationBuilder aggregationBuilder) {
        return aggregationBuilder instanceof HistogramAggregationBuilder || aggregationBuilder instanceof DateHistogramAggregationBuilder || ExtractorUtils.isCompositeWithDateHistogramSource(aggregationBuilder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCompositeWithDateHistogramSource(AggregationBuilder aggregationBuilder) {
        if (!(aggregationBuilder instanceof CompositeAggregationBuilder)) return false;
        if (!((CompositeAggregationBuilder)aggregationBuilder).sources().stream().anyMatch(DateHistogramValuesSourceBuilder.class::isInstance)) return false;
        return true;
    }

    public static DateHistogramValuesSourceBuilder getDateHistogramValuesSource(CompositeAggregationBuilder compositeAggregationBuilder) {
        for (CompositeValuesSourceBuilder<?> valuesSourceBuilder : compositeAggregationBuilder.sources()) {
            if (!(valuesSourceBuilder instanceof DateHistogramValuesSourceBuilder)) continue;
            return (DateHistogramValuesSourceBuilder)valuesSourceBuilder;
        }
        throw ExceptionsHelper.badRequestException("[composite] aggregations require exactly one [date_histogram] value source", new Object[0]);
    }

    public static long getHistogramIntervalMillis(AggregationBuilder histogramAggregation) {
        if (histogramAggregation instanceof HistogramAggregationBuilder) {
            return (long)((HistogramAggregationBuilder)histogramAggregation).interval();
        }
        if (histogramAggregation instanceof DateHistogramAggregationBuilder) {
            return ExtractorUtils.validateAndGetDateHistogramInterval(DateHistogramAggOrValueSource.fromAgg((DateHistogramAggregationBuilder)histogramAggregation));
        }
        if (histogramAggregation instanceof CompositeAggregationBuilder) {
            return ExtractorUtils.validateAndGetDateHistogramInterval(DateHistogramAggOrValueSource.fromCompositeAgg((CompositeAggregationBuilder)histogramAggregation));
        }
        throw new IllegalStateException("Invalid histogram aggregation [" + histogramAggregation.getName() + "]");
    }

    private static long validateAndGetDateHistogramInterval(DateHistogramAggOrValueSource dateHistogram) {
        if (dateHistogram.timeZone() != null && !dateHistogram.timeZone().normalized().equals(ZoneOffset.UTC)) {
            throw ExceptionsHelper.badRequestException("ML requires date_histogram.time_zone to be UTC", new Object[0]);
        }
        if (dateHistogram.getCalendarInterval() != null) {
            return ExtractorUtils.validateAndGetCalendarInterval(dateHistogram.getCalendarInterval().toString());
        }
        if (dateHistogram.getFixedInterval() != null) {
            return dateHistogram.getFixedInterval().estimateMillis();
        }
        if (dateHistogram.dateHistogramInterval() != null) {
            return ExtractorUtils.validateAndGetCalendarInterval(dateHistogram.dateHistogramInterval().toString());
        }
        if (dateHistogram.interval() != 0L) {
            return dateHistogram.interval();
        }
        throw new IllegalArgumentException("Must specify an interval for date_histogram");
    }

    public static long validateAndGetCalendarInterval(String calendarInterval) {
        TimeValue interval;
        block10: {
            block9: {
                Rounding.DateTimeUnit dateTimeUnit = DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(calendarInterval);
                if (dateTimeUnit == null) break block9;
                switch (dateTimeUnit) {
                    case WEEK_OF_WEEKYEAR: {
                        interval = new TimeValue(7L, TimeUnit.DAYS);
                        break block10;
                    }
                    case DAY_OF_MONTH: {
                        interval = new TimeValue(1L, TimeUnit.DAYS);
                        break block10;
                    }
                    case HOUR_OF_DAY: {
                        interval = new TimeValue(1L, TimeUnit.HOURS);
                        break block10;
                    }
                    case MINUTES_OF_HOUR: {
                        interval = new TimeValue(1L, TimeUnit.MINUTES);
                        break block10;
                    }
                    case SECOND_OF_MINUTE: {
                        interval = new TimeValue(1L, TimeUnit.SECONDS);
                        break block10;
                    }
                    case MONTH_OF_YEAR: 
                    case YEAR_OF_CENTURY: 
                    case QUARTER_OF_YEAR: {
                        throw ExceptionsHelper.badRequestException(ExtractorUtils.invalidDateHistogramCalendarIntervalMessage(calendarInterval), new Object[0]);
                    }
                    default: {
                        throw ExceptionsHelper.badRequestException("Unexpected dateTimeUnit [" + (Object)((Object)dateTimeUnit) + "]", new Object[0]);
                    }
                }
            }
            interval = TimeValue.parseTimeValue(calendarInterval, "date_histogram.calendar_interval");
        }
        if (interval.days() > 7L) {
            throw ExceptionsHelper.badRequestException(ExtractorUtils.invalidDateHistogramCalendarIntervalMessage(calendarInterval), new Object[0]);
        }
        return interval.millis();
    }

    private static String invalidDateHistogramCalendarIntervalMessage(String interval) {
        throw ExceptionsHelper.badRequestException("When specifying a date_histogram calendar interval [" + interval + "], ML does not accept intervals longer than a week because of variable lengths of periods greater than a week", new Object[0]);
    }

    private static class DateHistogramAggOrValueSource {
        private final DateHistogramAggregationBuilder agg;
        private final DateHistogramValuesSourceBuilder sourceBuilder;

        static DateHistogramAggOrValueSource fromAgg(DateHistogramAggregationBuilder agg) {
            return new DateHistogramAggOrValueSource(agg, null);
        }

        static DateHistogramAggOrValueSource fromCompositeAgg(CompositeAggregationBuilder compositeAggregationBuilder) {
            return new DateHistogramAggOrValueSource(null, ExtractorUtils.getDateHistogramValuesSource(compositeAggregationBuilder));
        }

        private DateHistogramAggOrValueSource(DateHistogramAggregationBuilder agg, DateHistogramValuesSourceBuilder sourceBuilder) {
            assert (agg != null || sourceBuilder != null);
            this.agg = agg;
            this.sourceBuilder = sourceBuilder;
        }

        private ZoneId timeZone() {
            return this.agg != null ? this.agg.timeZone() : this.sourceBuilder.timeZone();
        }

        private DateHistogramInterval getFixedInterval() {
            return this.agg != null ? this.agg.getFixedInterval() : this.sourceBuilder.getIntervalAsFixed();
        }

        private DateHistogramInterval getCalendarInterval() {
            return this.agg != null ? this.agg.getCalendarInterval() : this.sourceBuilder.getIntervalAsCalendar();
        }

        @Deprecated
        private DateHistogramInterval dateHistogramInterval() {
            return this.agg != null ? this.agg.dateHistogramInterval() : this.sourceBuilder.dateHistogramInterval();
        }

        @Deprecated
        private long interval() {
            return this.agg != null ? this.agg.interval() : this.sourceBuilder.interval();
        }
    }
}

