/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedJobValidator;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.groups.GroupOrJobLookup;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NameResolver;

public class MlMetadata
implements XPackPlugin.XPackMetadataCustom {
    public static final String TYPE = "ml";
    private static final ParseField JOBS_FIELD = new ParseField("jobs", new String[0]);
    private static final ParseField DATAFEEDS_FIELD = new ParseField("datafeeds", new String[0]);
    public static final ParseField UPGRADE_MODE = new ParseField("upgrade_mode", new String[0]);
    public static final ParseField RESET_MODE = new ParseField("reset_mode", new String[0]);
    public static final MlMetadata EMPTY_METADATA = new MlMetadata(Collections.emptySortedMap(), Collections.emptySortedMap(), false, false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = new ObjectParser("ml_metadata", true, Builder::new);
    private final SortedMap<String, Job> jobs;
    private final SortedMap<String, DatafeedConfig> datafeeds;
    private final boolean upgradeMode;
    private final boolean resetMode;
    private final GroupOrJobLookup groupOrJobLookup;

    private MlMetadata(SortedMap<String, Job> jobs, SortedMap<String, DatafeedConfig> datafeeds, boolean upgradeMode, boolean resetMode) {
        this.jobs = Collections.unmodifiableSortedMap(jobs);
        this.datafeeds = Collections.unmodifiableSortedMap(datafeeds);
        this.groupOrJobLookup = new GroupOrJobLookup(jobs.values());
        this.upgradeMode = upgradeMode;
        this.resetMode = resetMode;
    }

    public Map<String, Job> getJobs() {
        return this.jobs;
    }

    public Set<String> expandJobIds(String expression, boolean allowNoMatch) {
        return this.groupOrJobLookup.expandJobIds(expression, allowNoMatch);
    }

    public SortedMap<String, DatafeedConfig> getDatafeeds() {
        return this.datafeeds;
    }

    public DatafeedConfig getDatafeed(String datafeedId) {
        return (DatafeedConfig)this.datafeeds.get(datafeedId);
    }

    public Optional<DatafeedConfig> getDatafeedByJobId(String jobId) {
        return this.datafeeds.values().stream().filter(s -> s.getJobId().equals(jobId)).findFirst();
    }

    public Map<String, DatafeedConfig> getDatafeedsByJobIds(Set<String> jobIds) {
        return this.datafeeds.values().stream().filter(df -> jobIds.contains(df.getJobId())).collect(Collectors.toMap(DatafeedConfig::getJobId, Function.identity()));
    }

    public Set<String> expandDatafeedIds(String expression, boolean allowNoMatch) {
        return NameResolver.newUnaliased(this.datafeeds.keySet(), ExceptionsHelper::missingDatafeedException).expand(expression, allowNoMatch);
    }

    public boolean isUpgradeMode() {
        return this.upgradeMode;
    }

    public boolean isResetMode() {
        return this.resetMode;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_6_0_0_alpha1;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new MlMetadataDiff((MlMetadata)previousState, this);
    }

    public MlMetadata(StreamInput in) throws IOException {
        int size = in.readVInt();
        TreeMap<String, Job> jobs = new TreeMap<String, Job>();
        for (int i = 0; i < size; ++i) {
            jobs.put(in.readString(), new Job(in));
        }
        this.jobs = jobs;
        size = in.readVInt();
        TreeMap<String, DatafeedConfig> datafeeds = new TreeMap<String, DatafeedConfig>();
        for (int i = 0; i < size; ++i) {
            datafeeds.put(in.readString(), new DatafeedConfig(in));
        }
        this.datafeeds = datafeeds;
        this.groupOrJobLookup = new GroupOrJobLookup(jobs.values());
        this.upgradeMode = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readBoolean() : false;
        this.resetMode = in.getVersion().onOrAfter(Version.V_7_13_0) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        MlMetadata.writeMap(this.jobs, out);
        MlMetadata.writeMap(this.datafeeds, out);
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeBoolean(this.upgradeMode);
        }
        if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
            out.writeBoolean(this.resetMode);
        }
    }

    private static <T extends Writeable> void writeMap(Map<String, T> map, StreamOutput out) throws IOException {
        out.writeVInt(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            out.writeString(entry.getKey());
            ((Writeable)entry.getValue()).writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ToXContent.DelegatingMapParams extendedParams = new ToXContent.DelegatingMapParams(Collections.singletonMap("for_internal_storage", "true"), params);
        MlMetadata.mapValuesToXContent(JOBS_FIELD, this.jobs, builder, extendedParams);
        MlMetadata.mapValuesToXContent(DATAFEEDS_FIELD, this.datafeeds, builder, extendedParams);
        builder.field(UPGRADE_MODE.getPreferredName(), this.upgradeMode);
        builder.field(RESET_MODE.getPreferredName(), this.resetMode);
        return builder;
    }

    private static <T extends ToXContent> void mapValuesToXContent(ParseField field, Map<String, T> map, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (map.isEmpty()) {
            return;
        }
        builder.startArray(field.getPreferredName());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            ((ToXContent)entry.getValue()).toXContent(builder, params);
        }
        builder.endArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MlMetadata that = (MlMetadata)o;
        return Objects.equals(this.jobs, that.jobs) && Objects.equals(this.datafeeds, that.datafeeds) && this.upgradeMode == that.upgradeMode && this.resetMode == that.resetMode;
    }

    public final String toString() {
        return Strings.toString(this);
    }

    public int hashCode() {
        return Objects.hash(this.jobs, this.datafeeds, this.upgradeMode, this.resetMode);
    }

    public static MlMetadata getMlMetadata(ClusterState state) {
        MlMetadata mlMetadata;
        MlMetadata mlMetadata2 = mlMetadata = state == null ? null : (MlMetadata)state.getMetadata().custom(TYPE);
        if (mlMetadata == null) {
            return EMPTY_METADATA;
        }
        return mlMetadata;
    }

    static {
        LENIENT_PARSER.declareObjectArray(Builder::putJobs, (p, c) -> Job.LENIENT_PARSER.apply(p, (Void)c).build(), JOBS_FIELD);
        LENIENT_PARSER.declareObjectArray(Builder::putDatafeeds, (p, c) -> DatafeedConfig.LENIENT_PARSER.apply(p, (Void)c).build(), DATAFEEDS_FIELD);
        LENIENT_PARSER.declareBoolean(Builder::isUpgradeMode, UPGRADE_MODE);
        LENIENT_PARSER.declareBoolean(Builder::isResetMode, RESET_MODE);
    }

    public static class MlMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, Job>> jobs;
        final Diff<Map<String, DatafeedConfig>> datafeeds;
        final boolean upgradeMode;
        final boolean resetMode;

        MlMetadataDiff(MlMetadata before, MlMetadata after) {
            this.jobs = DiffableUtils.diff(before.jobs, after.jobs, DiffableUtils.getStringKeySerializer());
            this.datafeeds = DiffableUtils.diff(before.datafeeds, after.datafeeds, DiffableUtils.getStringKeySerializer());
            this.upgradeMode = after.upgradeMode;
            this.resetMode = after.resetMode;
        }

        public MlMetadataDiff(StreamInput in) throws IOException {
            this.jobs = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), Job::new, MlMetadataDiff::readJobDiffFrom);
            this.datafeeds = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), DatafeedConfig::new, MlMetadataDiff::readDatafeedDiffFrom);
            this.upgradeMode = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readBoolean() : false;
            this.resetMode = in.getVersion().onOrAfter(Version.V_7_13_0) ? in.readBoolean() : false;
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            TreeMap<String, Job> newJobs = new TreeMap<String, Job>(this.jobs.apply(((MlMetadata)part).jobs));
            TreeMap<String, DatafeedConfig> newDatafeeds = new TreeMap<String, DatafeedConfig>(this.datafeeds.apply(((MlMetadata)part).datafeeds));
            return new MlMetadata(newJobs, newDatafeeds, this.upgradeMode, this.resetMode);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.jobs.writeTo(out);
            this.datafeeds.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
                out.writeBoolean(this.upgradeMode);
            }
            if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
                out.writeBoolean(this.resetMode);
            }
        }

        @Override
        public String getWriteableName() {
            return MlMetadata.TYPE;
        }

        static Diff<Job> readJobDiffFrom(StreamInput in) throws IOException {
            return AbstractDiffable.readDiffFrom(Job::new, in);
        }

        static Diff<DatafeedConfig> readDatafeedDiffFrom(StreamInput in) throws IOException {
            return AbstractDiffable.readDiffFrom(DatafeedConfig::new, in);
        }
    }

    public static class Builder {
        private TreeMap<String, Job> jobs;
        private TreeMap<String, DatafeedConfig> datafeeds;
        private boolean upgradeMode;
        private boolean resetMode;

        public static Builder from(@Nullable MlMetadata previous) {
            return new Builder(previous);
        }

        public Builder() {
            this.jobs = new TreeMap();
            this.datafeeds = new TreeMap();
        }

        public Builder(@Nullable MlMetadata previous) {
            if (previous == null) {
                this.jobs = new TreeMap();
                this.datafeeds = new TreeMap();
            } else {
                this.jobs = new TreeMap(previous.jobs);
                this.datafeeds = new TreeMap(previous.datafeeds);
                this.upgradeMode = previous.upgradeMode;
                this.resetMode = previous.resetMode;
            }
        }

        public Builder putJob(Job job, boolean overwrite) {
            if (this.jobs.containsKey(job.getId()) && !overwrite) {
                throw ExceptionsHelper.jobAlreadyExists(job.getId());
            }
            this.jobs.put(job.getId(), job);
            return this;
        }

        public Builder putJobs(Collection<Job> jobs) {
            for (Job job : jobs) {
                this.putJob(job, true);
            }
            return this;
        }

        public Builder putDatafeed(DatafeedConfig datafeedConfig, Map<String, String> headers, NamedXContentRegistry xContentRegistry) {
            if (this.datafeeds.containsKey(datafeedConfig.getId())) {
                throw ExceptionsHelper.datafeedAlreadyExists(datafeedConfig.getId());
            }
            String jobId = datafeedConfig.getJobId();
            this.checkJobIsAvailableForDatafeed(jobId);
            Job job = this.jobs.get(jobId);
            DatafeedJobValidator.validate(datafeedConfig, job, xContentRegistry);
            if (!headers.isEmpty()) {
                datafeedConfig = new DatafeedConfig.Builder(datafeedConfig).setHeaders(ClientHelper.filterSecurityHeaders(headers)).build();
            }
            this.datafeeds.put(datafeedConfig.getId(), datafeedConfig);
            return this;
        }

        private void checkJobIsAvailableForDatafeed(String jobId) {
            Job job = this.jobs.get(jobId);
            if (job == null || job.isDeleting()) {
                throw ExceptionsHelper.missingJobException(jobId);
            }
            Optional<DatafeedConfig> existingDatafeed = this.getDatafeedByJobId(jobId);
            if (existingDatafeed.isPresent()) {
                throw ExceptionsHelper.conflictStatusException("A datafeed [" + existingDatafeed.get().getId() + "] already exists for job [" + jobId + "]", new Object[0]);
            }
        }

        private Optional<DatafeedConfig> getDatafeedByJobId(String jobId) {
            return this.datafeeds.values().stream().filter(s -> s.getJobId().equals(jobId)).findFirst();
        }

        public Builder putDatafeeds(Collection<DatafeedConfig> datafeeds) {
            for (DatafeedConfig datafeed : datafeeds) {
                this.datafeeds.put(datafeed.getId(), datafeed);
            }
            return this;
        }

        public Builder isUpgradeMode(boolean isUpgradeMode) {
            this.upgradeMode = isUpgradeMode;
            return this;
        }

        public Builder isResetMode(boolean isResetMode) {
            this.resetMode = isResetMode;
            return this;
        }

        public MlMetadata build() {
            return new MlMetadata(this.jobs, this.datafeeds, this.upgradeMode, this.resetMode);
        }
    }
}

