/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.CcrConstants;

public class CCRFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    private final ClusterService clusterService;

    @Inject
    public CCRFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState, ClusterService clusterService) {
        this.enabled = XPackSettings.CCR_ENABLED_SETTING.get(settings);
        this.licenseState = licenseState;
        this.clusterService = clusterService;
    }

    @Override
    public String name() {
        return "ccr";
    }

    @Override
    public boolean available() {
        return this.licenseState != null && CcrConstants.CCR_FEATURE.checkWithoutTracking(this.licenseState);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    @Override
    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        Metadata metadata = this.clusterService.state().metadata();
        int numberOfFollowerIndices = 0;
        long lastFollowerIndexCreationDate = 0L;
        for (IndexMetadata imd : metadata) {
            if (imd.getCustomData("ccr") == null) continue;
            ++numberOfFollowerIndices;
            if (lastFollowerIndexCreationDate >= imd.getCreationDate()) continue;
            lastFollowerIndexCreationDate = imd.getCreationDate();
        }
        AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)metadata.custom("ccr_auto_follow");
        int numberOfAutoFollowPatterns = autoFollowMetadata != null ? autoFollowMetadata.getPatterns().size() : 0;
        Long lastFollowTimeInMillis = numberOfFollowerIndices == 0 ? null : Long.valueOf(Math.max(0L, Instant.now().toEpochMilli() - lastFollowerIndexCreationDate));
        Usage usage = new Usage(this.available(), this.enabled(), numberOfFollowerIndices, numberOfAutoFollowPatterns, lastFollowTimeInMillis);
        listener.onResponse(usage);
    }

    public static class Usage
    extends XPackFeatureSet.Usage {
        private final int numberOfFollowerIndices;
        private final int numberOfAutoFollowPatterns;
        private final Long lastFollowTimeInMillis;

        public Usage(boolean available, boolean enabled, int numberOfFollowerIndices, int numberOfAutoFollowPatterns, Long lastFollowTimeInMillis) {
            super("ccr", available, enabled);
            this.numberOfFollowerIndices = numberOfFollowerIndices;
            this.numberOfAutoFollowPatterns = numberOfAutoFollowPatterns;
            this.lastFollowTimeInMillis = lastFollowTimeInMillis;
        }

        public Usage(StreamInput in) throws IOException {
            super(in);
            this.numberOfFollowerIndices = in.readVInt();
            this.numberOfAutoFollowPatterns = in.readVInt();
            this.lastFollowTimeInMillis = in.readBoolean() ? Long.valueOf(in.readVLong()) : null;
        }

        @Override
        public Version getMinimalSupportedVersion() {
            return Version.V_6_7_0;
        }

        public int getNumberOfFollowerIndices() {
            return this.numberOfFollowerIndices;
        }

        public int getNumberOfAutoFollowPatterns() {
            return this.numberOfAutoFollowPatterns;
        }

        public Long getLastFollowTimeInMillis() {
            return this.lastFollowTimeInMillis;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.numberOfFollowerIndices);
            out.writeVInt(this.numberOfAutoFollowPatterns);
            if (this.lastFollowTimeInMillis != null) {
                out.writeBoolean(true);
                out.writeVLong(this.lastFollowTimeInMillis);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.innerXContent(builder, params);
            builder.field("follower_indices_count", this.numberOfFollowerIndices);
            builder.field("auto_follow_patterns_count", this.numberOfAutoFollowPatterns);
            if (this.lastFollowTimeInMillis != null) {
                builder.field("last_follow_time_in_millis", this.lastFollowTimeInMillis);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Usage usage = (Usage)o;
            return this.numberOfFollowerIndices == usage.numberOfFollowerIndices && this.numberOfAutoFollowPatterns == usage.numberOfAutoFollowPatterns && Objects.equals(this.lastFollowTimeInMillis, usage.lastFollowTimeInMillis);
        }

        public int hashCode() {
            return Objects.hash(this.numberOfFollowerIndices, this.numberOfAutoFollowPatterns, this.lastFollowTimeInMillis);
        }
    }
}

