/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.analytics;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.analytics.action.AnalyticsStatsAction;

public class AnalyticsFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final AnalyticsStatsAction.Response response;

    public AnalyticsFeatureSetUsage(AnalyticsStatsAction.Response response) {
        super("analytics", true, true);
        this.response = response;
    }

    public AnalyticsFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.response = new AnalyticsStatsAction.Response(input);
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_7_4_0;
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.response);
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (this.response != null) {
            this.response.toXContent(builder, params);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.response.writeTo(out);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyticsFeatureSetUsage other = (AnalyticsFeatureSetUsage)obj;
        return Objects.equals(this.available, other.available) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.response, other.response);
    }
}

