/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class DataStreamsStatsAction
extends ActionType<Response> {
    public static final DataStreamsStatsAction INSTANCE = new DataStreamsStatsAction();
    public static final String NAME = "indices:monitor/data_stream/stats";

    public DataStreamsStatsAction() {
        super(NAME, Response::new);
    }

    public static class DataStreamShardStats
    implements Writeable {
        private final ShardRouting shardRouting;
        private final StoreStats storeStats;
        private final long maxTimestamp;

        public DataStreamShardStats(ShardRouting shardRouting, StoreStats storeStats, long maxTimestamp) {
            this.shardRouting = shardRouting;
            this.storeStats = storeStats;
            this.maxTimestamp = maxTimestamp;
        }

        public DataStreamShardStats(StreamInput in) throws IOException {
            this.shardRouting = new ShardRouting(in);
            this.storeStats = new StoreStats(in);
            this.maxTimestamp = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.shardRouting.writeTo(out);
            this.storeStats.writeTo(out);
            out.writeVLong(this.maxTimestamp);
        }

        public ShardRouting getShardRouting() {
            return this.shardRouting;
        }

        public StoreStats getStoreStats() {
            return this.storeStats;
        }

        public long getMaxTimestamp() {
            return this.maxTimestamp;
        }
    }

    public static class DataStreamStats
    implements ToXContentObject,
    Writeable {
        private final String dataStream;
        private final int backingIndices;
        private final ByteSizeValue storeSize;
        private final long maximumTimestamp;

        public DataStreamStats(String dataStream, int backingIndices, ByteSizeValue storeSize, long maximumTimestamp) {
            this.dataStream = dataStream;
            this.backingIndices = backingIndices;
            this.storeSize = storeSize;
            this.maximumTimestamp = maximumTimestamp;
        }

        public DataStreamStats(StreamInput in) throws IOException {
            this.dataStream = in.readString();
            this.backingIndices = in.readVInt();
            this.storeSize = new ByteSizeValue(in);
            this.maximumTimestamp = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.dataStream);
            out.writeVInt(this.backingIndices);
            this.storeSize.writeTo(out);
            out.writeVLong(this.maximumTimestamp);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("data_stream", this.dataStream);
            builder.field("backing_indices", this.backingIndices);
            builder.humanReadableField("store_size_bytes", "store_size", this.storeSize);
            builder.field("maximum_timestamp", this.maximumTimestamp);
            builder.endObject();
            return builder;
        }

        public String getDataStream() {
            return this.dataStream;
        }

        public int getBackingIndices() {
            return this.backingIndices;
        }

        public ByteSizeValue getStoreSize() {
            return this.storeSize;
        }

        public long getMaximumTimestamp() {
            return this.maximumTimestamp;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DataStreamStats that = (DataStreamStats)obj;
            return this.backingIndices == that.backingIndices && this.maximumTimestamp == that.maximumTimestamp && Objects.equals(this.dataStream, that.dataStream) && Objects.equals(this.storeSize, that.storeSize);
        }

        public int hashCode() {
            return Objects.hash(this.dataStream, this.backingIndices, this.storeSize, this.maximumTimestamp);
        }

        public String toString() {
            return "DataStreamStats{dataStream='" + this.dataStream + '\'' + ", backingIndices=" + this.backingIndices + ", storeSize=" + this.storeSize + ", maximumTimestamp=" + this.maximumTimestamp + '}';
        }
    }

    public static class Response
    extends BroadcastResponse {
        private final int dataStreamCount;
        private final int backingIndices;
        private final ByteSizeValue totalStoreSize;
        private final DataStreamStats[] dataStreams;

        public Response(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, int dataStreamCount, int backingIndices, ByteSizeValue totalStoreSize, DataStreamStats[] dataStreams) {
            super(totalShards, successfulShards, failedShards, shardFailures);
            this.dataStreamCount = dataStreamCount;
            this.backingIndices = backingIndices;
            this.totalStoreSize = totalStoreSize;
            this.dataStreams = dataStreams;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.dataStreamCount = in.readVInt();
            this.backingIndices = in.readVInt();
            this.totalStoreSize = new ByteSizeValue(in);
            this.dataStreams = in.readArray(DataStreamStats::new, DataStreamStats[]::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.dataStreamCount);
            out.writeVInt(this.backingIndices);
            this.totalStoreSize.writeTo(out);
            out.writeArray(this.dataStreams);
        }

        @Override
        protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("data_stream_count", this.dataStreamCount);
            builder.field("backing_indices", this.backingIndices);
            builder.humanReadableField("total_store_size_bytes", "total_store_size", this.totalStoreSize);
            builder.xContentList("data_streams", this.dataStreams);
        }

        public int getDataStreamCount() {
            return this.dataStreamCount;
        }

        public int getBackingIndices() {
            return this.backingIndices;
        }

        public ByteSizeValue getTotalStoreSize() {
            return this.totalStoreSize;
        }

        public DataStreamStats[] getDataStreams() {
            return this.dataStreams;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Response response = (Response)obj;
            return this.dataStreamCount == response.dataStreamCount && this.backingIndices == response.backingIndices && Objects.equals(this.totalStoreSize, response.totalStoreSize) && Arrays.equals(this.dataStreams, response.dataStreams);
        }

        public int hashCode() {
            int result = Objects.hash(this.dataStreamCount, this.backingIndices, this.totalStoreSize);
            result = 31 * result + Arrays.hashCode(this.dataStreams);
            return result;
        }

        public String toString() {
            return "Response{dataStreamCount=" + this.dataStreamCount + ", backingIndices=" + this.backingIndices + ", totalStoreSize=" + this.totalStoreSize + ", dataStreams=" + Arrays.toString(this.dataStreams) + '}';
        }
    }

    public static class Request
    extends BroadcastRequest<Request> {
        public Request() {
            super(null, IndicesOptions.fromOptions(false, true, true, true, true, false, true, false));
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }
    }
}

