/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.metrics.WeightedAvgAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.WeightedAvgAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.MultiValuesSource;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

class WeightedAvgAggregatorFactory
extends MultiValuesSourceAggregatorFactory {
    WeightedAvgAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, DocValueFormat format, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, configs, format, context, parent, subFactoriesBuilder, metadata);
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new WeightedAvgAggregator(this.name, null, this.format, this.context, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(Map<String, ValuesSourceConfig> configs, DocValueFormat format, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        MultiValuesSource.NumericMultiValuesSource numericMultiVS = new MultiValuesSource.NumericMultiValuesSource(configs);
        if (numericMultiVS.areValuesSourcesEmpty()) {
            return this.createUnmapped(parent, metadata);
        }
        return new WeightedAvgAggregator(this.name, numericMultiVS, format, this.context, parent, metadata);
    }

    @Override
    public String getStatsSubtype() {
        return ((ValuesSourceConfig)this.configs.get(WeightedAvgAggregationBuilder.VALUE_FIELD.getPreferredName())).valueSourceType().typeName();
    }
}

