/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractInternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class InternalTerms<A extends InternalTerms<A, B>, B extends Bucket<B>>
extends AbstractInternalTerms<A, B>
implements Terms {
    public static final ParseField DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME = new ParseField("doc_count_error_upper_bound", new String[0]);
    public static final ParseField SUM_OF_OTHER_DOC_COUNTS = new ParseField("sum_other_doc_count", new String[0]);
    protected final BucketOrder reduceOrder;
    protected final BucketOrder order;
    protected final int requiredSize;
    protected final long minDocCount;

    protected InternalTerms(String name, BucketOrder reduceOrder, BucketOrder order, int requiredSize, long minDocCount, Map<String, Object> metadata) {
        super(name, metadata);
        this.reduceOrder = reduceOrder;
        this.order = order;
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
    }

    protected InternalTerms(StreamInput in) throws IOException {
        super(in);
        this.reduceOrder = InternalOrder.Streams.readOrder(in);
        this.order = in.getVersion().onOrAfter(Version.V_7_10_0) ? InternalOrder.Streams.readOrder(in) : this.reduceOrder;
        this.requiredSize = InternalTerms.readSize(in);
        this.minDocCount = in.readVLong();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            this.reduceOrder.writeTo(out);
        }
        this.order.writeTo(out);
        InternalTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        this.writeTermTypeInfoTo(out);
    }

    protected abstract void writeTermTypeInfoTo(StreamOutput var1) throws IOException;

    @Override
    public abstract List<B> getBuckets();

    public abstract B getBucketByKey(String var1);

    @Override
    protected BucketOrder getReduceOrder() {
        return this.reduceOrder;
    }

    @Override
    protected BucketOrder getOrder() {
        return this.order;
    }

    @Override
    protected long getMinDocCount() {
        return this.minDocCount;
    }

    @Override
    protected int getRequiredSize() {
        return this.requiredSize;
    }

    @Override
    protected abstract void setDocCountError(long var1);

    @Override
    protected abstract int getShardSize();

    @Override
    protected abstract A create(String var1, List<B> var2, BucketOrder var3, long var4, long var6);

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalTerms that = (InternalTerms)obj;
        return Objects.equals(this.minDocCount, that.minDocCount) && Objects.equals(this.reduceOrder, that.reduceOrder) && Objects.equals(this.order, that.order) && Objects.equals(this.requiredSize, that.requiredSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minDocCount, this.reduceOrder, this.order, this.requiredSize);
    }

    public static abstract class Bucket<B extends Bucket<B>>
    extends AbstractInternalTerms.AbstractTermsBucket
    implements Terms.Bucket,
    KeyComparable<B> {
        long bucketOrd;
        protected long docCount;
        protected long docCountError;
        protected InternalAggregations aggregations;
        protected final boolean showDocCountError;
        protected final DocValueFormat format;

        protected Bucket(long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat formatter) {
            this.showDocCountError = showDocCountError;
            this.format = formatter;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.docCountError = docCountError;
        }

        protected Bucket(StreamInput in, DocValueFormat formatter, boolean showDocCountError) throws IOException {
            this.showDocCountError = showDocCountError;
            this.format = formatter;
            this.docCount = in.readVLong();
            this.docCountError = -1L;
            if (showDocCountError) {
                this.docCountError = in.readLong();
            }
            this.aggregations = InternalAggregations.readFrom(in);
        }

        @Override
        public final void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.getDocCount());
            if (this.showDocCountError) {
                out.writeLong(this.docCountError);
            }
            this.aggregations.writeTo(out);
            this.writeTermTo(out);
        }

        protected abstract void writeTermTo(StreamOutput var1) throws IOException;

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public long getDocCountError() {
            if (!this.showDocCountError) {
                throw new IllegalStateException("show_terms_doc_count_error is false");
            }
            return this.docCountError;
        }

        @Override
        protected void setDocCountError(long docCountError) {
            this.docCountError = docCountError;
        }

        @Override
        protected void updateDocCountError(long docCountErrorDiff) {
            this.docCountError += docCountErrorDiff;
        }

        @Override
        protected boolean getShowDocCountError() {
            return this.showDocCountError;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.keyToXContent(builder);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            if (this.showDocCountError) {
                builder.field(DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), this.getDocCountError());
            }
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        protected abstract XContentBuilder keyToXContent(XContentBuilder var1) throws IOException;

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Bucket that = (Bucket)obj;
            if (this.showDocCountError && this.docCountError != that.docCountError) {
                return false;
            }
            return Objects.equals(this.docCount, that.docCount) && Objects.equals(this.showDocCountError, that.showDocCountError) && Objects.equals(this.format, that.format) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.docCount, this.format, this.showDocCountError, this.showDocCountError ? this.docCountError : -1L, this.aggregations);
        }

        @FunctionalInterface
        public static interface Reader<B extends Bucket<B>> {
            public B read(StreamInput var1, DocValueFormat var2, boolean var3) throws IOException;
        }
    }
}

