/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.adjacency;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class AdjacencyMatrixAggregatorFactory
extends AggregatorFactory {
    private final String[] keys;
    private final Weight[] weights;
    private final String separator;

    public AdjacencyMatrixAggregatorFactory(String name, List<AdjacencyMatrixAggregator.KeyedFilter> filters, String separator, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactories, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactories, metadata);
        IndexSearcher contextSearcher = context.searcher();
        this.separator = separator;
        this.weights = new Weight[filters.size()];
        this.keys = new String[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            AdjacencyMatrixAggregator.KeyedFilter keyedFilter = filters.get(i);
            this.keys[i] = keyedFilter.key();
            Query filter = context.buildQuery(keyedFilter.filter());
            this.weights[i] = contextSearcher.createWeight(contextSearcher.rewrite(filter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
    }

    @Override
    public Aggregator createInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return new AdjacencyMatrixAggregator(this.name, this.factories, this.separator, this.keys, this.weights, this.context, parent, metadata);
    }
}

