/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.OneMergeHelper;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.shard.ShardId;

class ElasticsearchConcurrentMergeScheduler
extends ConcurrentMergeScheduler {
    protected final Logger logger;
    private final Settings indexSettings;
    private final ShardId shardId;
    private final MeanMetric totalMerges = new MeanMetric();
    private final CounterMetric totalMergesNumDocs = new CounterMetric();
    private final CounterMetric totalMergesSizeInBytes = new CounterMetric();
    private final CounterMetric currentMerges = new CounterMetric();
    private final CounterMetric currentMergesNumDocs = new CounterMetric();
    private final CounterMetric currentMergesSizeInBytes = new CounterMetric();
    private final CounterMetric totalMergeStoppedTime = new CounterMetric();
    private final CounterMetric totalMergeThrottledTime = new CounterMetric();
    private final Set<OnGoingMerge> onGoingMerges = ConcurrentCollections.newConcurrentSet();
    private final Set<OnGoingMerge> readOnlyOnGoingMerges = Collections.unmodifiableSet(this.onGoingMerges);
    private final MergeSchedulerConfig config;

    ElasticsearchConcurrentMergeScheduler(ShardId shardId, IndexSettings indexSettings) {
        this.config = indexSettings.getMergeSchedulerConfig();
        this.shardId = shardId;
        this.indexSettings = indexSettings.getSettings();
        this.logger = Loggers.getLogger(this.getClass(), shardId, new String[0]);
        this.refreshConfig();
    }

    public Set<OnGoingMerge> onGoingMerges() {
        return this.readOnlyOnGoingMerges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doMerge(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) throws IOException {
        int totalNumDocs = merge.totalNumDocs();
        long totalSizeInBytes = merge.totalBytesSize();
        long timeNS = System.nanoTime();
        this.currentMerges.inc();
        this.currentMergesNumDocs.inc(totalNumDocs);
        this.currentMergesSizeInBytes.inc(totalSizeInBytes);
        OnGoingMerge onGoingMerge = new OnGoingMerge(merge);
        this.onGoingMerges.add(onGoingMerge);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("merge [{}] starting..., merging [{}] segments, [{}] docs, [{}] size, into [{}] estimated_size", (Object)OneMergeHelper.getSegmentName(merge), (Object)merge.segments.size(), (Object)totalNumDocs, (Object)new ByteSizeValue(totalSizeInBytes), (Object)new ByteSizeValue(merge.estimatedMergeBytes));
        }
        try {
            this.beforeMerge(onGoingMerge);
            super.doMerge(mergeSource, merge);
        }
        catch (Throwable throwable) {
            long tookMS = TimeValue.nsecToMSec(System.nanoTime() - timeNS);
            this.onGoingMerges.remove(onGoingMerge);
            this.afterMerge(onGoingMerge);
            this.currentMerges.dec();
            this.currentMergesNumDocs.dec(totalNumDocs);
            this.currentMergesSizeInBytes.dec(totalSizeInBytes);
            this.totalMergesNumDocs.inc(totalNumDocs);
            this.totalMergesSizeInBytes.inc(totalSizeInBytes);
            this.totalMerges.inc(tookMS);
            long stoppedMS = TimeValue.nsecToMSec(merge.getMergeProgress().getPauseTimes().get((Object)MergePolicy.OneMergeProgress.PauseReason.STOPPED));
            long throttledMS = TimeValue.nsecToMSec(merge.getMergeProgress().getPauseTimes().get((Object)MergePolicy.OneMergeProgress.PauseReason.PAUSED));
            Thread thread = Thread.currentThread();
            long totalBytesWritten = OneMergeHelper.getTotalBytesWritten(thread, merge);
            double mbPerSec = OneMergeHelper.getMbPerSec(thread, merge);
            this.totalMergeStoppedTime.inc(stoppedMS);
            this.totalMergeThrottledTime.inc(throttledMS);
            String message = String.format(Locale.ROOT, "merge segment [%s] done: took [%s], [%,.1f MB], [%,d docs], [%s stopped], [%s throttled], [%,.1f MB written], [%,.1f MB/sec throttle]", OneMergeHelper.getSegmentName(merge), TimeValue.timeValueMillis(tookMS), Float.valueOf((float)totalSizeInBytes / 1024.0f / 1024.0f), totalNumDocs, TimeValue.timeValueMillis(stoppedMS), TimeValue.timeValueMillis(throttledMS), Float.valueOf((float)totalBytesWritten / 1024.0f / 1024.0f), mbPerSec);
            if (tookMS > 20000L) {
                this.logger.debug("{}", (Object)message);
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("{}", (Object)message);
            }
            throw throwable;
        }
        long tookMS = TimeValue.nsecToMSec(System.nanoTime() - timeNS);
        this.onGoingMerges.remove(onGoingMerge);
        this.afterMerge(onGoingMerge);
        this.currentMerges.dec();
        this.currentMergesNumDocs.dec(totalNumDocs);
        this.currentMergesSizeInBytes.dec(totalSizeInBytes);
        this.totalMergesNumDocs.inc(totalNumDocs);
        this.totalMergesSizeInBytes.inc(totalSizeInBytes);
        this.totalMerges.inc(tookMS);
        long stoppedMS = TimeValue.nsecToMSec(merge.getMergeProgress().getPauseTimes().get((Object)MergePolicy.OneMergeProgress.PauseReason.STOPPED));
        long throttledMS = TimeValue.nsecToMSec(merge.getMergeProgress().getPauseTimes().get((Object)MergePolicy.OneMergeProgress.PauseReason.PAUSED));
        Thread thread = Thread.currentThread();
        long totalBytesWritten = OneMergeHelper.getTotalBytesWritten(thread, merge);
        double mbPerSec = OneMergeHelper.getMbPerSec(thread, merge);
        this.totalMergeStoppedTime.inc(stoppedMS);
        this.totalMergeThrottledTime.inc(throttledMS);
        String message = String.format(Locale.ROOT, "merge segment [%s] done: took [%s], [%,.1f MB], [%,d docs], [%s stopped], [%s throttled], [%,.1f MB written], [%,.1f MB/sec throttle]", OneMergeHelper.getSegmentName(merge), TimeValue.timeValueMillis(tookMS), Float.valueOf((float)totalSizeInBytes / 1024.0f / 1024.0f), totalNumDocs, TimeValue.timeValueMillis(stoppedMS), TimeValue.timeValueMillis(throttledMS), Float.valueOf((float)totalBytesWritten / 1024.0f / 1024.0f), mbPerSec);
        if (tookMS > 20000L) {
            this.logger.debug("{}", (Object)message);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("{}", (Object)message);
        }
    }

    protected void beforeMerge(OnGoingMerge merge) {
    }

    protected void afterMerge(OnGoingMerge merge) {
    }

    public MergeScheduler clone() {
        return this;
    }

    @Override
    protected boolean maybeStall(MergeScheduler.MergeSource mergeSource) {
        return true;
    }

    @Override
    protected ConcurrentMergeScheduler.MergeThread getMergeThread(MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge merge) throws IOException {
        ConcurrentMergeScheduler.MergeThread thread = super.getMergeThread(mergeSource, merge);
        thread.setName(EsExecutors.threadName(this.indexSettings, "[" + this.shardId.getIndexName() + "][" + this.shardId.id() + "]: " + thread.getName()));
        return thread;
    }

    MergeStats stats() {
        MergeStats mergeStats = new MergeStats();
        mergeStats.add(this.totalMerges.count(), this.totalMerges.sum(), this.totalMergesNumDocs.count(), this.totalMergesSizeInBytes.count(), this.currentMerges.count(), this.currentMergesNumDocs.count(), this.currentMergesSizeInBytes.count(), this.totalMergeStoppedTime.count(), this.totalMergeThrottledTime.count(), this.config.isAutoThrottle() ? this.getIORateLimitMBPerSec() : Double.POSITIVE_INFINITY);
        return mergeStats;
    }

    void refreshConfig() {
        boolean isEnabled;
        if (this.getMaxMergeCount() != this.config.getMaxMergeCount() || this.getMaxThreadCount() != this.config.getMaxThreadCount()) {
            this.setMaxMergesAndThreads(this.config.getMaxMergeCount(), this.config.getMaxThreadCount());
        }
        boolean bl = isEnabled = this.getIORateLimitMBPerSec() != Double.POSITIVE_INFINITY;
        if (this.config.isAutoThrottle() && !isEnabled) {
            this.enableAutoIOThrottle();
        } else if (!this.config.isAutoThrottle() && isEnabled) {
            this.disableAutoIOThrottle();
        }
    }
}

