/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.Lucene;

public class FilteredCollector
implements Collector {
    private final Collector collector;
    private final Weight filter;

    public FilteredCollector(Collector collector, Weight filter) {
        this.collector = collector;
        this.filter = filter;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        ScorerSupplier filterScorerSupplier = this.filter.scorerSupplier(context);
        LeafCollector in = this.collector.getLeafCollector(context);
        final Bits bits = Lucene.asSequentialAccessBits(context.reader().maxDoc(), filterScorerSupplier);
        return new FilterLeafCollector(in){

            @Override
            public void collect(int doc) throws IOException {
                if (bits.get(doc)) {
                    this.in.collect(doc);
                }
            }
        };
    }

    @Override
    public ScoreMode scoreMode() {
        return this.collector.scoreMode();
    }
}

