/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class ClusterApplierRecordingService {
    private final Map<String, MeanMetric> recordedActions = new HashMap<String, MeanMetric>();

    synchronized Stats getStats() {
        return new Stats(this.recordedActions.entrySet().stream().sorted(Comparator.comparingLong(o -> ((MeanMetric)o.getValue()).sum()).reversed()).collect(Maps.toUnmodifiableOrderedMap(Map.Entry::getKey, v -> new Stats.Recording(((MeanMetric)v.getValue()).count(), ((MeanMetric)v.getValue()).sum()))));
    }

    synchronized void updateStats(Recorder recorder) {
        HashSet<String> seenActions = new HashSet<String>();
        for (Tuple entry2 : recorder.recordings) {
            String action = (String)entry2.v1();
            long timeSpentMS = (Long)entry2.v2();
            MeanMetric metric = this.recordedActions.computeIfAbsent(action, key -> new MeanMetric());
            metric.inc(timeSpentMS);
            seenActions.add(action);
        }
        this.recordedActions.entrySet().removeIf(entry -> !seenActions.contains(entry.getKey()));
    }

    public static class Stats
    implements Writeable,
    ToXContentFragment {
        private final Map<String, Recording> recordings;

        public Stats(Map<String, Recording> recordings) {
            this.recordings = recordings;
        }

        public Map<String, Recording> getRecordings() {
            return this.recordings;
        }

        public Stats(StreamInput in) throws IOException {
            this(in.readOrderedMap(StreamInput::readString, Recording::new));
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("cluster_applier_stats");
            builder.startArray("recordings");
            for (Map.Entry<String, Recording> entry : this.recordings.entrySet()) {
                builder.startObject();
                builder.field("name", entry.getKey());
                String name = "cumulative_execution";
                builder.field(name + "_count", entry.getValue().count);
                builder.humanReadableField(name + "_time_millis", name + "_time", TimeValue.timeValueMillis(entry.getValue().sum));
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.recordings, StreamOutput::writeString, (out1, value) -> value.writeTo(out1));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats stats = (Stats)o;
            return Objects.equals(this.recordings, stats.recordings);
        }

        public int hashCode() {
            return Objects.hash(this.recordings);
        }

        public static class Recording
        implements Writeable {
            private final long count;
            private final long sum;

            public Recording(long count, long sum) {
                this.count = count;
                this.sum = sum;
            }

            public Recording(StreamInput in) throws IOException {
                this(in.readVLong(), in.readVLong());
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeVLong(this.count);
                out.writeVLong(this.sum);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Recording recording = (Recording)o;
                return this.count == recording.count && this.sum == recording.sum;
            }

            public int hashCode() {
                return Objects.hash(this.count, this.sum);
            }

            public String toString() {
                return "Recording{count=" + this.count + ", sum=" + this.sum + '}';
            }
        }
    }

    static final class Recorder {
        private String currentAction;
        private long startTimeMS;
        private boolean recording;
        private final List<Tuple<String, Long>> recordings = new LinkedList<Tuple<String, Long>>();
        private final LongSupplier currentTimeSupplier;

        Recorder(LongSupplier currentTimeSupplier) {
            this.currentTimeSupplier = currentTimeSupplier;
        }

        Releasable record(String action) {
            if (this.recording) {
                throw new IllegalStateException("already recording");
            }
            this.recording = true;
            this.currentAction = action;
            this.startTimeMS = this.currentTimeSupplier.getAsLong();
            return this::stop;
        }

        void stop() {
            this.recording = false;
            long timeSpentMS = this.currentTimeSupplier.getAsLong() - this.startTimeMS;
            this.recordings.add(new Tuple<String, Long>(this.currentAction, timeSpentMS));
        }

        List<Tuple<String, Long>> getRecordings() {
            return this.recordings;
        }
    }
}

