/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.MaxAgeCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxPrimaryShardSizeCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxSizeCondition;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RolloverRequest
extends AcknowledgedRequest<RolloverRequest>
implements IndicesRequest,
ToXContentObject {
    private static final ObjectParser<RolloverRequest, Boolean> PARSER = new ObjectParser("rollover");
    private static final ObjectParser<Map<String, Condition<?>>, Void> CONDITION_PARSER = new ObjectParser("conditions");
    private static final ParseField CONDITIONS = new ParseField("conditions", new String[0]);
    private static final ParseField MAX_AGE_CONDITION = new ParseField("max_age", new String[0]);
    private static final ParseField MAX_DOCS_CONDITION = new ParseField("max_docs", new String[0]);
    private static final ParseField MAX_SIZE_CONDITION = new ParseField("max_size", new String[0]);
    private static final ParseField MAX_PRIMARY_SHARD_SIZE_CONDITION = new ParseField("max_primary_shard_size", new String[0]);
    private String rolloverTarget;
    private String newIndexName;
    private boolean dryRun;
    private final Map<String, Condition<?>> conditions = new HashMap(2);
    private CreateIndexRequest createIndexRequest = new CreateIndexRequest("_na_");

    public RolloverRequest(StreamInput in) throws IOException {
        super(in);
        this.rolloverTarget = in.readString();
        this.newIndexName = in.readOptionalString();
        this.dryRun = in.readBoolean();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            Condition condition = in.readNamedWriteable(Condition.class);
            this.conditions.put(condition.name, condition);
        }
        this.createIndexRequest = new CreateIndexRequest(in);
    }

    RolloverRequest() {
    }

    public RolloverRequest(String rolloverTarget, String newIndexName) {
        this.rolloverTarget = rolloverTarget;
        this.newIndexName = newIndexName;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = this.createIndexRequest.validate();
        if (this.rolloverTarget == null) {
            validationException = ValidateActions.addValidationError("rollover target is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.rolloverTarget);
        out.writeOptionalString(this.newIndexName);
        out.writeBoolean(this.dryRun);
        out.writeCollection(this.conditions.values().stream().filter(c -> c.includedInVersion(out.getVersion())).collect(Collectors.toList()), StreamOutput::writeNamedWriteable);
        this.createIndexRequest.writeTo(out);
    }

    @Override
    public String[] indices() {
        return new String[]{this.rolloverTarget};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public void setRolloverTarget(String rolloverTarget) {
        this.rolloverTarget = rolloverTarget;
    }

    public void setNewIndexName(String newIndexName) {
        this.newIndexName = newIndexName;
    }

    public void dryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.createIndexRequest.waitForActiveShards(waitForActiveShards);
    }

    public void addMaxIndexAgeCondition(TimeValue age) {
        MaxAgeCondition maxAgeCondition = new MaxAgeCondition(age);
        if (this.conditions.containsKey(maxAgeCondition.name)) {
            throw new IllegalArgumentException(maxAgeCondition.name + " condition is already set");
        }
        this.conditions.put(maxAgeCondition.name, maxAgeCondition);
    }

    public void addMaxIndexDocsCondition(long numDocs) {
        MaxDocsCondition maxDocsCondition = new MaxDocsCondition(numDocs);
        if (this.conditions.containsKey(maxDocsCondition.name)) {
            throw new IllegalArgumentException(maxDocsCondition.name + " condition is already set");
        }
        this.conditions.put(maxDocsCondition.name, maxDocsCondition);
    }

    public void addMaxIndexSizeCondition(ByteSizeValue size) {
        MaxSizeCondition maxSizeCondition = new MaxSizeCondition(size);
        if (this.conditions.containsKey(maxSizeCondition.name)) {
            throw new IllegalArgumentException(maxSizeCondition + " condition is already set");
        }
        this.conditions.put(maxSizeCondition.name, maxSizeCondition);
    }

    public void addMaxPrimaryShardSizeCondition(ByteSizeValue size) {
        MaxPrimaryShardSizeCondition maxPrimaryShardSizeCondition = new MaxPrimaryShardSizeCondition(size);
        if (this.conditions.containsKey(maxPrimaryShardSizeCondition.name)) {
            throw new IllegalArgumentException(maxPrimaryShardSizeCondition + " condition is already set");
        }
        this.conditions.put(maxPrimaryShardSizeCondition.name, maxPrimaryShardSizeCondition);
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public Map<String, Condition<?>> getConditions() {
        return this.conditions;
    }

    public String getRolloverTarget() {
        return this.rolloverTarget;
    }

    public String getNewIndexName() {
        return this.newIndexName;
    }

    public CreateIndexRequest getCreateIndexRequest() {
        return this.createIndexRequest;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.createIndexRequest.innerToXContent(builder, params);
        builder.startObject(CONDITIONS.getPreferredName());
        for (Condition<?> condition : this.conditions.values()) {
            condition.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public void fromXContent(boolean isTypeIncluded, XContentParser parser) throws IOException {
        PARSER.parse(parser, this, isTypeIncluded);
    }

    static {
        CONDITION_PARSER.declareString((conditions, s) -> conditions.put("max_age", new MaxAgeCondition(TimeValue.parseTimeValue(s, "max_age"))), MAX_AGE_CONDITION);
        CONDITION_PARSER.declareLong((conditions, value) -> conditions.put("max_docs", new MaxDocsCondition((Long)value)), MAX_DOCS_CONDITION);
        CONDITION_PARSER.declareString((conditions, s) -> conditions.put("max_size", new MaxSizeCondition(ByteSizeValue.parseBytesSizeValue(s, "max_size"))), MAX_SIZE_CONDITION);
        CONDITION_PARSER.declareString((conditions, s) -> conditions.put("max_primary_shard_size", new MaxPrimaryShardSizeCondition(ByteSizeValue.parseBytesSizeValue(s, "max_primary_shard_size"))), MAX_PRIMARY_SHARD_SIZE_CONDITION);
        PARSER.declareField((parser, request, context) -> CONDITION_PARSER.parse(parser, request.conditions, null), CONDITIONS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.createIndexRequest.settings(parser.map()), CreateIndexRequest.SETTINGS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, includeTypeName) -> {
            if (includeTypeName.booleanValue()) {
                for (Map.Entry<String, Object> mappingsEntry : parser.map().entrySet()) {
                    Map value = (Map)mappingsEntry.getValue();
                    request.createIndexRequest.mapping(mappingsEntry.getKey(), value);
                }
            } else {
                Map<String, Object> mappings = parser.map();
                if (MapperService.isMappingSourceTyped("_doc", mappings)) {
                    throw new IllegalArgumentException("The mapping definition cannot be nested under a type [_doc] unless include_type_name is set to true.");
                }
                request.createIndexRequest.mapping("_doc", mappings);
            }
        }, CreateIndexRequest.MAPPINGS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.createIndexRequest.aliases(parser.map()), CreateIndexRequest.ALIASES, ObjectParser.ValueType.OBJECT);
    }
}

