/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.repositories.get.TransportGetRepositoriesAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.repositories.GetSnapshotInfoContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetSnapshotsAction
extends TransportMasterNodeAction<GetSnapshotsRequest, GetSnapshotsResponse> {
    private final RepositoriesService repositoriesService;
    private static final Comparator<SnapshotInfo> BY_START_TIME = Comparator.comparingLong(SnapshotInfo::startTime).thenComparing(SnapshotInfo::snapshotId);
    private static final Comparator<SnapshotInfo> BY_DURATION = Comparator.comparingLong(sni -> sni.endTime() - sni.startTime()).thenComparing(SnapshotInfo::snapshotId);
    private static final Comparator<SnapshotInfo> BY_INDICES_COUNT = Comparator.comparingInt(sni -> sni.indices().size()).thenComparing(SnapshotInfo::snapshotId);
    private static final Comparator<SnapshotInfo> BY_SHARDS_COUNT = Comparator.comparingInt(SnapshotInfo::totalShards).thenComparing(SnapshotInfo::snapshotId);
    private static final Comparator<SnapshotInfo> BY_FAILED_SHARDS_COUNT = Comparator.comparingInt(SnapshotInfo::failedShards).thenComparing(SnapshotInfo::snapshotId);
    private static final Comparator<SnapshotInfo> BY_NAME = Comparator.comparing(sni -> sni.snapshotId().getName());
    private static final Comparator<SnapshotInfo> BY_REPOSITORY = Comparator.comparing(SnapshotInfo::repository).thenComparing(SnapshotInfo::snapshotId);

    @Inject
    public TransportGetSnapshotsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RepositoriesService repositoriesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/snapshot/get", transportService, clusterService, threadPool, actionFilters, GetSnapshotsRequest::new, indexNameExpressionResolver, GetSnapshotsResponse::new, "same");
        this.repositoriesService = repositoriesService;
    }

    @Override
    protected ClusterBlockException checkBlock(GetSnapshotsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(GetSnapshotsRequest request, ClusterState state, ActionListener<GetSnapshotsResponse> listener) throws Exception {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    @Override
    protected void masterOperation(Task task, GetSnapshotsRequest request, ClusterState state, ActionListener<GetSnapshotsResponse> listener) {
        assert (task instanceof CancellableTask) : task + " not cancellable";
        this.getMultipleReposSnapshotInfo(!request.isSingleRepositoryRequest(), state.custom("snapshots", SnapshotsInProgress.EMPTY), TransportGetSnapshotsAction.maybeFilterRepositories(TransportGetRepositoriesAction.getRepositories(state, request.repositories()), request.sort(), request.order(), request.fromSortValue()), request.snapshots(), request.ignoreUnavailable(), request.verbose(), (CancellableTask)task, request.sort(), request.after(), request.offset(), request.size(), request.order(), SnapshotPredicates.fromRequest(request), listener);
    }

    private static List<RepositoryMetadata> maybeFilterRepositories(List<RepositoryMetadata> repositories, GetSnapshotsRequest.SortBy sortBy, SortOrder order, @Nullable String fromSortValue) {
        if (sortBy != GetSnapshotsRequest.SortBy.REPOSITORY || fromSortValue == null) {
            return repositories;
        }
        Predicate<RepositoryMetadata> predicate = order == SortOrder.ASC ? repositoryMetadata -> fromSortValue.compareTo(repositoryMetadata.name()) <= 0 : repositoryMetadata -> fromSortValue.compareTo(repositoryMetadata.name()) >= 0;
        return Collections.unmodifiableList(repositories.stream().filter(predicate).collect(Collectors.toList()));
    }

    private void getMultipleReposSnapshotInfo(boolean isMultiRepoRequest, SnapshotsInProgress snapshotsInProgress, List<RepositoryMetadata> repos, String[] snapshots, boolean ignoreUnavailable, boolean verbose, CancellableTask cancellableTask, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, int offset, int size, SortOrder order, SnapshotPredicates predicates, ActionListener<GetSnapshotsResponse> listener) {
        if (repos.isEmpty()) {
            listener.onResponse(new GetSnapshotsResponse(Collections.emptyList(), Collections.emptyMap(), null, 0, 0));
            return;
        }
        GroupedActionListener groupedActionListener = new GroupedActionListener(listener.map(responses -> {
            assert (repos.size() == responses.size());
            List<SnapshotInfo> allSnapshots = responses.stream().map(Tuple::v2).filter(Objects::nonNull).flatMap(snapshotsInRepo -> ((SnapshotsInRepo)snapshotsInRepo).snapshotInfos.stream()).collect(Collectors.toList());
            Map<String, ElasticsearchException> failures = responses.stream().map(Tuple::v1).filter(Objects::nonNull).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
            SnapshotsInRepo snInfos = TransportGetSnapshotsAction.sortSnapshots(allSnapshots, sortBy, after, offset, size, order);
            List snapshotInfos = snInfos.snapshotInfos;
            int remaining = snInfos.remaining + responses.stream().map(Tuple::v2).filter(Objects::nonNull).mapToInt(s -> ((SnapshotsInRepo)s).remaining).sum();
            return new GetSnapshotsResponse(snapshotInfos, failures, remaining > 0 ? GetSnapshotsRequest.After.from((SnapshotInfo)snapshotInfos.get(snapshotInfos.size() - 1), sortBy).asQueryParam() : null, responses.stream().map(Tuple::v2).filter(Objects::nonNull).mapToInt(s -> ((SnapshotsInRepo)s).totalCount).sum(), remaining);
        }), repos.size());
        for (RepositoryMetadata repo : repos) {
            String repoName = repo.name();
            this.getSingleRepoSnapshotInfo(snapshotsInProgress, repoName, snapshots, predicates, ignoreUnavailable, verbose, cancellableTask, sortBy, after, order, groupedActionListener.delegateResponse((groupedListener, e) -> {
                if (isMultiRepoRequest && e instanceof ElasticsearchException) {
                    groupedListener.onResponse(Tuple.tuple(Tuple.tuple(repoName, (ElasticsearchException)e), null));
                } else {
                    groupedListener.onFailure((Exception)e);
                }
            }).map(snInfos -> Tuple.tuple(null, snInfos)));
        }
    }

    private void getSingleRepoSnapshotInfo(SnapshotsInProgress snapshotsInProgress, String repo, String[] snapshots, SnapshotPredicates predicates, boolean ignoreUnavailable, boolean verbose, CancellableTask task, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, SortOrder order, ActionListener<SnapshotsInRepo> listener) {
        HashMap<String, Snapshot> allSnapshotIds = new HashMap<String, Snapshot>();
        ArrayList<SnapshotInfo> currentSnapshots = new ArrayList<SnapshotInfo>();
        for (SnapshotInfo snapshotInfo : TransportGetSnapshotsAction.currentSnapshots(snapshotsInProgress, repo)) {
            Snapshot snapshot = snapshotInfo.snapshot();
            allSnapshotIds.put(snapshot.getSnapshotId().getName(), snapshot);
            currentSnapshots.add(snapshotInfo);
        }
        StepListener<RepositoryData> repositoryDataListener = new StepListener<RepositoryData>();
        if (this.isCurrentSnapshotsOnly(snapshots)) {
            repositoryDataListener.onResponse(null);
        } else {
            this.repositoriesService.getRepositoryData(repo, repositoryDataListener);
        }
        repositoryDataListener.whenComplete(repositoryData -> this.loadSnapshotInfos(snapshotsInProgress, repo, snapshots, ignoreUnavailable, verbose, (Map<String, Snapshot>)allSnapshotIds, (List<SnapshotInfo>)currentSnapshots, (RepositoryData)repositoryData, task, sortBy, after, order, predicates, listener), listener::onFailure);
    }

    private static List<SnapshotInfo> currentSnapshots(SnapshotsInProgress snapshotsInProgress, String repositoryName) {
        ArrayList<SnapshotInfo> snapshotList = new ArrayList<SnapshotInfo>();
        List<SnapshotsInProgress.Entry> entries = SnapshotsService.currentSnapshots(snapshotsInProgress, repositoryName, Collections.emptyList());
        for (SnapshotsInProgress.Entry entry : entries) {
            snapshotList.add(SnapshotInfo.inProgress(entry));
        }
        return snapshotList;
    }

    private void loadSnapshotInfos(SnapshotsInProgress snapshotsInProgress, String repo, String[] snapshots, boolean ignoreUnavailable, boolean verbose, Map<String, Snapshot> allSnapshotIds, List<SnapshotInfo> currentSnapshots, @Nullable RepositoryData repositoryData, CancellableTask task, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, SortOrder order, SnapshotPredicates predicates, ActionListener<SnapshotsInRepo> listener) {
        if (task.notifyIfCancelled(listener)) {
            return;
        }
        if (repositoryData != null) {
            for (SnapshotId snapshotId : repositoryData.getSnapshotIds()) {
                if (!predicates.test(snapshotId, repositoryData)) continue;
                allSnapshotIds.put(snapshotId.getName(), new Snapshot(repo, snapshotId));
            }
        }
        HashSet<Snapshot> toResolve = new HashSet<Snapshot>();
        if (TransportGetRepositoriesAction.isMatchAll(snapshots)) {
            toResolve.addAll(allSnapshotIds.values());
        } else {
            Snapshot snapshot;
            ArrayList<String> includePatterns = new ArrayList<String>();
            ArrayList<String> excludePatterns = new ArrayList<String>();
            boolean hasCurrent = false;
            boolean seenWildcard = false;
            for (String snapshotOrPattern : snapshots) {
                if (seenWildcard && snapshotOrPattern.length() > 1 && snapshotOrPattern.startsWith("-")) {
                    excludePatterns.add(snapshotOrPattern.substring(1));
                    continue;
                }
                if (Regex.isSimpleMatchPattern(snapshotOrPattern)) {
                    seenWildcard = true;
                    includePatterns.add(snapshotOrPattern);
                    continue;
                }
                if ("_current".equalsIgnoreCase(snapshotOrPattern)) {
                    hasCurrent = true;
                    seenWildcard = true;
                    continue;
                }
                if (!ignoreUnavailable && !allSnapshotIds.containsKey(snapshotOrPattern)) {
                    throw new SnapshotMissingException(repo, snapshotOrPattern);
                }
                includePatterns.add(snapshotOrPattern);
            }
            String[] includes = includePatterns.toArray(Strings.EMPTY_ARRAY);
            String[] excludes = excludePatterns.toArray(Strings.EMPTY_ARRAY);
            for (Map.Entry<String, Snapshot> entry : allSnapshotIds.entrySet()) {
                snapshot = entry.getValue();
                if (toResolve.contains(snapshot) || !Regex.simpleMatch(includes, entry.getKey()) || Regex.simpleMatch(excludes, entry.getKey())) continue;
                toResolve.add(snapshot);
            }
            if (hasCurrent) {
                for (SnapshotInfo snapshotInfo : currentSnapshots) {
                    snapshot = snapshotInfo.snapshot();
                    if (Regex.simpleMatch(excludes, snapshot.getSnapshotId().getName())) continue;
                    toResolve.add(snapshot);
                }
            }
            if (toResolve.isEmpty() && !ignoreUnavailable && !this.isCurrentSnapshotsOnly(snapshots)) {
                throw new SnapshotMissingException(repo, snapshots[0]);
            }
        }
        if (verbose) {
            this.snapshots(snapshotsInProgress, repo, Collections.unmodifiableList(toResolve.stream().map(Snapshot::getSnapshotId).collect(Collectors.toList())), ignoreUnavailable, task, sortBy, after, order, predicates, listener);
        } else {
            assert (predicates.isMatchAll()) : "filtering is not supported in non-verbose mode";
            SnapshotsInRepo snapshotInfos = repositoryData != null ? TransportGetSnapshotsAction.buildSimpleSnapshotInfos(toResolve, repo, repositoryData, currentSnapshots, sortBy, after, order) : TransportGetSnapshotsAction.sortSnapshots(currentSnapshots.stream().map(SnapshotInfo::basic).collect(Collectors.toList()), sortBy, after, 0, -1, order);
            listener.onResponse(snapshotInfos);
        }
    }

    private void snapshots(SnapshotsInProgress snapshotsInProgress, String repositoryName, Collection<SnapshotId> snapshotIds, boolean ignoreUnavailable, CancellableTask task, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, SortOrder order, SnapshotPredicates predicate, ActionListener<SnapshotsInRepo> listener) {
        Repository repository;
        if (task.notifyIfCancelled(listener)) {
            return;
        }
        HashSet<SnapshotInfo> snapshotSet = new HashSet<SnapshotInfo>();
        HashSet<SnapshotId> snapshotIdsToIterate = new HashSet<SnapshotId>(snapshotIds);
        List<SnapshotsInProgress.Entry> entries = SnapshotsService.currentSnapshots(snapshotsInProgress, repositoryName, snapshotIdsToIterate.stream().map(SnapshotId::getName).collect(Collectors.toList()));
        for (SnapshotsInProgress.Entry entry : entries) {
            SnapshotInfo snapshotInfo2;
            if (!snapshotIdsToIterate.remove(entry.snapshot().getSnapshotId()) || !predicate.test(snapshotInfo2 = SnapshotInfo.inProgress(entry))) continue;
            snapshotSet.add(SnapshotInfo.inProgress(entry));
        }
        List<Object> snapshotInfos = snapshotIdsToIterate.isEmpty() ? Collections.emptyList() : Collections.synchronizedList(new ArrayList());
        ActionListener<Void> allDoneListener = listener.delegateFailure((l, v) -> {
            ArrayList<SnapshotInfo> snapshotList = new ArrayList<SnapshotInfo>(snapshotInfos);
            snapshotList.addAll(snapshotSet);
            listener.onResponse(TransportGetSnapshotsAction.sortSnapshots(snapshotList, sortBy, after, 0, -1, order));
        });
        if (snapshotIdsToIterate.isEmpty()) {
            allDoneListener.onResponse(null);
            return;
        }
        try {
            repository = this.repositoriesService.repository(repositoryName);
        }
        catch (RepositoryMissingException e) {
            listener.onFailure(e);
            return;
        }
        repository.getSnapshotInfo(new GetSnapshotInfoContext(snapshotIdsToIterate, !ignoreUnavailable, task::isCancelled, (context, snapshotInfo) -> {
            if (predicate.test((SnapshotInfo)snapshotInfo)) {
                snapshotInfos.add(snapshotInfo);
            }
        }, allDoneListener));
    }

    private boolean isCurrentSnapshotsOnly(String[] snapshots) {
        return snapshots.length == 1 && "_current".equalsIgnoreCase(snapshots[0]);
    }

    private static SnapshotsInRepo buildSimpleSnapshotInfos(Set<Snapshot> toResolve, String repoName, RepositoryData repositoryData, List<SnapshotInfo> currentSnapshots, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, SortOrder order) {
        ArrayList<SnapshotInfo> snapshotInfos = new ArrayList<SnapshotInfo>();
        for (SnapshotInfo snapshotInfo : currentSnapshots) {
            if (!toResolve.remove(snapshotInfo.snapshot())) continue;
            snapshotInfos.add(snapshotInfo.basic());
        }
        HashMap snapshotsToIndices = new HashMap();
        for (IndexId indexId : repositoryData.getIndices().values()) {
            for (SnapshotId snapshotId : repositoryData.getSnapshots(indexId)) {
                if (!toResolve.contains(new Snapshot(repoName, snapshotId))) continue;
                snapshotsToIndices.computeIfAbsent(snapshotId, k -> new ArrayList()).add(indexId.getName());
            }
        }
        for (Snapshot snapshot : toResolve) {
            List<String> indices = snapshotsToIndices.getOrDefault(snapshot.getSnapshotId(), Collections.emptyList());
            CollectionUtil.timSort(indices);
            snapshotInfos.add(new SnapshotInfo(snapshot, indices, Collections.emptyList(), Collections.emptyList(), repositoryData.getSnapshotState(snapshot.getSnapshotId())));
        }
        return TransportGetSnapshotsAction.sortSnapshots(snapshotInfos, sortBy, after, 0, -1, order);
    }

    private static long getDuration(SnapshotId snapshotId, RepositoryData repositoryData) {
        RepositoryData.SnapshotDetails details = repositoryData.getSnapshotDetails(snapshotId);
        if (details == null) {
            return -1L;
        }
        long startTime = details.getStartTimeMillis();
        if (startTime == -1L) {
            return -1L;
        }
        long endTime = details.getEndTimeMillis();
        if (endTime == -1L) {
            return -1L;
        }
        return endTime - startTime;
    }

    private static long getStartTime(SnapshotId snapshotId, RepositoryData repositoryData) {
        RepositoryData.SnapshotDetails details = repositoryData.getSnapshotDetails(snapshotId);
        return details == null ? -1L : details.getStartTimeMillis();
    }

    private static int indexCount(SnapshotId snapshotId, RepositoryData repositoryData) {
        int indexCount = 0;
        for (IndexId idx : repositoryData.getIndices().values()) {
            if (!repositoryData.getSnapshots(idx).contains(snapshotId)) continue;
            ++indexCount;
        }
        return indexCount;
    }

    private static SnapshotsInRepo sortSnapshots(List<SnapshotInfo> snapshotInfos, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, int offset, int size, SortOrder order) {
        Comparator<SnapshotInfo> comparator;
        switch (sortBy) {
            case START_TIME: {
                comparator = BY_START_TIME;
                break;
            }
            case NAME: {
                comparator = BY_NAME;
                break;
            }
            case DURATION: {
                comparator = BY_DURATION;
                break;
            }
            case INDICES: {
                comparator = BY_INDICES_COUNT;
                break;
            }
            case SHARDS: {
                comparator = BY_SHARDS_COUNT;
                break;
            }
            case FAILED_SHARDS: {
                comparator = BY_FAILED_SHARDS_COUNT;
                break;
            }
            case REPOSITORY: {
                comparator = BY_REPOSITORY;
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected sort column [" + (Object)((Object)sortBy) + "]"));
            }
        }
        Stream<Object> infos = snapshotInfos.stream();
        if (after != null) {
            assert (offset == 0) : "can't combine after and offset but saw [" + after + "] and offset [" + offset + "]";
            infos = infos.filter(TransportGetSnapshotsAction.buildAfterPredicate(sortBy, after, order));
        }
        infos = infos.sorted(order == SortOrder.DESC ? comparator.reversed() : comparator).skip(offset);
        List<SnapshotInfo> allSnapshots = infos.collect(Collectors.toList());
        List<SnapshotInfo> snapshots = size != -1 ? Collections.unmodifiableList(allSnapshots.stream().limit(size + 1).collect(Collectors.toList())) : allSnapshots;
        List<SnapshotInfo> resultSet = size != -1 && size < snapshots.size() ? snapshots.subList(0, size) : snapshots;
        return new SnapshotsInRepo(resultSet, snapshotInfos.size(), allSnapshots.size() - resultSet.size());
    }

    private static Predicate<SnapshotInfo> buildAfterPredicate(GetSnapshotsRequest.SortBy sortBy, GetSnapshotsRequest.After after, SortOrder order) {
        String snapshotName = after.snapshotName();
        String repoName = after.repoName();
        String value = after.value();
        switch (sortBy) {
            case START_TIME: {
                return TransportGetSnapshotsAction.filterByLongOffset(SnapshotInfo::startTime, Long.parseLong(value), snapshotName, repoName, order);
            }
            case NAME: {
                return order == SortOrder.ASC ? info -> TransportGetSnapshotsAction.compareName(snapshotName, repoName, info) < 0 : info -> TransportGetSnapshotsAction.compareName(snapshotName, repoName, info) > 0;
            }
            case DURATION: {
                return TransportGetSnapshotsAction.filterByLongOffset(info -> info.endTime() - info.startTime(), Long.parseLong(value), snapshotName, repoName, order);
            }
            case INDICES: {
                return TransportGetSnapshotsAction.filterByLongOffset(info -> info.indices().size(), Integer.parseInt(value), snapshotName, repoName, order);
            }
            case SHARDS: {
                return TransportGetSnapshotsAction.filterByLongOffset(SnapshotInfo::totalShards, Integer.parseInt(value), snapshotName, repoName, order);
            }
            case FAILED_SHARDS: {
                return TransportGetSnapshotsAction.filterByLongOffset(SnapshotInfo::failedShards, Integer.parseInt(value), snapshotName, repoName, order);
            }
            case REPOSITORY: {
                return order == SortOrder.ASC ? info -> TransportGetSnapshotsAction.compareRepositoryName(snapshotName, repoName, info) < 0 : info -> TransportGetSnapshotsAction.compareRepositoryName(snapshotName, repoName, info) > 0;
            }
        }
        throw new AssertionError((Object)("unexpected sort column [" + (Object)((Object)sortBy) + "]"));
    }

    private static Predicate<SnapshotInfo> filterByLongOffset(ToLongFunction<SnapshotInfo> extractor, long after, String snapshotName, String repoName, SortOrder order) {
        return order == SortOrder.ASC ? info -> {
            long val = extractor.applyAsLong((SnapshotInfo)info);
            return after < val || after == val && TransportGetSnapshotsAction.compareName(snapshotName, repoName, info) < 0;
        } : info -> {
            long val = extractor.applyAsLong((SnapshotInfo)info);
            return after > val || after == val && TransportGetSnapshotsAction.compareName(snapshotName, repoName, info) > 0;
        };
    }

    private static int compareRepositoryName(String name, String repoName, SnapshotInfo info) {
        int res = repoName.compareTo(info.repository());
        if (res != 0) {
            return res;
        }
        return name.compareTo(info.snapshotId().getName());
    }

    private static int compareName(String name, String repoName, SnapshotInfo info) {
        int res = name.compareTo(info.snapshotId().getName());
        if (res != 0) {
            return res;
        }
        return repoName.compareTo(info.repository());
    }

    private static final class SnapshotPredicates {
        private static final SnapshotPredicates MATCH_ALL = new SnapshotPredicates(null, null);
        @Nullable
        private final BiPredicate<SnapshotId, RepositoryData> preflightPredicate;
        @Nullable
        private final Predicate<SnapshotInfo> snapshotPredicate;

        private SnapshotPredicates(@Nullable BiPredicate<SnapshotId, RepositoryData> preflightPredicate, @Nullable Predicate<SnapshotInfo> snapshotPredicate) {
            this.snapshotPredicate = snapshotPredicate;
            this.preflightPredicate = preflightPredicate;
        }

        boolean test(SnapshotId snapshotId, RepositoryData repositoryData) {
            return this.preflightPredicate == null || this.preflightPredicate.test(snapshotId, repositoryData);
        }

        boolean isMatchAll() {
            return this.snapshotPredicate == null;
        }

        boolean test(SnapshotInfo snapshotInfo) {
            return this.snapshotPredicate == null || this.snapshotPredicate.test(snapshotInfo);
        }

        private SnapshotPredicates and(SnapshotPredicates other) {
            return this == MATCH_ALL ? other : (other == MATCH_ALL ? this : new SnapshotPredicates(this.preflightPredicate == null ? other.preflightPredicate : (other.preflightPredicate == null ? this.preflightPredicate : null), this.snapshotPredicate == null ? other.snapshotPredicate : (other.snapshotPredicate == null ? this.snapshotPredicate : null)));
        }

        static SnapshotPredicates fromRequest(GetSnapshotsRequest request) {
            return SnapshotPredicates.getSortValuePredicate(request.fromSortValue(), request.sort(), request.order()).and(SnapshotPredicates.getSlmPredicates(request.policies()));
        }

        private static SnapshotPredicates getSlmPredicates(String[] slmPolicies) {
            if (slmPolicies.length == 0) {
                return MATCH_ALL;
            }
            ArrayList<String> includePatterns = new ArrayList<String>();
            ArrayList<String> excludePatterns = new ArrayList<String>();
            boolean seenWildcard = false;
            boolean matchNoPolicy = false;
            for (String slmPolicy : slmPolicies) {
                if (seenWildcard && slmPolicy.length() > 1 && slmPolicy.startsWith("-")) {
                    excludePatterns.add(slmPolicy.substring(1));
                    continue;
                }
                if (Regex.isSimpleMatchPattern(slmPolicy)) {
                    seenWildcard = true;
                } else if ("_none".equals(slmPolicy)) {
                    matchNoPolicy = true;
                }
                includePatterns.add(slmPolicy);
            }
            String[] includes = includePatterns.toArray(Strings.EMPTY_ARRAY);
            String[] excludes = excludePatterns.toArray(Strings.EMPTY_ARRAY);
            boolean matchWithoutPolicy = matchNoPolicy;
            return new SnapshotPredicates((snapshotId, repositoryData) -> {
                RepositoryData.SnapshotDetails details = repositoryData.getSnapshotDetails((SnapshotId)snapshotId);
                if (details == null || details.getSlmPolicy() == null) {
                    return true;
                }
                String policyFound = details.getSlmPolicy();
                String policy = policyFound.isEmpty() ? null : policyFound;
                return SnapshotPredicates.matchPolicy(includes, excludes, matchWithoutPolicy, policy);
            }, snapshotInfo -> {
                Object policyFound;
                Map<String, Object> metadata = snapshotInfo.userMetadata();
                String policy = metadata == null ? null : ((policyFound = metadata.get("policy")) instanceof String ? (String)policyFound : null);
                return SnapshotPredicates.matchPolicy(includes, excludes, matchWithoutPolicy, policy);
            });
        }

        private static boolean matchPolicy(String[] includes, String[] excludes, boolean matchWithoutPolicy, @Nullable String policy) {
            if (policy == null) {
                return matchWithoutPolicy;
            }
            if (!Regex.simpleMatch(includes, policy)) {
                return false;
            }
            return excludes.length == 0 || !Regex.simpleMatch(excludes, policy);
        }

        private static SnapshotPredicates getSortValuePredicate(String fromSortValue, GetSnapshotsRequest.SortBy sortBy, SortOrder order) {
            if (fromSortValue == null) {
                return MATCH_ALL;
            }
            switch (sortBy) {
                case START_TIME: {
                    long after = Long.parseLong(fromSortValue);
                    return new SnapshotPredicates(order == SortOrder.ASC ? (snapshotId, repositoryData) -> {
                        long startTime = TransportGetSnapshotsAction.getStartTime(snapshotId, repositoryData);
                        return startTime == -1L || after <= startTime;
                    } : (snapshotId, repositoryData) -> {
                        long startTime = TransportGetSnapshotsAction.getStartTime(snapshotId, repositoryData);
                        return startTime == -1L || after >= startTime;
                    }, SnapshotPredicates.filterByLongOffset(SnapshotInfo::startTime, after, order));
                }
                case NAME: {
                    return new SnapshotPredicates(order == SortOrder.ASC ? (snapshotId, repositoryData) -> fromSortValue.compareTo(snapshotId.getName()) <= 0 : (snapshotId, repositoryData) -> fromSortValue.compareTo(snapshotId.getName()) >= 0, null);
                }
                case DURATION: {
                    long afterDuration = Long.parseLong(fromSortValue);
                    return new SnapshotPredicates(order == SortOrder.ASC ? (snapshotId, repositoryData) -> {
                        long duration = TransportGetSnapshotsAction.getDuration(snapshotId, repositoryData);
                        return duration == -1L || afterDuration <= duration;
                    } : (snapshotId, repositoryData) -> {
                        long duration = TransportGetSnapshotsAction.getDuration(snapshotId, repositoryData);
                        return duration == -1L || afterDuration >= duration;
                    }, SnapshotPredicates.filterByLongOffset(info -> info.endTime() - info.startTime(), afterDuration, order));
                }
                case INDICES: {
                    int afterIndexCount = Integer.parseInt(fromSortValue);
                    return new SnapshotPredicates(order == SortOrder.ASC ? (snapshotId, repositoryData) -> afterIndexCount <= TransportGetSnapshotsAction.indexCount(snapshotId, repositoryData) : (snapshotId, repositoryData) -> afterIndexCount >= TransportGetSnapshotsAction.indexCount(snapshotId, repositoryData), null);
                }
                case REPOSITORY: {
                    return MATCH_ALL;
                }
                case SHARDS: {
                    return new SnapshotPredicates(null, SnapshotPredicates.filterByLongOffset(SnapshotInfo::totalShards, Integer.parseInt(fromSortValue), order));
                }
                case FAILED_SHARDS: {
                    return new SnapshotPredicates(null, SnapshotPredicates.filterByLongOffset(SnapshotInfo::failedShards, Integer.parseInt(fromSortValue), order));
                }
            }
            throw new AssertionError((Object)("unexpected sort column [" + (Object)((Object)sortBy) + "]"));
        }

        private static Predicate<SnapshotInfo> filterByLongOffset(ToLongFunction<SnapshotInfo> extractor, long after, SortOrder order) {
            return order == SortOrder.ASC ? info -> after <= extractor.applyAsLong((SnapshotInfo)info) : info -> after >= extractor.applyAsLong((SnapshotInfo)info);
        }
    }

    private static final class SnapshotsInRepo {
        private final List<SnapshotInfo> snapshotInfos;
        private final int totalCount;
        private final int remaining;

        SnapshotsInRepo(List<SnapshotInfo> snapshotInfos, int totalCount, int remaining) {
            this.snapshotInfos = snapshotInfos;
            this.totalCount = totalCount;
            this.remaining = remaining;
        }
    }
}

