/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregator;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregatorSupplier;
import org.elasticsearch.search.aggregations.metrics.GlobalOrdCardinalityAggregator;
import org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;

class CardinalityAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final Long precisionThreshold;
    private final CardinalityAggregatorSupplier aggregatorSupplier;

    CardinalityAggregatorFactory(String name, ValuesSourceConfig config, Long precisionThreshold, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, CardinalityAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.aggregatorSupplier = aggregatorSupplier;
        this.precisionThreshold = precisionThreshold;
    }

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(CardinalityAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.ALL_CORE, (name, valuesSourceConfig, precision, context, parent, metadata) -> {
            ValuesSource.Bytes.WithOrdinals source;
            ValuesSource valuesSource;
            if (valuesSourceConfig.hasValues() && (valuesSource = valuesSourceConfig.getValuesSource()) instanceof ValuesSource.Bytes.WithOrdinals && CardinalityAggregatorFactory.useGlobalOrds(context, source = (ValuesSource.Bytes.WithOrdinals)valuesSource, precision)) {
                long maxOrd = source.globalMaxOrd(context.searcher());
                return new GlobalOrdCardinalityAggregator(name, source, precision, Math.toIntExact(maxOrd), context, parent, metadata);
            }
            return new CardinalityAggregator(name, valuesSourceConfig, precision, context, parent, (Map<String, Object>)metadata);
        }, true);
    }

    private static boolean useGlobalOrds(AggregationContext context, ValuesSource.Bytes.WithOrdinals source, int precision) throws IOException {
        List leaves = context.searcher().getIndexReader().leaves();
        long total = 0L;
        for (LeafReaderContext leaf : leaves) {
            total += source.ordinalsValues(leaf).getValueCount();
        }
        long countsMemoryUsage = HyperLogLogPlusPlus.memoryUsage(precision);
        long ordinalsMemoryUsage = leaves.size() == 1 ? total * 4L : total * 3L;
        return ordinalsMemoryUsage < countsMemoryUsage;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new CardinalityAggregator(this.name, this.config, this.precision(), this.context, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregatorSupplier.build(this.name, this.config, this.precision(), this.context, parent, metadata);
    }

    private int precision() {
        return this.precisionThreshold == null ? 14 : HyperLogLogPlusPlus.precisionFromThreshold(this.precisionThreshold);
    }
}

