/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.store.LuceneFilesExtensions;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class SegmentsStats
implements Writeable,
ToXContentFragment {
    private long count;
    private long memoryInBytes;
    private long termsMemoryInBytes;
    private long storedFieldsMemoryInBytes;
    private long termVectorsMemoryInBytes;
    private long normsMemoryInBytes;
    private long pointsMemoryInBytes;
    private long docValuesMemoryInBytes;
    private long indexWriterMemoryInBytes;
    private long versionMapMemoryInBytes;
    private long maxUnsafeAutoIdTimestamp = Long.MIN_VALUE;
    private long bitsetMemoryInBytes;
    private ImmutableOpenMap<String, FileStats> files = ImmutableOpenMap.of();

    public SegmentsStats() {
    }

    public SegmentsStats(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.memoryInBytes = in.readLong();
        this.termsMemoryInBytes = in.readLong();
        this.storedFieldsMemoryInBytes = in.readLong();
        this.termVectorsMemoryInBytes = in.readLong();
        this.normsMemoryInBytes = in.readLong();
        this.pointsMemoryInBytes = in.readLong();
        this.docValuesMemoryInBytes = in.readLong();
        this.indexWriterMemoryInBytes = in.readLong();
        this.versionMapMemoryInBytes = in.readLong();
        this.bitsetMemoryInBytes = in.readLong();
        this.maxUnsafeAutoIdTimestamp = in.readLong();
        int size = in.readVInt();
        ImmutableOpenMap.Builder<String, FileStats> files = ImmutableOpenMap.builder(size);
        for (int i = 0; i < size; ++i) {
            FileStats file = new FileStats(in);
            files.put(file.getExt(), file);
        }
        this.files = files.build();
    }

    public void add(long count, long memoryInBytes) {
        this.count += count;
        this.memoryInBytes += memoryInBytes;
    }

    public void addTermsMemoryInBytes(long termsMemoryInBytes) {
        this.termsMemoryInBytes += termsMemoryInBytes;
    }

    public void addStoredFieldsMemoryInBytes(long storedFieldsMemoryInBytes) {
        this.storedFieldsMemoryInBytes += storedFieldsMemoryInBytes;
    }

    public void addTermVectorsMemoryInBytes(long termVectorsMemoryInBytes) {
        this.termVectorsMemoryInBytes += termVectorsMemoryInBytes;
    }

    public void addNormsMemoryInBytes(long normsMemoryInBytes) {
        this.normsMemoryInBytes += normsMemoryInBytes;
    }

    public void addPointsMemoryInBytes(long pointsMemoryInBytes) {
        this.pointsMemoryInBytes += pointsMemoryInBytes;
    }

    public void addDocValuesMemoryInBytes(long docValuesMemoryInBytes) {
        this.docValuesMemoryInBytes += docValuesMemoryInBytes;
    }

    public void addIndexWriterMemoryInBytes(long indexWriterMemoryInBytes) {
        this.indexWriterMemoryInBytes += indexWriterMemoryInBytes;
    }

    public void addVersionMapMemoryInBytes(long versionMapMemoryInBytes) {
        this.versionMapMemoryInBytes += versionMapMemoryInBytes;
    }

    void updateMaxUnsafeAutoIdTimestamp(long maxUnsafeAutoIdTimestamp) {
        this.maxUnsafeAutoIdTimestamp = Math.max(maxUnsafeAutoIdTimestamp, this.maxUnsafeAutoIdTimestamp);
    }

    public void addBitsetMemoryInBytes(long bitsetMemoryInBytes) {
        this.bitsetMemoryInBytes += bitsetMemoryInBytes;
    }

    public void addFiles(ImmutableOpenMap<String, FileStats> files) {
        ImmutableOpenMap.Builder<String, FileStats> map = ImmutableOpenMap.builder(this.files);
        for (ObjectObjectCursor<String, FileStats> objectObjectCursor : files) {
            String extension = (String)objectObjectCursor.key;
            if (map.containsKey(extension)) {
                FileStats previous = map.get(extension);
                map.put(extension, FileStats.merge(previous, (FileStats)objectObjectCursor.value));
                continue;
            }
            map.put(extension, (FileStats)objectObjectCursor.value);
        }
        this.files = map.build();
    }

    public void add(SegmentsStats mergeStats) {
        if (mergeStats == null) {
            return;
        }
        this.updateMaxUnsafeAutoIdTimestamp(mergeStats.maxUnsafeAutoIdTimestamp);
        this.add(mergeStats.count, mergeStats.memoryInBytes);
        this.addTermsMemoryInBytes(mergeStats.termsMemoryInBytes);
        this.addStoredFieldsMemoryInBytes(mergeStats.storedFieldsMemoryInBytes);
        this.addTermVectorsMemoryInBytes(mergeStats.termVectorsMemoryInBytes);
        this.addNormsMemoryInBytes(mergeStats.normsMemoryInBytes);
        this.addPointsMemoryInBytes(mergeStats.pointsMemoryInBytes);
        this.addDocValuesMemoryInBytes(mergeStats.docValuesMemoryInBytes);
        this.addIndexWriterMemoryInBytes(mergeStats.indexWriterMemoryInBytes);
        this.addVersionMapMemoryInBytes(mergeStats.versionMapMemoryInBytes);
        this.addBitsetMemoryInBytes(mergeStats.bitsetMemoryInBytes);
        this.addFiles(mergeStats.files);
    }

    public long getCount() {
        return this.count;
    }

    public long getMemoryInBytes() {
        return this.memoryInBytes;
    }

    public ByteSizeValue getMemory() {
        return new ByteSizeValue(this.memoryInBytes);
    }

    public long getTermsMemoryInBytes() {
        return this.termsMemoryInBytes;
    }

    private ByteSizeValue getTermsMemory() {
        return new ByteSizeValue(this.termsMemoryInBytes);
    }

    public long getStoredFieldsMemoryInBytes() {
        return this.storedFieldsMemoryInBytes;
    }

    private ByteSizeValue getStoredFieldsMemory() {
        return new ByteSizeValue(this.storedFieldsMemoryInBytes);
    }

    public long getTermVectorsMemoryInBytes() {
        return this.termVectorsMemoryInBytes;
    }

    private ByteSizeValue getTermVectorsMemory() {
        return new ByteSizeValue(this.termVectorsMemoryInBytes);
    }

    public long getNormsMemoryInBytes() {
        return this.normsMemoryInBytes;
    }

    private ByteSizeValue getNormsMemory() {
        return new ByteSizeValue(this.normsMemoryInBytes);
    }

    public long getPointsMemoryInBytes() {
        return this.pointsMemoryInBytes;
    }

    private ByteSizeValue getPointsMemory() {
        return new ByteSizeValue(this.pointsMemoryInBytes);
    }

    public long getDocValuesMemoryInBytes() {
        return this.docValuesMemoryInBytes;
    }

    private ByteSizeValue getDocValuesMemory() {
        return new ByteSizeValue(this.docValuesMemoryInBytes);
    }

    public long getIndexWriterMemoryInBytes() {
        return this.indexWriterMemoryInBytes;
    }

    public ByteSizeValue getIndexWriterMemory() {
        return new ByteSizeValue(this.indexWriterMemoryInBytes);
    }

    public long getVersionMapMemoryInBytes() {
        return this.versionMapMemoryInBytes;
    }

    public ByteSizeValue getVersionMapMemory() {
        return new ByteSizeValue(this.versionMapMemoryInBytes);
    }

    public long getBitsetMemoryInBytes() {
        return this.bitsetMemoryInBytes;
    }

    public ByteSizeValue getBitsetMemory() {
        return new ByteSizeValue(this.bitsetMemoryInBytes);
    }

    public ImmutableOpenMap<String, FileStats> getFiles() {
        return this.files;
    }

    public long getMaxUnsafeAutoIdTimestamp() {
        return this.maxUnsafeAutoIdTimestamp;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("segments");
        builder.field("count", this.count);
        builder.humanReadableField("memory_in_bytes", "memory", (Object)this.getMemory());
        builder.humanReadableField("terms_memory_in_bytes", "terms_memory", (Object)this.getTermsMemory());
        builder.humanReadableField("stored_fields_memory_in_bytes", "stored_fields_memory", (Object)this.getStoredFieldsMemory());
        builder.humanReadableField("term_vectors_memory_in_bytes", "term_vectors_memory", (Object)this.getTermVectorsMemory());
        builder.humanReadableField("norms_memory_in_bytes", "norms_memory", (Object)this.getNormsMemory());
        builder.humanReadableField("points_memory_in_bytes", "points_memory", (Object)this.getPointsMemory());
        builder.humanReadableField("doc_values_memory_in_bytes", "doc_values_memory", (Object)this.getDocValuesMemory());
        builder.humanReadableField("index_writer_memory_in_bytes", "index_writer_memory", (Object)this.getIndexWriterMemory());
        builder.humanReadableField("version_map_memory_in_bytes", "version_map_memory", (Object)this.getVersionMapMemory());
        builder.humanReadableField("fixed_bit_set_memory_in_bytes", "fixed_bit_set", (Object)this.getBitsetMemory());
        builder.field("max_unsafe_auto_id_timestamp", this.maxUnsafeAutoIdTimestamp);
        builder.startObject("file_sizes");
        for (ObjectObjectCursor<String, FileStats> objectObjectCursor : this.files) {
            ((FileStats)objectObjectCursor.value).toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeLong(this.memoryInBytes);
        out.writeLong(this.termsMemoryInBytes);
        out.writeLong(this.storedFieldsMemoryInBytes);
        out.writeLong(this.termVectorsMemoryInBytes);
        out.writeLong(this.normsMemoryInBytes);
        out.writeLong(this.pointsMemoryInBytes);
        out.writeLong(this.docValuesMemoryInBytes);
        out.writeLong(this.indexWriterMemoryInBytes);
        out.writeLong(this.versionMapMemoryInBytes);
        out.writeLong(this.bitsetMemoryInBytes);
        out.writeLong(this.maxUnsafeAutoIdTimestamp);
        out.writeVInt(this.files.size());
        for (FileStats file : this.files.values()) {
            file.writeTo(out);
        }
    }

    public void clearFiles() {
        this.files = ImmutableOpenMap.of();
    }

    public static class FileStats
    implements Writeable,
    ToXContentFragment {
        private final String ext;
        private final long total;
        private final long count;
        private final long min;
        private final long max;

        FileStats(StreamInput in) throws IOException {
            if (in.getVersion().onOrAfter(Version.V_7_13_0)) {
                this.ext = in.readString();
                this.total = in.readVLong();
                this.count = in.readVLong();
                this.min = in.readVLong();
                this.max = in.readVLong();
            } else {
                this.ext = in.readString();
                this.total = in.readLong();
                this.count = 0L;
                this.min = 0L;
                this.max = 0L;
            }
        }

        public FileStats(String ext, long total, long count, long min, long max) {
            this.ext = ext;
            this.total = total;
            this.count = count;
            this.min = min;
            this.max = max;
        }

        public String getExt() {
            return this.ext;
        }

        public long getCount() {
            return this.count;
        }

        public long getTotal() {
            return this.total;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().onOrAfter(Version.V_7_13_0)) {
                out.writeString(this.ext);
                out.writeVLong(this.total);
                out.writeVLong(this.count);
                out.writeVLong(this.min);
                out.writeVLong(this.max);
            } else {
                out.writeString(this.ext);
                out.writeLong(this.total);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            long roundedAverage = this.count > 0L ? Math.round((double)this.total / (double)this.count) : 0L;
            LuceneFilesExtensions extension = LuceneFilesExtensions.fromExtension(this.ext);
            String name = extension != null ? extension.getExtension() : "others";
            String desc = extension != null ? extension.getDescription() : "Others";
            builder.startObject(name);
            builder.field("description", desc);
            builder.humanReadableField("size_in_bytes", "size", (Object)ByteSizeValue.ofBytes(this.total));
            builder.humanReadableField("min_size_in_bytes", "min_size", (Object)ByteSizeValue.ofBytes(this.min));
            builder.humanReadableField("max_size_in_bytes", "max_size", (Object)ByteSizeValue.ofBytes(this.max));
            builder.humanReadableField("average_size_in_bytes", "average_size", (Object)ByteSizeValue.ofBytes(roundedAverage));
            builder.field("count", this.count);
            builder.endObject();
            return builder;
        }

        public static FileStats merge(FileStats o1, FileStats o2) {
            assert (o1 != null && o1.ext != null) : o1;
            assert (o2 != null && o2.ext != null) : o2;
            assert (o1.ext.equals(o2.ext)) : o1 + " vs " + o2;
            return new FileStats(o1.ext, Math.addExact(o1.total, o2.total), Math.addExact(o1.count, o2.count), Math.min(o1.min, o2.min), Math.max(o1.max, o2.max));
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    static final class Fields {
        static final String SEGMENTS = "segments";
        static final String COUNT = "count";
        static final String MEMORY = "memory";
        static final String MEMORY_IN_BYTES = "memory_in_bytes";
        static final String TERMS_MEMORY = "terms_memory";
        static final String TERMS_MEMORY_IN_BYTES = "terms_memory_in_bytes";
        static final String STORED_FIELDS_MEMORY = "stored_fields_memory";
        static final String STORED_FIELDS_MEMORY_IN_BYTES = "stored_fields_memory_in_bytes";
        static final String TERM_VECTORS_MEMORY = "term_vectors_memory";
        static final String TERM_VECTORS_MEMORY_IN_BYTES = "term_vectors_memory_in_bytes";
        static final String NORMS_MEMORY = "norms_memory";
        static final String NORMS_MEMORY_IN_BYTES = "norms_memory_in_bytes";
        static final String POINTS_MEMORY = "points_memory";
        static final String POINTS_MEMORY_IN_BYTES = "points_memory_in_bytes";
        static final String DOC_VALUES_MEMORY = "doc_values_memory";
        static final String DOC_VALUES_MEMORY_IN_BYTES = "doc_values_memory_in_bytes";
        static final String INDEX_WRITER_MEMORY = "index_writer_memory";
        static final String INDEX_WRITER_MEMORY_IN_BYTES = "index_writer_memory_in_bytes";
        static final String VERSION_MAP_MEMORY = "version_map_memory";
        static final String VERSION_MAP_MEMORY_IN_BYTES = "version_map_memory_in_bytes";
        static final String MAX_UNSAFE_AUTO_ID_TIMESTAMP = "max_unsafe_auto_id_timestamp";
        static final String FIXED_BIT_SET = "fixed_bit_set";
        static final String FIXED_BIT_SET_MEMORY_IN_BYTES = "fixed_bit_set_memory_in_bytes";
        static final String FILE_SIZES = "file_sizes";

        Fields() {
        }
    }
}

