/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.util.function.Supplier;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentLocation;

public class LoggingDeprecationHandler
implements DeprecationHandler {
    public static final LoggingDeprecationHandler INSTANCE = new LoggingDeprecationHandler();
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ParseField.class);

    private LoggingDeprecationHandler() {
    }

    public void usedDeprecatedName(String parserName, Supplier<XContentLocation> location, String usedName, String modernName) {
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        deprecationLogger.critical(DeprecationCategory.API, "deprecated_field_" + usedName, "{}Deprecated field [{}] used, expected [{}] instead", prefix, usedName, modernName);
    }

    public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName, String replacedWith) {
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        deprecationLogger.critical(DeprecationCategory.API, "deprecated_field_" + usedName, "{}Deprecated field [{}] used, replaced by [{}]", prefix, usedName, replacedWith);
    }

    public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName) {
        String prefix = parserName == null ? "" : "[" + parserName + "][" + location.get() + "] ";
        deprecationLogger.critical(DeprecationCategory.API, "deprecated_field_" + usedName, "{}Deprecated field [{}] used, this field is unused and will be removed entirely", prefix, usedName);
    }
}

