/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.TransportResponse;

public abstract class BaseNodeResponse
extends TransportResponse {
    private final DiscoveryNode node;

    protected BaseNodeResponse(StreamInput in, @Nullable DiscoveryNode node) throws IOException {
        super(in);
        DiscoveryNode remoteNode = new DiscoveryNode(in);
        if (node == null) {
            this.node = remoteNode;
        } else {
            assert (remoteNode.equals(node)) : remoteNode + " vs " + node;
            this.node = node;
        }
    }

    protected BaseNodeResponse(StreamInput in) throws IOException {
        this(in, null);
    }

    protected BaseNodeResponse(DiscoveryNode node) {
        assert (node != null);
        this.node = node;
    }

    public DiscoveryNode getNode() {
        return this.node;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.node.writeTo(out);
    }
}

