/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.search;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.input.search.ExecutableSearchInput;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;

public class SearchInput
implements Input {
    public static final String TYPE = "search";
    private final WatcherSearchTemplateRequest request;
    @Nullable
    private final Set<String> extractKeys;
    @Nullable
    private final TimeValue timeout;
    @Nullable
    private final ZoneId dynamicNameTimeZone;

    public SearchInput(WatcherSearchTemplateRequest request, @Nullable Set<String> extractKeys, @Nullable TimeValue timeout, @Nullable ZoneId dynamicNameTimeZone) {
        this.request = request;
        this.extractKeys = extractKeys;
        this.timeout = timeout;
        this.dynamicNameTimeZone = dynamicNameTimeZone;
    }

    public String type() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchInput that = (SearchInput)o;
        return Objects.equals(this.request, that.request) && Objects.equals(this.extractKeys, that.extractKeys) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.dynamicNameTimeZone, that.dynamicNameTimeZone);
    }

    public int hashCode() {
        int result = this.request != null ? this.request.hashCode() : 0;
        result = 31 * result + (this.extractKeys != null ? this.extractKeys.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        result = 31 * result + (this.dynamicNameTimeZone != null ? this.dynamicNameTimeZone.hashCode() : 0);
        return result;
    }

    public WatcherSearchTemplateRequest getRequest() {
        return this.request;
    }

    public Set<String> getExtractKeys() {
        return this.extractKeys;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public ZoneId getDynamicNameTimeZone() {
        return this.dynamicNameTimeZone;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.request != null) {
            builder.field(Field.REQUEST.getPreferredName(), (ToXContent)this.request);
        }
        if (this.extractKeys != null) {
            builder.field(Field.EXTRACT.getPreferredName(), this.extractKeys);
        }
        if (this.timeout != null) {
            builder.humanReadableField(Field.TIMEOUT.getPreferredName(), Field.TIMEOUT_HUMAN.getPreferredName(), (Object)this.timeout);
        }
        if (this.dynamicNameTimeZone != null) {
            builder.field(Field.DYNAMIC_NAME_TIMEZONE.getPreferredName(), (Object)this.dynamicNameTimeZone);
        }
        builder.endObject();
        return builder;
    }

    public static SearchInput parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        WatcherSearchTemplateRequest request = null;
        HashSet<String> extract = null;
        TimeValue timeout = null;
        ZoneId dynamicNameTimeZone = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.REQUEST.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    request = WatcherSearchTemplateRequest.fromXContent(parser, ExecutableSearchInput.DEFAULT_SEARCH_TYPE);
                    continue;
                }
                catch (ElasticsearchParseException srpe) {
                    throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. failed to parse [{}]", (Throwable)srpe, new Object[]{TYPE, watchId, currentFieldName});
                }
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (Field.EXTRACT.match(currentFieldName, parser.getDeprecationHandler())) {
                    extract = new HashSet<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            extract.add(parser.text());
                            continue;
                        }
                        throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. expected a string value in [{}] array, but found [{}] instead", new Object[]{TYPE, watchId, currentFieldName, token});
                    }
                    continue;
                }
                throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. unexpected array field [{}]", new Object[]{TYPE, watchId, currentFieldName});
            }
            if (Field.TIMEOUT.match(currentFieldName, parser.getDeprecationHandler())) {
                timeout = TimeValue.timeValueMillis((long)parser.longValue());
                continue;
            }
            if (Field.TIMEOUT_HUMAN.match(currentFieldName, parser.getDeprecationHandler())) {
                timeout = WatcherDateTimeUtils.parseTimeValue((XContentParser)parser, (String)Field.TIMEOUT_HUMAN.toString());
                continue;
            }
            if (Field.DYNAMIC_NAME_TIMEZONE.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    dynamicNameTimeZone = DateUtils.of((String)parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. failed to parse [{}]. must be a string value (e.g. 'UTC' or '+01:00').", new Object[]{TYPE, watchId, currentFieldName});
            }
            throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. unexpected token [{}]", new Object[]{TYPE, watchId, token});
        }
        if (request == null) {
            throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. missing required [{}] field", new Object[]{TYPE, watchId, Field.REQUEST.getPreferredName()});
        }
        return new SearchInput(request, extract, timeout, dynamicNameTimeZone);
    }

    public static Builder builder(WatcherSearchTemplateRequest request) {
        return new Builder(request);
    }

    public static interface Field {
        public static final ParseField REQUEST = new ParseField("request", new String[0]);
        public static final ParseField EXTRACT = new ParseField("extract", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout_in_millis", new String[0]);
        public static final ParseField TIMEOUT_HUMAN = new ParseField("timeout", new String[0]);
        public static final ParseField DYNAMIC_NAME_TIMEZONE = new ParseField("dynamic_name_timezone", new String[0]);
    }

    public static class Builder
    implements Input.Builder<SearchInput> {
        private final WatcherSearchTemplateRequest request;
        private final Set<String> extractKeys = new HashSet<String>();
        private TimeValue timeout;
        private ZoneId dynamicNameTimeZone;

        private Builder(WatcherSearchTemplateRequest request) {
            this.request = request;
        }

        public Builder extractKeys(Collection<String> keys) {
            this.extractKeys.addAll(keys);
            return this;
        }

        public Builder extractKeys(String ... keys) {
            Collections.addAll(this.extractKeys, keys);
            return this;
        }

        public Builder timeout(TimeValue readTimeout) {
            this.timeout = readTimeout;
            return this;
        }

        public Builder dynamicNameTimeZone(ZoneId dynamicNameTimeZone) {
            this.dynamicNameTimeZone = dynamicNameTimeZone;
            return this;
        }

        public SearchInput build() {
            return new SearchInput(this.request, this.extractKeys.isEmpty() ? null : Collections.unmodifiableSet(this.extractKeys), this.timeout, this.dynamicNameTimeZone);
        }
    }

    public static class Result
    extends Input.Result {
        @Nullable
        private final WatcherSearchTemplateRequest request;

        public Result(WatcherSearchTemplateRequest request, Payload payload) {
            super(SearchInput.TYPE, payload);
            this.request = request;
        }

        public Result(@Nullable WatcherSearchTemplateRequest request, Exception e) {
            super(SearchInput.TYPE, e);
            this.request = request;
        }

        public WatcherSearchTemplateRequest executedRequest() {
            return this.request;
        }

        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.request == null) {
                return builder;
            }
            builder.startObject(this.type);
            builder.field(Field.REQUEST.getPreferredName(), (ToXContent)this.request);
            return builder.endObject();
        }
    }
}

